/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.core.impl;

import de.deepamehta.core.impl.DMXObjectModelImpl;
import de.deepamehta.core.model.SimpleValue;
import de.deepamehta.core.model.TopicModel;
import java.util.List;
import java.util.logging.Logger;

class LabelCalculation {
    private static final String LABEL_CHILD_SEPARATOR = " ";
    private static final String LABEL_TOPIC_SEPARATOR = ", ";
    private DMXObjectModelImpl comp;
    private List<String> labelAssocDefUris;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    LabelCalculation(DMXObjectModelImpl comp) {
        this.comp = comp;
        this.labelAssocDefUris = comp.getType().getLabelAssocDefUris();
    }

    void calculate() {
        try {
            StringBuilder builder = new StringBuilder();
            for (String assocDefUri : this.labelAssocDefUris) {
                this.comp.loadChildTopics(assocDefUri, false);
                this.appendLabel(this.calculateChildLabel(assocDefUri), builder, LABEL_CHILD_SEPARATOR);
            }
            this.comp._updateSimpleValue(new SimpleValue(builder.toString()));
        }
        catch (Exception e) {
            throw new RuntimeException("Calculating and updating label of " + this.comp.objectInfo() + " failed (assoc defs involved: " + this.labelAssocDefUris + ")", e);
        }
    }

    private String calculateChildLabel(String assocDefUri) {
        Object value = this.comp.getChildTopicsModel().get(assocDefUri);
        if (value == null) {
            return "";
        }
        if (value instanceof TopicModel) {
            return ((TopicModel)value).getSimpleValue().toString();
        }
        if (value instanceof List) {
            StringBuilder builder = new StringBuilder();
            for (TopicModel childTopic : (List)value) {
                this.appendLabel(childTopic.getSimpleValue().toString(), builder, LABEL_TOPIC_SEPARATOR);
            }
            return builder.toString();
        }
        throw new RuntimeException("Unexpected value in a ChildTopicsModel: " + value);
    }

    private void appendLabel(String label, StringBuilder builder, String separator) {
        if (builder.length() > 0 && label.length() > 0) {
            builder.append(separator);
        }
        builder.append(label);
    }
}

