/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.core.impl;

import de.deepamehta.core.impl.AssociationModelImpl;
import de.deepamehta.core.impl.ChildTopicsModelImpl;
import de.deepamehta.core.impl.DMXObjectModelImpl;
import de.deepamehta.core.impl.LabelCalculation;
import de.deepamehta.core.impl.ModelFactoryImpl;
import de.deepamehta.core.impl.PersistenceLayer;
import de.deepamehta.core.impl.RelatedTopicModelImpl;
import de.deepamehta.core.impl.TopicImpl;
import de.deepamehta.core.impl.TopicModelImpl;
import de.deepamehta.core.impl.TopicReferenceModelImpl;
import de.deepamehta.core.impl.TypeModelImpl;
import de.deepamehta.core.model.AssociationDefinitionModel;
import de.deepamehta.core.model.AssociationModel;
import de.deepamehta.core.model.DMXObjectModel;
import de.deepamehta.core.model.SimpleValue;
import de.deepamehta.core.model.TopicDeletionModel;
import de.deepamehta.core.model.TopicModel;
import de.deepamehta.core.model.TopicReferenceModel;
import de.deepamehta.core.model.TypeModel;
import de.deepamehta.core.util.DMXUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

class ValueIntegrator {
    private DMXObjectModelImpl newValues;
    private DMXObjectModelImpl targetObject;
    private AssociationDefinitionModel assocDef;
    private TypeModelImpl type;
    private boolean isAssoc;
    private boolean isType;
    private boolean isFacetUpdate;
    private List<String> emptyValues = new ArrayList<String>();
    private PersistenceLayer pl;
    private ModelFactoryImpl mf;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    ValueIntegrator(PersistenceLayer pl) {
        this.pl = pl;
        this.mf = pl.mf;
    }

    <M extends DMXObjectModelImpl> UnifiedValue<M> integrate(M newValues, M targetObject, AssociationDefinitionModel assocDef) {
        try {
            this.newValues = newValues;
            this.targetObject = targetObject;
            this.assocDef = assocDef;
            this.isAssoc = newValues instanceof AssociationModel;
            this.isType = newValues instanceof TypeModel;
            boolean bl = this.isFacetUpdate = assocDef != null;
            if (newValues instanceof TopicReferenceModel) {
                return this.unifyRef();
            }
            if (newValues instanceof TopicDeletionModel) {
                return new UnifiedValue(this, null);
            }
            if (newValues.getTypeUri() == null) {
                throw new IllegalArgumentException("Tried to integrate values whose typeUri is not set, newValues=" + newValues + ", targetObject=" + targetObject);
            }
            this.type = newValues.getType();
            DMXObjectModelImpl _value = !this.isFacetUpdate && newValues.isSimple() ? this.integrateSimple() : this.integrateComposite();
            UnifiedValue value = new UnifiedValue(this, _value);
            this.idTransfer(_value);
            return value;
        }
        catch (Exception e) {
            throw new RuntimeException("Value integration failed, newValues=" + newValues + ", targetObject=" + targetObject + ", assocDef=" + assocDef, e);
        }
    }

    private UnifiedValue unifyRef() {
        TopicReferenceModelImpl ref = (TopicReferenceModelImpl)this.newValues;
        if (!ref.isEmptyRef()) {
            TopicModelImpl object = ref.resolve();
            this.logger.fine("Referencing " + object);
            return new UnifiedValue(this, object);
        }
        return new UnifiedValue(this, null);
    }

    private void idTransfer(DMXObjectModelImpl value) {
        if (value != null) {
            if (value.id == -1L) {
                throw new RuntimeException("ID of unification result is not initialized: " + value);
            }
            this.newValues.id = value.id;
        }
    }

    private DMXObjectModelImpl integrateSimple() {
        try {
            if (this.isAssoc || this.isType) {
                return this.storeAssocSimpleValue();
            }
            if (this.newValues.getSimpleValue().toString().isEmpty()) {
                return null;
            }
            return this.unifySimple();
        }
        catch (Exception e) {
            throw new RuntimeException("Simple value integration failed, newValues=" + this.newValues, e);
        }
    }

    private DMXObjectModelImpl storeAssocSimpleValue() {
        if (this.targetObject != null) {
            this.targetObject._updateSimpleValue(this.newValues.getSimpleValue());
            return this.targetObject;
        }
        this.newValues.storeSimpleValue();
        return this.newValues;
    }

    private TopicModelImpl unifySimple() {
        TopicModelImpl topic;
        SimpleValue newValue = this.newValues.getSimpleValue();
        TopicImpl _topic = this.pl.getTopicByValue(this.type.getUri(), newValue);
        TopicModelImpl topicModelImpl = topic = _topic != null ? _topic.getModel() : null;
        if (topic != null) {
            this.logger.info("Reusing simple value " + topic.id + " \"" + newValue + "\" (typeUri=\"" + this.type.uri + "\")");
        } else {
            topic = this.createSimpleTopic();
            this.logger.info("### Creating simple value " + topic.id + " \"" + newValue + "\" (typeUri=\"" + this.type.uri + "\")");
        }
        return topic;
    }

    private DMXObjectModelImpl integrateComposite() {
        try {
            HashMap<String, Object> childTopics = new HashMap<String, Object>();
            ChildTopicsModelImpl _childTopics = this.newValues.getChildTopicsModel();
            for (String assocDefUri : this.assocDefUris()) {
                Object newChildValue = this.isOne(assocDefUri) ? _childTopics.getTopicOrNull(assocDefUri) : _childTopics.getTopicsOrNull(assocDefUri);
                if (newChildValue == null) continue;
                Object childTopic = this.integrateChildValue(newChildValue, assocDefUri);
                if (this.isOne(assocDefUri) && ((UnifiedValue)childTopic).value == null) {
                    this.emptyValues.add(assocDefUri);
                    continue;
                }
                childTopics.put(assocDefUri, childTopic);
            }
            DMXObjectModelImpl value = this.unifyComposite(childTopics);
            if (!this.isFacetUpdate) {
                if (value != null) {
                    new LabelCalculation(value).calculate();
                } else if (this.isAssoc) {
                    this.storeAssocSimpleValue();
                }
            }
            return value;
        }
        catch (Exception e) {
            throw new RuntimeException("Composite value integration failed, newValues=" + this.newValues, e);
        }
    }

    private Iterable<String> assocDefUris() {
        return this.isFacetUpdate ? Arrays.asList(this.assocDef.getAssocDefUri()) : this.type;
    }

    private Object integrateChildValue(Object childValue, String assocDefUri) {
        if (this.isOne(assocDefUri)) {
            return new ValueIntegrator(this.pl).integrate((RelatedTopicModelImpl)childValue, null, null);
        }
        ArrayList<UnifiedValue<Object>> values = new ArrayList<UnifiedValue<Object>>();
        for (RelatedTopicModelImpl value : (List)childValue) {
            values.add(new ValueIntegrator(this.pl).integrate(value, null, null));
        }
        return values;
    }

    private DMXObjectModelImpl unifyComposite(Map<String, Object> childTopics) {
        if (!this.isFacetUpdate && this.isValueType()) {
            return !childTopics.isEmpty() ? this.unifyChildTopics(childTopics, this.type) : null;
        }
        return this.updateAssignments(this.identifyParent(childTopics), childTopics);
    }

    private DMXObjectModelImpl identifyParent(Map<String, Object> childTopics) {
        if (this.targetObject != null) {
            return this.targetObject;
        }
        if (this.isAssoc) {
            if (this.newValues.id == -1L) {
                throw new RuntimeException("newValues has no ID set");
            }
            return this.mf.newAssociationModel(this.newValues.id, null, this.newValues.typeUri, null, null);
        }
        List<String> identityAssocDefUris = this.type.getIdentityAttrs();
        if (identityAssocDefUris.size() > 0) {
            return this.unifyChildTopics(this.identityChildTopics(childTopics, identityAssocDefUris), identityAssocDefUris);
        }
        TopicModelImpl parent = this.createSimpleTopic();
        this.logger.info("### Creating composite (w/o identity attrs) " + parent.id + " (typeUri=\"" + this.type.uri + "\")");
        return parent;
    }

    private Map<String, Object> identityChildTopics(Map<String, Object> childTopics, List<String> identityAssocDefUris) {
        HashMap<String, Object> identityChildTopics = new HashMap<String, Object>();
        for (String assocDefUri : identityAssocDefUris) {
            if (!this.isOne(assocDefUri)) {
                throw new RuntimeException("Cardinality \"many\" identity attributes not supported");
            }
            UnifiedValue childTopic = (UnifiedValue)childTopics.get(assocDefUri);
            if (childTopic.value == null) {
                throw new RuntimeException("Identity child topic \"" + assocDefUri + "\" is missing in " + childTopics.keySet());
            }
            identityChildTopics.put(assocDefUri, childTopic);
        }
        return identityChildTopics;
    }

    private DMXObjectModelImpl updateAssignments(DMXObjectModelImpl parent, Map<String, Object> unifiedChilds) {
        if (!parent.getTypeUri().equals(this.type.getUri())) {
            throw new RuntimeException("Type mismatch: newValues type=\"" + this.type.getUri() + "\", parent type=\"" + parent.getTypeUri() + "\"");
        }
        for (String assocDefUri : this.assocDefUris()) {
            parent.loadChildTopics(this.assocDef(assocDefUri), true);
            Object unifiedChild = unifiedChilds.get(assocDefUri);
            if (this.isOne(assocDefUri)) {
                TopicModel _unifiedChild = unifiedChild != null ? ((UnifiedValue)unifiedChild).value : null;
                this.updateAssignmentsOne(parent, _unifiedChild, assocDefUri);
                continue;
            }
            if (unifiedChild == null) continue;
            this.updateAssignmentsMany(parent, (List)unifiedChild, assocDefUri);
        }
        return parent;
    }

    private void updateAssignmentsOne(DMXObjectModelImpl parent, TopicModel unifiedChild, String assocDefUri) {
        ChildTopicsModelImpl childTopics = parent.getChildTopicsModel();
        RelatedTopicModelImpl oldValue = childTopics.getTopicOrNull(assocDefUri);
        boolean newValueIsEmpty = this.isEmptyValue(assocDefUri);
        boolean deleted = false;
        if (oldValue != null && (newValueIsEmpty || unifiedChild != null && !oldValue.equals(unifiedChild))) {
            oldValue.getRelatingAssociation().delete();
            if (newValueIsEmpty) {
                this.logger.info("### Deleting assignment (assocDefUri=\"" + assocDefUri + "\") from composite " + parent.id + " (typeUri=\"" + this.type.uri + "\")");
                childTopics.remove(assocDefUri);
            }
            deleted = true;
        }
        AssociationModelImpl assoc = null;
        if (!(unifiedChild == null || oldValue != null && oldValue.equals(unifiedChild))) {
            assoc = this.createChildAssociation(parent, unifiedChild, assocDefUri, deleted);
            childTopics.put(assocDefUri, this.mf.newRelatedTopicModel(unifiedChild, (AssociationModel)assoc));
        }
        if (!this.isAssoc) {
            if (assoc == null && oldValue != null && !deleted) {
                assoc = oldValue.getRelatingAssociation();
            }
            if (assoc != null) {
                RelatedTopicModelImpl newChildValue = this.newValues.getChildTopicsModel().getTopicOrNull(assocDefUri);
                this.updateRelatingAssociation(assoc, assocDefUri, newChildValue);
            }
        }
    }

    private void updateAssignmentsMany(DMXObjectModelImpl parent, List<UnifiedValue> unifiedChilds, String assocDefUri) {
        ChildTopicsModelImpl childTopics = parent.getChildTopicsModel();
        List<RelatedTopicModelImpl> oldValues = childTopics.getTopicsOrNull(assocDefUri);
        for (UnifiedValue _unifiedChild : unifiedChilds) {
            TopicModel unifiedChild = (TopicModel)_unifiedChild.value;
            long originalId = _unifiedChild.originalId;
            long newId = unifiedChild != null ? unifiedChild.getId() : -1L;
            RelatedTopicModelImpl oldValue = null;
            if (originalId != -1L) {
                oldValue = this.findTopic(oldValues, originalId);
            }
            boolean deleted = false;
            if (originalId != -1L && (newId == -1L || originalId != newId)) {
                if (newId == -1L) {
                    this.logger.info("### Deleting assignment (assocDefUri=\"" + assocDefUri + "\") from composite " + parent.id + " (typeUri=\"" + this.type.uri + "\")");
                }
                deleted = true;
                oldValue.getRelatingAssociation().delete();
                this.removeTopic(oldValues, originalId);
            }
            AssociationModelImpl assoc = null;
            if (newId != -1L && (originalId == -1L || originalId != newId)) {
                assoc = this.createChildAssociation(parent, unifiedChild, assocDefUri, deleted);
                childTopics.add(assocDefUri, this.mf.newRelatedTopicModel(unifiedChild, (AssociationModel)assoc));
            }
            if (this.isAssoc) continue;
            if (assoc == null && oldValue != null && !deleted) {
                assoc = oldValue.getRelatingAssociation();
            }
            if (assoc == null) continue;
            RelatedTopicModelImpl newValues = (RelatedTopicModelImpl)_unifiedChild._newValues;
            this.updateRelatingAssociation(assoc, assocDefUri, newValues);
        }
    }

    private void updateRelatingAssociation(AssociationModelImpl assoc, String assocDefUri, RelatedTopicModelImpl newValues) {
        try {
            if (newValues != null) {
                AssociationModelImpl _newValues = newValues.getRelatingAssociation();
                _newValues.setRoleModel1(null);
                _newValues.setRoleModel2(null);
                if (_newValues.typeUri != null) {
                    assoc.update(_newValues);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Updating relating assoc " + assoc.id + " (assocDefUri=\"" + assocDefUri + "\") failed, assoc=" + assoc, e);
        }
    }

    private DMXObjectModelImpl unifyChildTopics(Map<String, Object> childTopics, Iterable<String> assocDefUris) {
        List<RelatedTopicModelImpl> candidates = this.parentCandidates(childTopics);
        for (String assocDefUri : assocDefUris) {
            UnifiedValue value = (UnifiedValue)childTopics.get(assocDefUri);
            this.eliminateParentCandidates(candidates, value != null ? (DMXObjectModel)value.value : null, assocDefUri);
            if (!candidates.isEmpty()) continue;
            break;
        }
        switch (candidates.size()) {
            case 0: {
                return this.createCompositeTopic(childTopics);
            }
            case 1: {
                DMXObjectModelImpl comp = candidates.get(0);
                this.logger.info("Reusing composite " + comp.getId() + " (typeUri=\"" + this.type.uri + "\")");
                return comp;
            }
        }
        throw new RuntimeException("ValueIntegrator ambiguity: there are " + candidates.size() + " parents (typeUri=\"" + this.type.uri + "\", " + DMXUtils.idList(candidates) + ") which have the same " + childTopics.values().size() + " child topics " + childTopics.values());
    }

    private List<RelatedTopicModelImpl> parentCandidates(Map<String, Object> childTopics) {
        String assocDefUri = childTopics.keySet().iterator().next();
        if (!this.type.getUri().equals(this.assocDef(assocDefUri).getParentTypeUri())) {
            throw new RuntimeException("Type mismatch: type=\"" + this.type.getUri() + "\", assoc def's parent type=\"" + this.assocDef(assocDefUri).getParentTypeUri() + "\"");
        }
        if (!this.isOne(assocDefUri)) {
            throw new RuntimeException("Unification of cardinality \"many\" values not yet implemented");
        }
        Object childTopic = ((UnifiedValue)childTopics.get((Object)assocDefUri)).value;
        return this.pl.getTopicRelatedTopics(childTopic.getId(), this.assocDef(assocDefUri).getInstanceLevelAssocTypeUri(), "dm4.core.child", "dm4.core.parent", this.type.getUri());
    }

    private void eliminateParentCandidates(List<RelatedTopicModelImpl> candidates, DMXObjectModel childTopic, String assocDefUri) {
        AssociationDefinitionModel assocDef = this.assocDef(assocDefUri);
        Iterator<RelatedTopicModelImpl> i = candidates.iterator();
        while (i.hasNext()) {
            long parentId = i.next().getId();
            String assocTypeUri = assocDef.getInstanceLevelAssocTypeUri();
            if (childTopic != null) {
                if (this.pl.getAssociation(assocTypeUri, parentId, childTopic.getId(), "dm4.core.parent", "dm4.core.child") != null) continue;
                i.remove();
                continue;
            }
            if (this.pl.getTopicRelatedTopics(parentId, assocTypeUri, "dm4.core.parent", "dm4.core.child", assocDef.getChildTypeUri()).isEmpty()) continue;
            i.remove();
        }
    }

    private TopicModelImpl createSimpleTopic() {
        if (this.isAssoc) {
            throw new RuntimeException("Tried to create a topic from an assoc model");
        }
        return this.pl._createTopic(this.mf.newTopicModel(this.newValues.uri, this.newValues.typeUri, this.newValues.value)).getModel();
    }

    private TopicModelImpl createCompositeTopic(Map<String, Object> childTopics) {
        TopicModelImpl topic = this.createSimpleTopic();
        this.logger.info("### Creating composite " + topic.id + " (typeUri=\"" + this.type.uri + "\")");
        for (String assocDefUri : childTopics.keySet()) {
            if (this.isOne(assocDefUri)) {
                Object childTopic = ((UnifiedValue)childTopics.get((Object)assocDefUri)).value;
                this.createChildAssociation(topic, (DMXObjectModel)childTopic, assocDefUri);
                continue;
            }
            for (UnifiedValue value : (List)childTopics.get(assocDefUri)) {
                this.createChildAssociation(topic, (DMXObjectModel)value.value, assocDefUri);
            }
        }
        return topic;
    }

    private AssociationModelImpl createChildAssociation(DMXObjectModel parent, DMXObjectModel child, String assocDefUri) {
        return this.createChildAssociation(parent, child, assocDefUri, false);
    }

    private AssociationModelImpl createChildAssociation(DMXObjectModel parent, DMXObjectModel child, String assocDefUri, boolean deleted) {
        this.logger.info("### " + (deleted ? "Reassigning" : "Assigning") + " child " + child.getId() + " (assocDefUri=\"" + assocDefUri + "\") to composite " + parent.getId() + " (typeUri=\"" + this.type.uri + "\")");
        return this.pl.createAssociation(this.assocDef(assocDefUri).getInstanceLevelAssocTypeUri(), parent.createRoleModel("dm4.core.parent"), child.createRoleModel("dm4.core.child")).getModel();
    }

    private RelatedTopicModelImpl findTopic(List<RelatedTopicModelImpl> topics, long topicId) {
        for (RelatedTopicModelImpl topic : topics) {
            if (topic.id != topicId) continue;
            return topic;
        }
        throw new RuntimeException("Topic " + topicId + " not found in " + topics);
    }

    private void removeTopic(List<RelatedTopicModelImpl> topics, long topicId) {
        Iterator<RelatedTopicModelImpl> i = topics.iterator();
        while (i.hasNext()) {
            RelatedTopicModelImpl topic = i.next();
            if (topic.id != topicId) continue;
            i.remove();
            return;
        }
        throw new RuntimeException("Topic " + topicId + " not found in " + topics);
    }

    private AssociationDefinitionModel assocDef(String assocDefUri) {
        if (this.isFacetUpdate) {
            if (!assocDefUri.equals(this.assocDef.getAssocDefUri())) {
                throw new RuntimeException("URI mismatch: assocDefUri=\"" + assocDefUri + "\", facet assocDefUri=\"" + this.assocDef.getAssocDefUri() + "\"");
            }
            return this.assocDef;
        }
        return this.type.getAssocDef(assocDefUri);
    }

    private boolean isOne(String assocDefUri) {
        return this.assocDef(assocDefUri).getChildCardinalityUri().equals("dm4.core.one");
    }

    private boolean isValueType() {
        return this.type.getDataTypeUri().equals("dm4.core.value");
    }

    private boolean isEmptyValue(String assocDefUri) {
        return this.emptyValues.contains(assocDefUri);
    }

    static class UnifiedValue<M extends DMXObjectModelImpl> {
        M value;
        DMXObjectModelImpl _newValues;
        long originalId;
        final /* synthetic */ ValueIntegrator this$0;

        private UnifiedValue(M value) {
            this.this$0 = this$0;
            this.value = value;
            this._newValues = ((ValueIntegrator)this$0).newValues;
            this.originalId = ((ValueIntegrator)this$0).newValues.id;
        }
    }
}

