/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.core.impl;

import de.deepamehta.core.impl.ModelFactoryImpl;
import de.deepamehta.core.impl.PersistenceLayer;
import de.deepamehta.core.impl.TopicModelImpl;
import de.deepamehta.core.model.TopicModel;
import de.deepamehta.core.model.TopicReferenceModel;
import de.deepamehta.core.model.ViewConfigurationModel;
import java.util.Map;
import org.codehaus.jettison.json.JSONArray;

class ViewConfigurationModelImpl
implements ViewConfigurationModel {
    private Map<String, TopicModelImpl> configTopics;
    private ModelFactoryImpl mf;

    ViewConfigurationModelImpl(Map<String, TopicModelImpl> configTopics, PersistenceLayer pl) {
        this.configTopics = configTopics;
        this.mf = pl.mf;
    }

    public Iterable<TopicModelImpl> getConfigTopics() {
        return this.configTopics.values();
    }

    @Override
    public TopicModelImpl getConfigTopic(String configTypeUri) {
        return this.configTopics.get(configTypeUri);
    }

    @Override
    public void addConfigTopic(TopicModel configTopic) {
        String configTypeUri = configTopic.getTypeUri();
        if (this.getConfigTopic(configTypeUri) != null) {
            throw new RuntimeException("There is already a view configuration topic of type \"" + configTypeUri + "\"");
        }
        this.configTopics.put(configTypeUri, (TopicModelImpl)configTopic);
    }

    @Override
    public ViewConfigurationModel setConfigValue(String configTypeUri, String childTypeUri, Object value) {
        TopicModelImpl configTopic = this.getConfigTopic(configTypeUri);
        if (configTopic == null) {
            this.addConfigTopic(this.mf.newTopicModel(configTypeUri, this.mf.newChildTopicsModel().put(childTypeUri, value)));
        } else {
            configTopic.getChildTopicsModel().put(childTypeUri, value);
        }
        return this;
    }

    @Override
    public ViewConfigurationModel setConfigValueRef(String configTypeUri, String childTypeUri, Object topicIdOrUri) {
        TopicModelImpl configTopic = this.getConfigTopic(configTypeUri);
        TopicReferenceModel valueRef = this.mf.newTopicReferenceModel(topicIdOrUri);
        if (configTopic == null) {
            this.addConfigTopic(this.mf.newTopicModel(configTypeUri, this.mf.newChildTopicsModel().put(childTypeUri, valueRef)));
        } else {
            configTopic.getChildTopicsModel().put(childTypeUri, valueRef);
        }
        return this;
    }

    @Override
    public void updateConfigTopic(TopicModel configTopic) {
        String configTypeUri = configTopic.getTypeUri();
        TopicModelImpl confTopic = this.getConfigTopic(configTypeUri);
        if (confTopic == null) {
            throw new RuntimeException("There is no view configuration topic of type \"" + configTypeUri + "\"");
        }
        confTopic.set(configTopic);
    }

    @Override
    public Object getConfigValue(String configTypeUri, String childTypeUri) {
        TopicModelImpl configTopic = this.getConfigTopic(configTypeUri);
        if (configTopic == null) {
            return null;
        }
        return configTopic.getChildTopicsModel().getObject(childTypeUri, null);
    }

    @Override
    public JSONArray toJSONArray() {
        try {
            JSONArray configTopics = new JSONArray();
            for (TopicModel topicModel : this.getConfigTopics()) {
                configTopics.put((Object)topicModel.toJSON());
            }
            return configTopics;
        }
        catch (Exception e) {
            throw new RuntimeException("Serialization failed", e);
        }
    }

    public String toString() {
        return "view configuration " + this.configTopics;
    }
}

