/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.core.service;

import de.deepamehta.core.JSONEnabled;
import de.deepamehta.core.service.Directive;
import de.deepamehta.core.util.DMXUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;

public class Directives
implements Iterable<Entry> {
    private List<Entry> directives = new ArrayList<Entry>();
    private static Logger logger = Logger.getLogger("de.deepamehta.core.service.Directives");
    private static final ThreadLocal<Directives> threadLocalDirectives = new ThreadLocal(){

        protected Directives initialValue() {
            logger.fine("### Creating tread-local directives");
            return new Directives();
        }
    };

    public void add(Directive dir, JSONEnabled arg) {
        this.directives.add(new Entry(dir, arg));
    }

    public JSONArray toJSONArray() {
        return DMXUtils.toJSONArray(this.directives);
    }

    public static Directives get() {
        return threadLocalDirectives.get();
    }

    public static void remove() {
        logger.fine("### Removing tread-local directives");
        threadLocalDirectives.remove();
    }

    @Override
    public Iterator<Entry> iterator() {
        return this.directives.iterator();
    }

    public class Entry
    implements JSONEnabled {
        public Directive dir;
        public JSONEnabled arg;

        private Entry(Directive dir, JSONEnabled arg) {
            this.dir = dir;
            this.arg = arg;
        }

        @Override
        public JSONObject toJSON() {
            try {
                return new JSONObject().put("type", (Object)this.dir).put("arg", (Object)this.arg.toJSON());
            }
            catch (Exception e) {
                throw new RuntimeException("Serialization failed", e);
            }
        }

        public String toString() {
            return (Object)((Object)this.dir) + ": " + this.arg;
        }
    }
}

