/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.storage.neo4j;

import de.deepamehta.core.model.DMXObjectModel;
import de.deepamehta.storage.neo4j.Neo4jStorage;
import de.deepamehta.storage.neo4j.NodeType;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.tooling.GlobalGraphOperations;

abstract class ModelIterator<E extends DMXObjectModel>
implements Iterator<E> {
    protected Neo4jStorage storage;
    private NodeType nodeType;
    private Iterator<Node> nodes;
    private Node nextNode;

    ModelIterator(Neo4jStorage storage, NodeType nodeType) {
        this.storage = storage;
        this.nodeType = nodeType;
        this.nodes = GlobalGraphOperations.at((GraphDatabaseService)storage.neo4j).getAllNodes().iterator();
    }

    @Override
    public boolean hasNext() {
        this.nextNode = this.fetchNextNode();
        return this.nextNode != null;
    }

    @Override
    public E next() {
        if (this.nextNode == null) {
            throw new NoSuchElementException("there is no next node");
        }
        return this.buildModel(this.nextNode);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("removal is not supported");
    }

    abstract E buildModel(Node var1);

    private Node fetchNextNode() {
        while (this.nodes.hasNext()) {
            Node node = this.nodes.next();
            if (!this.nodeType.isTypeOf(node)) continue;
            return node;
        }
        return null;
    }
}

