/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.accesscontrol.migrations;

import de.deepamehta.accesscontrol.AccessControlService;
import de.deepamehta.config.ConfigService;
import de.deepamehta.core.DMXObject;
import de.deepamehta.core.Topic;
import de.deepamehta.core.service.Inject;
import de.deepamehta.core.service.Migration;
import de.deepamehta.workspaces.WorkspacesService;
import java.util.List;
import java.util.logging.Logger;

public class Migration12
extends Migration {
    @Inject
    private AccessControlService acService;
    @Inject
    private WorkspacesService wsService;
    @Inject
    private ConfigService configService;
    private long administrationWorkspaceId;
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());

    public void run() {
        Topic systemWorkspace = this.wsService.createWorkspace("Administration", "dm4.workspaces.administration", AccessControlService.ADMINISTRATION_WORKSPACE_SHARING_MODE);
        this.acService.setWorkspaceOwner(systemWorkspace, "admin");
        this.administrationWorkspaceId = this.dm4.getAccessControl().getAdministrationWorkspaceId();
        this.assignConfigTopics("dm4.accesscontrol.login_enabled");
        this.assignConfigTopics("dm4.files.disk_quota");
        List usernames = this.dm4.getTopicsByType("dm4.accesscontrol.username");
        this.logger.info("########## Creating config topics of type \"dm4.workspaces.enabled_sharing_modes\" for " + usernames.size() + " usernames");
        for (Topic username : usernames) {
            this.configService.createConfigTopic("dm4.workspaces.enabled_sharing_modes", username);
        }
    }

    private void assignConfigTopics(String configTypeUri) {
        List configTopics = this.dm4.getTopicsByType(configTypeUri);
        this.logger.info("########## Reassigning " + configTopics.size() + " config topics of type \"" + configTypeUri + "\" to workspace \"Administration\"");
        for (Topic configTopic : configTopics) {
            this.wsService.assignToWorkspace((DMXObject)configTopic, this.administrationWorkspaceId);
        }
    }
}

