/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.contacts;

import de.deepamehta.contacts.ContactsService;
import de.deepamehta.core.RelatedTopic;
import de.deepamehta.core.model.AssociationModel;
import de.deepamehta.core.osgi.PluginActivator;
import de.deepamehta.core.service.CoreService;
import de.deepamehta.core.service.event.PreCreateAssociationListener;
import de.deepamehta.core.util.DMXUtils;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Path(value="/contact")
@Produces(value={"application/json"})
public class ContactsPlugin
extends PluginActivator
implements ContactsService,
PreCreateAssociationListener {
    @Override
    @GET
    @Path(value="/{id}/institutions")
    public List<RelatedTopic> getInstitutions(@PathParam(value="id") long personId) {
        return this.dm4.getTopic(personId).getRelatedTopics("dm4.contacts.organization_association", "dm4.core.default", "dm4.core.default", "dm4.contacts.institution");
    }

    @Override
    @GET
    @Path(value="/{id}/persons")
    public List<RelatedTopic> getPersons(@PathParam(value="id") long instId) {
        return this.dm4.getTopic(instId).getRelatedTopics("dm4.contacts.organization_association", "dm4.core.default", "dm4.core.default", "dm4.contacts.person");
    }

    public void preCreateAssociation(AssociationModel assoc) {
        DMXUtils.associationAutoTyping((AssociationModel)assoc, (String)"dm4.contacts.person", (String)"dm4.contacts.institution", (String)"dm4.contacts.organization_association", (String)"dm4.core.default", (String)"dm4.core.default", (CoreService)this.dm4);
    }
}

