/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.core.impl;

import de.deepamehta.core.impl.WebSocketConnection;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class WebSocketConnectionPool {
    private Map<String, Map<String, WebSocketConnection>> pool = new ConcurrentHashMap<String, Map<String, WebSocketConnection>>();

    WebSocketConnectionPool() {
    }

    Collection<WebSocketConnection> getConnections(String pluginUri) {
        Map<String, WebSocketConnection> connections = this.pool.get(pluginUri);
        return connections != null ? connections.values() : null;
    }

    WebSocketConnection getConnection(String pluginUri, String sessionId) {
        Map<String, WebSocketConnection> connections = this.pool.get(pluginUri);
        if (connections == null) {
            throw new RuntimeException("No WebSocket connection open for plugin \"" + pluginUri + "\"");
        }
        WebSocketConnection connection = connections.get(sessionId);
        if (connection == null) {
            throw new RuntimeException("No WebSocket connection open for session \"" + sessionId + "\" (plugin \"" + pluginUri + "\")");
        }
        return connection;
    }

    void add(WebSocketConnection connection) {
        String pluginUri = connection.pluginUri;
        Map<String, WebSocketConnection> connections = this.pool.get(pluginUri);
        if (connections == null) {
            connections = new ConcurrentHashMap<String, WebSocketConnection>();
            this.pool.put(pluginUri, connections);
        }
        connections.put(connection.sessionId, connection);
    }

    void remove(WebSocketConnection connection) {
        String pluginUri = connection.pluginUri;
        boolean removed = this.getConnections(pluginUri).remove(connection);
        if (!removed) {
            throw new RuntimeException("Removing a connection of plugin \"" + pluginUri + "\" failed");
        }
    }
}

