/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.time;

import com.sun.jersey.spi.container.ContainerResponse;
import de.deepamehta.core.Association;
import de.deepamehta.core.DMXObject;
import de.deepamehta.core.Topic;
import de.deepamehta.core.model.AssociationModel;
import de.deepamehta.core.model.ChildTopicsModel;
import de.deepamehta.core.model.TopicModel;
import de.deepamehta.core.osgi.PluginActivator;
import de.deepamehta.core.service.event.PostCreateAssociationListener;
import de.deepamehta.core.service.event.PostCreateTopicListener;
import de.deepamehta.core.service.event.PostUpdateAssociationListener;
import de.deepamehta.core.service.event.PostUpdateTopicListener;
import de.deepamehta.core.service.event.PostUpdateTopicRequestListener;
import de.deepamehta.core.service.event.PreSendAssociationListener;
import de.deepamehta.core.service.event.PreSendTopicListener;
import de.deepamehta.core.service.event.ServiceResponseFilterListener;
import de.deepamehta.time.TimeService;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MultivaluedMap;

@Path(value="/time")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class TimePlugin
extends PluginActivator
implements TimeService,
PostCreateTopicListener,
PostCreateAssociationListener,
PostUpdateTopicListener,
PostUpdateTopicRequestListener,
PostUpdateAssociationListener,
PreSendTopicListener,
PreSendAssociationListener,
ServiceResponseFilterListener {
    private static String PROP_CREATED = "dm4.time.created";
    private static String PROP_MODIFIED = "dm4.time.modified";
    private static String HEADER_LAST_MODIFIED = "Last-Modified";
    private DateFormat rfc2822;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    @Override
    @GET
    @Path(value="/object/{id}/created")
    public long getCreationTime(@PathParam(value="id") long objectId) {
        try {
            return this.dm4.hasProperty(objectId, PROP_CREATED) ? (Long)this.dm4.getProperty(objectId, PROP_CREATED) : 0L;
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching creation time of object " + objectId + " failed", e);
        }
    }

    @Override
    @GET
    @Path(value="/object/{id}/modified")
    public long getModificationTime(@PathParam(value="id") long objectId) {
        try {
            return this.dm4.hasProperty(objectId, PROP_MODIFIED) ? (Long)this.dm4.getProperty(objectId, PROP_MODIFIED) : 0L;
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching modification time of object " + objectId + " failed", e);
        }
    }

    @Override
    public void setModified(DMXObject object) {
        this.storeTimestamp(object);
    }

    @Override
    @GET
    @Path(value="/from/{from}/to/{to}/topics/created")
    public Collection<Topic> getTopicsByCreationTime(@PathParam(value="from") long from, @PathParam(value="to") long to) {
        return this.dm4.getTopicsByPropertyRange(PROP_CREATED, (Number)from, (Number)to);
    }

    @Override
    @GET
    @Path(value="/from/{from}/to/{to}/topics/modified")
    public Collection<Topic> getTopicsByModificationTime(@PathParam(value="from") long from, @PathParam(value="to") long to) {
        return this.dm4.getTopicsByPropertyRange(PROP_MODIFIED, (Number)from, (Number)to);
    }

    @Override
    @GET
    @Path(value="/from/{from}/to/{to}/assocs/created")
    public Collection<Association> getAssociationsByCreationTime(@PathParam(value="from") long from, @PathParam(value="to") long to) {
        return this.dm4.getAssociationsByPropertyRange(PROP_CREATED, (Number)from, (Number)to);
    }

    @Override
    @GET
    @Path(value="/from/{from}/to/{to}/assocs/modified")
    public Collection<Association> getAssociationsByModificationTime(@PathParam(value="from") long from, @PathParam(value="to") long to) {
        return this.dm4.getAssociationsByPropertyRange(PROP_MODIFIED, (Number)from, (Number)to);
    }

    public void init() {
        this.rfc2822 = DateFormat.getDateTimeInstance(2, 2, Locale.ENGLISH);
        this.rfc2822.setTimeZone(TimeZone.getTimeZone("GMT+00:00"));
        ((SimpleDateFormat)this.rfc2822).applyPattern("EEE, dd MMM yyyy HH:mm:ss 'GMT'");
    }

    public void postCreateTopic(Topic topic) {
        this.storeTimestamps((DMXObject)topic);
    }

    public void postCreateAssociation(Association assoc) {
        this.storeTimestamps((DMXObject)assoc);
    }

    public void postUpdateTopic(Topic topic, TopicModel updateModel, TopicModel oldTopic) {
        this.storeTimestamp((DMXObject)topic);
    }

    public void postUpdateAssociation(Association assoc, AssociationModel updateModel, AssociationModel oldAssoc) {
        this.storeTimestamp((DMXObject)assoc);
    }

    public void postUpdateTopicRequest(Topic topic) {
        this.storeParentsTimestamp(topic);
    }

    public void preSendTopic(Topic topic) {
        this.enrichWithTimestamp((DMXObject)topic);
    }

    public void preSendAssociation(Association assoc) {
        this.enrichWithTimestamp((DMXObject)assoc);
    }

    public void serviceResponseFilter(ContainerResponse response) {
        DMXObject object = this.responseObject(response);
        if (object != null) {
            this.setLastModifiedHeader(response, this.getModificationTime(object.getId()));
        }
    }

    private void storeTimestamps(DMXObject object) {
        long time = System.currentTimeMillis();
        this.storeCreationTime(object, time);
        this.storeModificationTime(object, time);
    }

    private void storeTimestamp(DMXObject object) {
        long time = System.currentTimeMillis();
        this.storeModificationTime(object, time);
    }

    private void storeParentsTimestamp(Topic topic) {
        for (DMXObject object : this.getParents(topic)) {
            this.storeTimestamp(object);
        }
    }

    private void storeCreationTime(DMXObject object, long time) {
        this.storeTime(object, PROP_CREATED, time);
    }

    private void storeModificationTime(DMXObject object, long time) {
        this.storeTime(object, PROP_MODIFIED, time);
    }

    private void storeTime(DMXObject object, String propUri, long time) {
        object.setProperty(propUri, (Object)time, true);
    }

    private DMXObject responseObject(ContainerResponse response) {
        Object entity = response.getEntity();
        return entity instanceof DMXObject ? (DMXObject)entity : null;
    }

    private void enrichWithTimestamp(DMXObject object) {
        long objectId = object.getId();
        ChildTopicsModel childTopics = object.getChildTopics().getModel().put(PROP_CREATED, (Object)this.getCreationTime(objectId)).put(PROP_MODIFIED, (Object)this.getModificationTime(objectId));
    }

    private void setLastModifiedHeader(ContainerResponse response, long time) {
        this.setHeader(response, HEADER_LAST_MODIFIED, this.rfc2822.format(time));
    }

    private void setHeader(ContainerResponse response, String header, String value) {
        MultivaluedMap headers = response.getHttpHeaders();
        if (headers.containsKey((Object)header)) {
            throw new RuntimeException("Response already has a \"" + header + "\" header");
        }
        headers.putSingle((Object)header, (Object)value);
    }

    private Set<DMXObject> getParents(Topic topic) {
        LinkedHashSet<DMXObject> parents = new LinkedHashSet<DMXObject>();
        List parentTopics = topic.getRelatedTopics((String)null, "dm4.core.child", "dm4.core.parent", null);
        List parentAssocs = topic.getRelatedAssociations(null, "dm4.core.child", "dm4.core.parent", null);
        parents.addAll(parentTopics);
        parents.addAll(parentAssocs);
        for (Topic parentTopic : parentTopics) {
            parents.addAll(this.getParents(parentTopic));
        }
        return parents;
    }
}

