/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.geomaps.model;

import de.deepamehta.core.JSONEnabled;
import de.deepamehta.core.RelatedTopic;
import de.deepamehta.core.Topic;
import de.deepamehta.core.model.TopicModel;
import de.deepamehta.core.service.CoreService;
import de.deepamehta.core.util.DMXUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.codehaus.jettison.json.JSONObject;

public class Geomap
implements Iterable<TopicModel>,
JSONEnabled {
    protected Topic geomapTopic;
    protected Map<Long, TopicModel> geoCoords = new HashMap<Long, TopicModel>();
    protected CoreService dm4;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    public Geomap(long geomapId, CoreService dm4) {
        this.logger.info("Loading geomap " + geomapId);
        this.geomapTopic = dm4.getTopic(geomapId).loadChildTopics();
        this.dm4 = dm4;
        this.fetchGeoCoordinates();
    }

    public long getId() {
        return this.geomapTopic.getId();
    }

    public boolean containsTopic(long geoCoordId) {
        return this.geoCoords.get(geoCoordId) != null;
    }

    public JSONObject toJSON() {
        try {
            return new JSONObject().put("info", (Object)this.geomapTopic.toJSON()).put("topics", (Object)DMXUtils.toJSONArray(this.geoCoords.values()));
        }
        catch (Exception e) {
            throw new RuntimeException("Serialization failed", e);
        }
    }

    @Override
    public Iterator<TopicModel> iterator() {
        return this.geoCoords.values().iterator();
    }

    public String toString() {
        return "geomap " + this.getId();
    }

    private void fetchGeoCoordinates() {
        for (Topic topic : this.fetchGeoCoordinates(this.geomapTopic)) {
            this.geoCoords.put(topic.getId(), topic.getModel());
        }
    }

    private List<RelatedTopic> fetchGeoCoordinates(Topic geomapTopic) {
        return DMXUtils.loadChildTopics((List)geomapTopic.getRelatedTopics("dm4.geomaps.geotopic_mapcontext", "dm4.core.default", "dm4.topicmaps.topicmap_topic", "dm4.geomaps.geo_coordinate"));
    }
}

