/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.core.impl;

import de.deepamehta.core.ChildTopics;
import de.deepamehta.core.RelatedTopic;
import de.deepamehta.core.impl.ChildTopicsModelImpl;
import de.deepamehta.core.impl.DMXObjectModelImpl;
import de.deepamehta.core.impl.PersistenceLayer;
import de.deepamehta.core.impl.RelatedTopicImpl;
import de.deepamehta.core.impl.RelatedTopicModelImpl;
import de.deepamehta.core.model.ChildTopicsModel;
import de.deepamehta.core.model.RelatedTopicModel;
import de.deepamehta.core.model.SimpleValue;
import de.deepamehta.core.model.TopicModel;
import de.deepamehta.core.service.ModelFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

class ChildTopicsImpl
implements ChildTopics {
    private ChildTopicsModelImpl model;
    private DMXObjectModelImpl parent;
    private PersistenceLayer pl;
    private ModelFactory mf;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    ChildTopicsImpl(ChildTopicsModelImpl model, DMXObjectModelImpl parent, PersistenceLayer pl) {
        this.model = model;
        this.parent = parent;
        this.pl = pl;
        this.mf = pl.mf;
    }

    @Override
    public RelatedTopic getTopic(String assocDefUri) {
        this.loadChildTopics(assocDefUri);
        return this._getTopic(assocDefUri);
    }

    @Override
    public RelatedTopic getTopicOrNull(String assocDefUri) {
        this.loadChildTopics(assocDefUri);
        return this._getTopicOrNull(assocDefUri);
    }

    @Override
    public List<RelatedTopic> getTopics(String assocDefUri) {
        this.loadChildTopics(assocDefUri);
        return this._getTopics(assocDefUri);
    }

    @Override
    public List<RelatedTopic> getTopicsOrNull(String assocDefUri) {
        this.loadChildTopics(assocDefUri);
        return this._getTopicsOrNull(assocDefUri);
    }

    @Override
    public Object get(String assocDefUri) {
        Object value = this.model.get(assocDefUri);
        if (value == null) {
            return null;
        }
        if (value instanceof RelatedTopicModel) {
            return this.instantiate((RelatedTopicModel)value);
        }
        if (value instanceof List) {
            return this.instantiate((List)value);
        }
        throw new RuntimeException("Unexpected value in a ChildTopicsModel: " + value);
    }

    @Override
    public ChildTopicsModel getModel() {
        return this.model;
    }

    @Override
    public String getString(String assocDefUri) {
        return this.getTopic(assocDefUri).getSimpleValue().toString();
    }

    @Override
    public String getStringOrNull(String assocDefUri) {
        RelatedTopic topic = this.getTopicOrNull(assocDefUri);
        return topic != null ? topic.getSimpleValue().toString() : null;
    }

    @Override
    public int getInt(String assocDefUri) {
        return this.getTopic(assocDefUri).getSimpleValue().intValue();
    }

    @Override
    public Integer getIntOrNull(String assocDefUri) {
        RelatedTopic topic = this.getTopicOrNull(assocDefUri);
        return topic != null ? Integer.valueOf(topic.getSimpleValue().intValue()) : null;
    }

    @Override
    public long getLong(String assocDefUri) {
        return this.getTopic(assocDefUri).getSimpleValue().longValue();
    }

    @Override
    public Long getLongOrNull(String assocDefUri) {
        RelatedTopic topic = this.getTopicOrNull(assocDefUri);
        return topic != null ? Long.valueOf(topic.getSimpleValue().longValue()) : null;
    }

    @Override
    public double getDouble(String assocDefUri) {
        return this.getTopic(assocDefUri).getSimpleValue().doubleValue();
    }

    @Override
    public Double getDoubleOrNull(String assocDefUri) {
        RelatedTopic topic = this.getTopicOrNull(assocDefUri);
        return topic != null ? Double.valueOf(topic.getSimpleValue().doubleValue()) : null;
    }

    @Override
    public boolean getBoolean(String assocDefUri) {
        return this.getTopic(assocDefUri).getSimpleValue().booleanValue();
    }

    @Override
    public Boolean getBooleanOrNull(String assocDefUri) {
        RelatedTopic topic = this.getTopicOrNull(assocDefUri);
        return topic != null ? Boolean.valueOf(topic.getSimpleValue().booleanValue()) : null;
    }

    @Override
    public Object getObject(String assocDefUri) {
        return this.getTopic(assocDefUri).getSimpleValue().value();
    }

    @Override
    public Object getObjectOrNull(String assocDefUri) {
        RelatedTopic topic = this.getTopicOrNull(assocDefUri);
        return topic != null ? topic.getSimpleValue().value() : null;
    }

    @Override
    public ChildTopics getChildTopics(String assocDefUri) {
        return this.getTopic(assocDefUri).getChildTopics();
    }

    @Override
    public ChildTopics set(String assocDefUri, TopicModel value) {
        return this._updateOne(assocDefUri, this.mf.newRelatedTopicModel(value));
    }

    @Override
    public ChildTopics set(String assocDefUri, Object value) {
        return this._updateOne(assocDefUri, this.mf.newRelatedTopicModel(this.mf.childTypeUri(assocDefUri), new SimpleValue(value)));
    }

    @Override
    public ChildTopics set(String assocDefUri, ChildTopicsModel value) {
        return this._updateOne(assocDefUri, this.mf.newRelatedTopicModel(this.mf.childTypeUri(assocDefUri), value));
    }

    @Override
    public ChildTopics setRef(String assocDefUri, long refTopicId) {
        return this._updateOne(assocDefUri, this.mf.newTopicReferenceModel(refTopicId));
    }

    @Override
    public ChildTopics setRef(String assocDefUri, long refTopicId, ChildTopicsModel relatingAssocChildTopics) {
        return this._updateOne(assocDefUri, this.mf.newTopicReferenceModel(refTopicId, relatingAssocChildTopics));
    }

    @Override
    public ChildTopics setRef(String assocDefUri, String refTopicUri) {
        return this._updateOne(assocDefUri, this.mf.newTopicReferenceModel(refTopicUri));
    }

    @Override
    public ChildTopics setRef(String assocDefUri, String refTopicUri, ChildTopicsModel relatingAssocChildTopics) {
        return this._updateOne(assocDefUri, this.mf.newTopicReferenceModel(refTopicUri, relatingAssocChildTopics));
    }

    @Override
    public ChildTopics setDeletionRef(String assocDefUri, long refTopicId) {
        return this._updateOne(assocDefUri, this.mf.newTopicDeletionModel(refTopicId));
    }

    @Override
    public ChildTopics setDeletionRef(String assocDefUri, String refTopicUri) {
        return this._updateOne(assocDefUri, this.mf.newTopicDeletionModel(refTopicUri));
    }

    @Override
    public ChildTopics add(String assocDefUri, TopicModel value) {
        return this._updateMany(assocDefUri, this.mf.newRelatedTopicModel(value));
    }

    @Override
    public ChildTopics add(String assocDefUri, Object value) {
        return this._updateMany(assocDefUri, this.mf.newRelatedTopicModel(this.mf.childTypeUri(assocDefUri), new SimpleValue(value)));
    }

    @Override
    public ChildTopics add(String assocDefUri, ChildTopicsModel value) {
        return this._updateMany(assocDefUri, this.mf.newRelatedTopicModel(this.mf.childTypeUri(assocDefUri), value));
    }

    @Override
    public ChildTopics addRef(String assocDefUri, long refTopicId) {
        return this._updateMany(assocDefUri, this.mf.newTopicReferenceModel(refTopicId));
    }

    @Override
    public ChildTopics addRef(String assocDefUri, long refTopicId, ChildTopicsModel relatingAssocChildTopics) {
        return this._updateMany(assocDefUri, this.mf.newTopicReferenceModel(refTopicId, relatingAssocChildTopics));
    }

    @Override
    public ChildTopics addRef(String assocDefUri, String refTopicUri) {
        return this._updateMany(assocDefUri, this.mf.newTopicReferenceModel(refTopicUri));
    }

    @Override
    public ChildTopics addRef(String assocDefUri, String refTopicUri, ChildTopicsModel relatingAssocChildTopics) {
        return this._updateMany(assocDefUri, this.mf.newTopicReferenceModel(refTopicUri, relatingAssocChildTopics));
    }

    @Override
    public ChildTopics addDeletionRef(String assocDefUri, long refTopicId) {
        return this._updateMany(assocDefUri, this.mf.newTopicDeletionModel(refTopicId));
    }

    @Override
    public ChildTopics addDeletionRef(String assocDefUri, String refTopicUri) {
        return this._updateMany(assocDefUri, this.mf.newTopicDeletionModel(refTopicUri));
    }

    @Override
    public Iterator<String> iterator() {
        return this.model.iterator();
    }

    boolean has(String assocDefUri) {
        return this.model.has(assocDefUri);
    }

    int size() {
        return this.model.size();
    }

    private ChildTopics _updateOne(String assocDefUri, RelatedTopicModel newChildTopic) {
        this.parent.updateChildTopics(this.mf.newChildTopicsModel().put(assocDefUri, newChildTopic));
        return this;
    }

    private ChildTopics _updateMany(String assocDefUri, RelatedTopicModel newChildTopic) {
        this.parent.updateChildTopics(this.mf.newChildTopicsModel().add(assocDefUri, newChildTopic));
        return this;
    }

    private void loadChildTopics(String assocDefUri) {
        this.parent.loadChildTopics(assocDefUri, false);
    }

    private RelatedTopic _getTopic(String assocDefUri) {
        return this.instantiate(this.model.getTopic(assocDefUri));
    }

    private RelatedTopic _getTopicOrNull(String assocDefUri) {
        RelatedTopicModelImpl topic = this.model.getTopicOrNull(assocDefUri);
        return topic != null ? this.instantiate(topic) : null;
    }

    private List<RelatedTopic> _getTopics(String assocDefUri) {
        return this.instantiate(this.model.getTopics(assocDefUri));
    }

    private List<RelatedTopic> _getTopicsOrNull(String assocDefUri) {
        List<RelatedTopicModelImpl> topics = this.model.getTopicsOrNull(assocDefUri);
        return topics != null ? this.instantiate(topics) : null;
    }

    private List<RelatedTopic> instantiate(List<? extends RelatedTopicModel> models) {
        ArrayList<RelatedTopic> topics = new ArrayList<RelatedTopic>();
        for (RelatedTopicModel relatedTopicModel : models) {
            topics.add(this.instantiate(relatedTopicModel));
        }
        return topics;
    }

    private RelatedTopic instantiate(RelatedTopicModel model) {
        try {
            return new RelatedTopicImpl((RelatedTopicModelImpl)model, this.pl);
        }
        catch (Exception e) {
            throw new RuntimeException("Instantiating a RelatedTopic failed (" + model + ")", e);
        }
    }
}

