/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.files;

import de.deepamehta.core.JSONEnabled;
import de.deepamehta.core.util.DMXUtils;
import de.deepamehta.core.util.JavaUtils;
import de.deepamehta.files.ItemKind;
import de.deepamehta.files.PathMapper;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.jettison.json.JSONObject;

public class DirectoryListing
implements JSONEnabled {
    private PathMapper pathMapper;
    private FileItem dirInfo;
    private List<FileItem> fileItems = new ArrayList<FileItem>();

    public DirectoryListing(File directory, PathMapper pathMapper) {
        this.pathMapper = pathMapper;
        this.dirInfo = new FileItem(directory);
        for (File file : directory.listFiles()) {
            this.fileItems.add(new FileItem(file));
        }
    }

    public List<FileItem> getFileItems() {
        return this.fileItems;
    }

    public JSONObject toJSON() {
        try {
            return this.dirInfo.toJSON().put("items", (Object)DMXUtils.toJSONArray(this.fileItems));
        }
        catch (Exception e) {
            throw new RuntimeException("Serialization failed", e);
        }
    }

    public class FileItem
    implements JSONEnabled {
        ItemKind kind;
        String name;
        String path;
        long size;
        String type;

        FileItem(File file) {
            this.kind = file.isDirectory() ? ItemKind.DIRECTORY : ItemKind.FILE;
            this.name = file.getName();
            this.path = DirectoryListing.this.pathMapper.repoPath(file);
            if (this.kind == ItemKind.FILE) {
                this.size = file.length();
                this.type = JavaUtils.getFileType((String)this.name);
            }
        }

        public ItemKind getItemKind() {
            return this.kind;
        }

        public String getName() {
            return this.name;
        }

        public String getPath() {
            return this.path;
        }

        public long getSize() {
            return this.size;
        }

        public String getMediaType() {
            return this.type;
        }

        public JSONObject toJSON() {
            try {
                JSONObject item = new JSONObject();
                item.put("kind", (Object)this.kind.stringify());
                item.put("name", (Object)this.name);
                item.put("path", (Object)this.path);
                if (this.kind == ItemKind.FILE) {
                    item.put("size", this.size);
                    item.put("type", (Object)this.type);
                }
                return item;
            }
            catch (Exception e) {
                throw new RuntimeException("Serialization failed", e);
            }
        }
    }
}

