/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.workspaces.migrations;

import de.deepamehta.core.AssociationDefinition;
import de.deepamehta.core.AssociationType;
import de.deepamehta.core.DMXObject;
import de.deepamehta.core.DMXType;
import de.deepamehta.core.Topic;
import de.deepamehta.core.TopicType;
import de.deepamehta.core.service.Inject;
import de.deepamehta.core.service.Migration;
import de.deepamehta.workspaces.WorkspacesService;
import java.util.logging.Logger;

public class Migration6
extends Migration {
    @Inject
    private WorkspacesService wsService;
    private long dmxWorkspaceId;
    private long types = 0L;
    private long standardTypes = 0L;
    private long assocDefs = 0L;
    private long configTopics = 0L;
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());

    public void run() {
        this.logger.info("########## Assigning standard association definitions (and their view config topics) to DMX workspace");
        this.dmxWorkspaceId = this.getDMXWorkspace().getId();
        for (TopicType topicType : this.dm4.getAllTopicTypes()) {
            this.assignWorkspace((DMXType)topicType);
        }
        for (AssociationType assocType : this.dm4.getAllAssociationTypes()) {
            this.assignWorkspace((DMXType)assocType);
        }
        this.logger.info("########## Assigning standard association definitions (and their view config topics) to DMX workspace complete\n    Types processed: " + this.types + "\n    Standard types: " + this.standardTypes + "\n    Association definitions: " + this.assocDefs + "\n    View config topics: " + this.configTopics);
    }

    private void assignWorkspace(DMXType type) {
        ++this.types;
        if (this.isDMXStandardType(type)) {
            ++this.standardTypes;
            for (AssociationDefinition assocDef : type.getAssocDefs()) {
                ++this.assocDefs;
                this.assignToDMXWorkspace((DMXObject)assocDef);
                for (Topic configTopic : assocDef.getViewConfig().getConfigTopics()) {
                    ++this.configTopics;
                    this.assignToDMXWorkspace((DMXObject)configTopic);
                }
            }
        }
    }

    private void assignToDMXWorkspace(DMXObject object) {
        this.wsService.assignToWorkspace(object, this.dmxWorkspaceId);
    }

    private Topic getDMXWorkspace() {
        return this.wsService.getWorkspace("dm4.workspaces.deepamehta");
    }

    private boolean isDMXStandardType(DMXType type) {
        return type.getUri().startsWith("dm4.");
    }
}

