/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.accesscontrol.migrations;

import java.util.logging.Logger;
import systems.dmx.core.Association;
import systems.dmx.core.DMXObject;
import systems.dmx.core.Topic;
import systems.dmx.core.service.Migration;

public class Migration6
extends Migration {
    private long objects = 0L;
    private long ownerRemoved = 0L;
    private long aclRemoved = 0L;
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());

    public void run() {
        this.logger.info("########## Removing owner and acl properties");
        for (Topic topic : this.dm4.getAllTopics()) {
            this.migrateObject((DMXObject)topic, "topic");
        }
        for (Association assoc : this.dm4.getAllAssociations()) {
            this.migrateObject((DMXObject)assoc, "association");
        }
        this.logger.info("########## Removing owner and acl properties complete\n    Objects processed: " + this.objects + "\n    Owner properties removed: " + this.ownerRemoved + "\n    ACL properties removed: " + this.aclRemoved);
    }

    private void migrateObject(DMXObject object, String type) {
        try {
            ++this.objects;
            if (object.hasProperty("dm4.accesscontrol.owner") && !object.getTypeUri().equals("dm4.workspaces.workspace")) {
                object.removeProperty("dm4.accesscontrol.owner");
                ++this.ownerRemoved;
            }
            if (object.hasProperty("dm4.accesscontrol.acl")) {
                object.removeProperty("dm4.accesscontrol.acl");
                ++this.aclRemoved;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Migrating " + type + " " + object.getId() + " failed (" + object + ")", e);
        }
    }
}

