/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.contacts.migrations;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import systems.dmx.core.RelatedTopic;
import systems.dmx.core.Topic;
import systems.dmx.core.service.Migration;

public class Migration2
extends Migration {
    private List<Entry> phoneEntries = new ArrayList<Entry>();
    private List<Entry> addressEntries = new ArrayList<Entry>();
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());

    public void run() {
        this.logger.info("########## Converting Phone Entry and Address Entry topics");
        this.bufferContentAndDeleteTypes();
        this.dm4.createAssociationType(this.mf.newAssociationTypeModel("dm4.contacts.phone_entry", "Phone Entry", "dm4.core.identity").addAssocDef(this.mf.newAssociationDefinitionModel("dm4.core.aggregation_def", "dm4.contacts.phone_entry", "dm4.contacts.phone_label", "dm4.core.many", "dm4.core.one")));
        this.dm4.createAssociationType(this.mf.newAssociationTypeModel("dm4.contacts.address_entry", "Address Entry", "dm4.core.identity").addAssocDef(this.mf.newAssociationDefinitionModel("dm4.core.aggregation_def", "dm4.contacts.address_entry", "dm4.contacts.address_label", "dm4.core.many", "dm4.core.one")));
        this.dm4.getTopicType("dm4.contacts.person").addAssocDefBefore(this.mf.newAssociationDefinitionModel("dm4.core.composition_def", "dm4.contacts.phone_entry", false, false, "dm4.contacts.person", "dm4.contacts.phone_number", "dm4.core.one", "dm4.core.many"), "dm4.contacts.email_address").addAssocDefBefore(this.mf.newAssociationDefinitionModel("dm4.core.composition_def", "dm4.contacts.address_entry", false, false, "dm4.contacts.person", "dm4.contacts.address", "dm4.core.one", "dm4.core.many"), "dm4.contacts.notes");
        this.dm4.getTopicType("dm4.contacts.institution").addAssocDefBefore(this.mf.newAssociationDefinitionModel("dm4.core.composition_def", "dm4.contacts.phone_entry", false, false, "dm4.contacts.institution", "dm4.contacts.phone_number", "dm4.core.one", "dm4.core.many"), "dm4.contacts.email_address").addAssocDefBefore(this.mf.newAssociationDefinitionModel("dm4.core.composition_def", "dm4.contacts.address_entry", false, false, "dm4.contacts.institution", "dm4.contacts.address", "dm4.core.one", "dm4.core.many"), "dm4.contacts.notes");
        for (Entry entry : this.phoneEntries) {
            this.convertPhoneEntry(entry);
        }
        for (Entry entry : this.addressEntries) {
            this.convertAddressEntry(entry);
        }
        this.logger.info("########## Converting Phone Entry and Address Entry topics complete\n    Phone entries converted: " + this.phoneEntries.size() + "\n    Address entries converted: " + this.addressEntries.size());
    }

    private void bufferContentAndDeleteTypes() {
        for (Topic phoneEntry : this.dm4.getTopicsByType("dm4.contacts.phone_entry")) {
            this.bufferPhoneEntry(phoneEntry);
        }
        for (Topic addressEntry : this.dm4.getTopicsByType("dm4.contacts.address_entry")) {
            this.bufferAddressEntry(addressEntry);
        }
        this.dm4.getTopicType("dm4.contacts.phone_entry").getAssocDef("dm4.contacts.phone_number").setTypeUri("dm4.core.aggregation_def");
        this.dm4.getTopicType("dm4.contacts.address_entry").getAssocDef("dm4.contacts.address").setTypeUri("dm4.core.aggregation_def");
        for (Entry entry : this.phoneEntries) {
            entry.topic.delete();
        }
        for (Entry entry : this.addressEntries) {
            entry.topic.delete();
        }
        this.dm4.deleteTopicType("dm4.contacts.phone_entry");
        this.dm4.deleteTopicType("dm4.contacts.address_entry");
    }

    private void bufferPhoneEntry(Topic phoneEntry) {
        RelatedTopic parent = phoneEntry.getRelatedTopic("dm4.core.composition", "dm4.core.child", "dm4.core.parent", null);
        RelatedTopic phoneLabel = phoneEntry.getChildTopics().getTopic("dm4.contacts.phone_label");
        RelatedTopic phoneNumber = phoneEntry.getChildTopics().getTopic("dm4.contacts.phone_number");
        this.phoneEntries.add(new Entry(phoneEntry, (Topic)parent, phoneLabel.getId(), phoneNumber.getId()));
    }

    private void bufferAddressEntry(Topic addressEntry) {
        RelatedTopic parent = addressEntry.getRelatedTopic("dm4.core.composition", "dm4.core.child", "dm4.core.parent", null);
        RelatedTopic addressLabel = addressEntry.getChildTopics().getTopic("dm4.contacts.address_label");
        RelatedTopic address = addressEntry.getChildTopics().getTopic("dm4.contacts.address");
        this.addressEntries.add(new Entry(addressEntry, (Topic)parent, addressLabel.getId(), address.getId()));
    }

    private void convertPhoneEntry(Entry entry) {
        entry.parent.getChildTopics().addRef("dm4.contacts.phone_number", entry.objectId, this.mf.newChildTopicsModel().putRef("dm4.contacts.phone_label", entry.labelId));
    }

    private void convertAddressEntry(Entry entry) {
        entry.parent.getChildTopics().addRef("dm4.contacts.address", entry.objectId, this.mf.newChildTopicsModel().putRef("dm4.contacts.address_label", entry.labelId));
    }

    private class Entry {
        private Topic topic;
        private Topic parent;
        private long labelId;
        private long objectId;

        private Entry(Topic topic, Topic parent, long labelId, long objectId) {
            this.topic = topic;
            this.parent = parent;
            this.labelId = labelId;
            this.objectId = objectId;
        }
    }
}

