/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.events;

import java.util.List;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import systems.dmx.core.DMXObject;
import systems.dmx.core.RelatedTopic;
import systems.dmx.core.Topic;
import systems.dmx.core.model.AssociationModel;
import systems.dmx.core.model.RoleModel;
import systems.dmx.core.osgi.PluginActivator;
import systems.dmx.core.service.CoreService;
import systems.dmx.core.service.Inject;
import systems.dmx.core.service.event.PreCreateAssociationListener;
import systems.dmx.core.util.DMXUtils;
import systems.dmx.events.EventsService;
import systems.dmx.time.TimeService;

@Path(value="/event")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class EventsPlugin
extends PluginActivator
implements EventsService,
PreCreateAssociationListener {
    @Inject
    private TimeService timeService;
    private static final Logger logger = Logger.getLogger(EventsPlugin.class.getName());

    @Override
    @GET
    @Path(value="/participant/{id}")
    public List<RelatedTopic> getEvents(@PathParam(value="id") long personId) {
        return this.dm4.getTopic(personId).getRelatedTopics("dm4.events.participant", "dm4.core.default", "dm4.core.default", "dm4.events.event");
    }

    @Override
    @GET
    @Path(value="/{id}/participants")
    public List<RelatedTopic> getParticipants(@PathParam(value="id") long eventId) {
        return this.dm4.getTopic(eventId).getRelatedTopics("dm4.events.participant", "dm4.core.default", "dm4.core.default", "dm4.contacts.person");
    }

    public void preCreateAssociation(AssociationModel assoc) {
        DMXUtils.associationAutoTyping((AssociationModel)assoc, (String)"dm4.events.event", (String)"dm4.contacts.person", (String)"dm4.events.participant", (String)"dm4.core.default", (String)"dm4.core.default", (CoreService)this.dm4);
        RoleModel[] roles = DMXUtils.associationAutoTyping((AssociationModel)assoc, (String)"dm4.events.event", (String)"dm4.contacts.address", (String)"dm4.core.aggregation", (String)"dm4.core.parent", (String)"dm4.core.child", (CoreService)this.dm4);
        if (roles != null) {
            long eventId = roles[0].getPlayerId();
            Topic event = this.dm4.getTopic(eventId);
            event.getChildTopics().getTopic("dm4.contacts.address").getRelatingAssociation().delete();
            this.timeService.setModified((DMXObject)event);
        }
    }
}

