/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.storage.neo4j;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.index.lucene.QueryContext;
import org.neo4j.index.lucene.ValueContext;
import systems.dmx.core.model.AssociationModel;
import systems.dmx.core.model.AssociationRoleModel;
import systems.dmx.core.model.DMXObjectModel;
import systems.dmx.core.model.IndexMode;
import systems.dmx.core.model.RelatedAssociationModel;
import systems.dmx.core.model.RelatedTopicModel;
import systems.dmx.core.model.RoleModel;
import systems.dmx.core.model.SimpleValue;
import systems.dmx.core.model.TopicModel;
import systems.dmx.core.model.TopicRoleModel;
import systems.dmx.core.service.ModelFactory;
import systems.dmx.core.storage.spi.DMXStorage;
import systems.dmx.core.storage.spi.DMXTransaction;
import systems.dmx.storage.neo4j.AssociationModelIterator;
import systems.dmx.storage.neo4j.Neo4jTransactionAdapter;
import systems.dmx.storage.neo4j.NodeType;
import systems.dmx.storage.neo4j.RelationtypeCache;
import systems.dmx.storage.neo4j.TopicModelIterator;

public class Neo4jStorage
implements DMXStorage {
    private static final String KEY_NODE_TYPE = "nodeType";
    private static final String KEY_VALUE = "value";
    private static final String KEY_URI = "uri";
    private static final String KEY_TPYE_URI = "typeUri";
    private static final String KEY_FULLTEXT = "fulltext";
    private static final String KEY_ASSOC_ID = "assocId";
    private static final String KEY_ASSOC_TPYE_URI = "assocTypeUri";
    private static final String KEY_ROLE_TPYE_URI = "roleTypeUri";
    private static final String KEY_PLAYER_TPYE = "playerType";
    private static final String KEY_PLAYER_ID = "playerId";
    private static final String KEY_PLAYER_TYPE_URI = "playerTypeUri";
    GraphDatabaseService neo4j = null;
    private RelationtypeCache relTypeCache;
    private Index<Node> topicContentExact;
    private Index<Node> topicContentFulltext;
    private Index<Node> assocContentExact;
    private Index<Node> assocContentFulltext;
    private Index<Node> assocMetadata;
    private ModelFactory mf;
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    Neo4jStorage(String databasePath, ModelFactory mf) {
        try {
            this.neo4j = new GraphDatabaseFactory().newEmbeddedDatabase(databasePath);
            this.relTypeCache = new RelationtypeCache(this.neo4j);
            this.topicContentExact = this.createExactIndex("topic-content-exact");
            this.topicContentFulltext = this.createFulltextIndex("topic-content-fulltext");
            this.assocContentExact = this.createExactIndex("assoc-content-exact");
            this.assocContentFulltext = this.createFulltextIndex("assoc-content-fulltext");
            this.assocMetadata = this.createExactIndex("assoc-metadata");
            this.mf = mf;
        }
        catch (Exception e) {
            if (this.neo4j != null) {
                this.shutdown();
            }
            throw new RuntimeException("Creating the Neo4j instance and indexes failed", e);
        }
    }

    public TopicModel fetchTopic(long topicId) {
        return this.buildTopic(this.fetchTopicNode(topicId));
    }

    public TopicModel fetchTopic(String key, Object value) {
        Node node = (Node)this.topicContentExact.get(key, value).getSingle();
        return node != null ? this.buildTopic(node) : null;
    }

    public List<TopicModel> fetchTopics(String key, Object value) {
        return this.buildTopics((Iterable<Node>)this.topicContentExact.query(key, value));
    }

    public List<TopicModel> queryTopics(Object value) {
        return this.queryTopics(null, value);
    }

    public List<TopicModel> queryTopics(String key, Object value) {
        if (key == null) {
            key = KEY_FULLTEXT;
        }
        if (value == null) {
            throw new IllegalArgumentException("Tried to call queryTopics() with a null value Object (key=\"" + key + "\")");
        }
        return this.buildTopics((Iterable<Node>)this.topicContentFulltext.query(key, value));
    }

    public Iterator<TopicModel> fetchAllTopics() {
        return new TopicModelIterator(this);
    }

    public void storeTopic(TopicModel topicModel) {
        this.setDefaults((DMXObjectModel)topicModel);
        Node topicNode = this.neo4j.createNode();
        topicNode.setProperty(KEY_NODE_TYPE, (Object)"topic");
        this.storeAndIndexTopicUri(topicNode, topicModel.getUri());
        this.storeAndIndexTopicTypeUri(topicNode, topicModel.getTypeUri());
        topicModel.setId(topicNode.getId());
    }

    public void storeTopicUri(long topicId, String uri) {
        this.storeAndIndexTopicUri(this.fetchTopicNode(topicId), uri);
    }

    public void storeTopicTypeUri(long topicId, String topicTypeUri) {
        Node topicNode = this.fetchTopicNode(topicId);
        this.storeAndIndexTopicTypeUri(topicNode, topicTypeUri);
        this.reindexTypeUri(topicNode, topicTypeUri);
    }

    public void storeTopicValue(long topicId, SimpleValue value, List<IndexMode> indexModes, String indexKey, SimpleValue indexValue) {
        Node topicNode = this.fetchTopicNode(topicId);
        topicNode.setProperty(KEY_VALUE, value.value());
        this.indexTopicNodeValue(topicNode, indexModes, indexKey, this.getIndexValue(value, indexValue));
    }

    public void indexTopicValue(long topicId, IndexMode indexMode, String indexKey, SimpleValue indexValue) {
        this.indexTopicNodeValue(this.fetchTopicNode(topicId), Arrays.asList(indexMode), indexKey, indexValue.value());
    }

    public void deleteTopic(long topicId) {
        Node topicNode = this.fetchTopicNode(topicId);
        topicNode.delete();
        this.removeTopicFromIndex(topicNode);
    }

    public AssociationModel fetchAssociation(long assocId) {
        return this.buildAssociation(this.fetchAssociationNode(assocId));
    }

    public AssociationModel fetchAssociation(String key, Object value) {
        Node node = (Node)this.assocContentExact.get(key, value).getSingle();
        return node != null ? this.buildAssociation(node) : null;
    }

    public List<AssociationModel> fetchAssociations(String key, Object value) {
        return this.buildAssociations((Iterable<Node>)this.assocContentExact.query(key, value));
    }

    public List<AssociationModel> fetchAssociations(String assocTypeUri, long topicId1, long topicId2, String roleTypeUri1, String roleTypeUri2) {
        return this.queryAssociationIndex(assocTypeUri, roleTypeUri1, NodeType.TOPIC, topicId1, null, roleTypeUri2, NodeType.TOPIC, topicId2, null);
    }

    public List<AssociationModel> fetchAssociationsBetweenTopicAndAssociation(String assocTypeUri, long topicId, long assocId, String topicRoleTypeUri, String assocRoleTypeUri) {
        return this.queryAssociationIndex(assocTypeUri, topicRoleTypeUri, NodeType.TOPIC, topicId, null, assocRoleTypeUri, NodeType.ASSOC, assocId, null);
    }

    public Iterator<AssociationModel> fetchAllAssociations() {
        return new AssociationModelIterator(this);
    }

    public long[] fetchPlayerIds(long assocId) {
        List<Relationship> rels = this.fetchRelationships(this.fetchAssociationNode(assocId));
        long[] playerIds = new long[]{this.playerId(rels.get(0)), this.playerId(rels.get(1))};
        return playerIds;
    }

    public void storeAssociation(AssociationModel assocModel) {
        this.setDefaults((DMXObjectModel)assocModel);
        Node assocNode = this.neo4j.createNode();
        assocNode.setProperty(KEY_NODE_TYPE, (Object)"assoc");
        this.storeAndIndexAssociationUri(assocNode, assocModel.getUri());
        this.storeAndIndexAssociationTypeUri(assocNode, assocModel.getTypeUri());
        RoleModel role1 = assocModel.getRoleModel1();
        RoleModel role2 = assocModel.getRoleModel2();
        Node playerNode1 = this.storePlayerRelationship(assocNode, role1);
        Node playerNode2 = this.storePlayerRelationship(assocNode, role2);
        this.indexAssociation(assocNode, role1.getRoleTypeUri(), playerNode1, role2.getRoleTypeUri(), playerNode2);
        assocModel.setId(assocNode.getId());
    }

    public void storeAssociationUri(long assocId, String uri) {
        this.storeAndIndexAssociationUri(this.fetchAssociationNode(assocId), uri);
    }

    public void storeAssociationTypeUri(long assocId, String assocTypeUri) {
        Node assocNode = this.fetchAssociationNode(assocId);
        this.storeAndIndexAssociationTypeUri(assocNode, assocTypeUri);
        this.indexAssociationType(assocNode, assocTypeUri);
        this.reindexTypeUri(assocNode, assocTypeUri);
    }

    public void storeAssociationValue(long assocId, SimpleValue value, List<IndexMode> indexModes, String indexKey, SimpleValue indexValue) {
        Node assocNode = this.fetchAssociationNode(assocId);
        assocNode.setProperty(KEY_VALUE, value.value());
        this.indexAssociationNodeValue(assocNode, indexModes, indexKey, this.getIndexValue(value, indexValue));
    }

    public void indexAssociationValue(long assocId, IndexMode indexMode, String indexKey, SimpleValue indexValue) {
        this.indexAssociationNodeValue(this.fetchAssociationNode(assocId), Arrays.asList(indexMode), indexKey, indexValue.value());
    }

    public void storeRoleTypeUri(long assocId, long playerId, String roleTypeUri) {
        Node assocNode = this.fetchAssociationNode(assocId);
        this.fetchRelationship(assocNode, playerId).delete();
        assocNode.createRelationshipTo(this.fetchNode(playerId), this.getRelationshipType(roleTypeUri));
        this.indexAssociationRoleType(assocNode, playerId, roleTypeUri);
    }

    public void deleteAssociation(long assocId) {
        Node assocNode = this.fetchAssociationNode(assocId);
        for (Relationship rel : this.fetchRelationships(assocNode)) {
            rel.delete();
        }
        assocNode.delete();
        this.removeAssociationFromIndex(assocNode);
    }

    public DMXObjectModel fetchObject(long id) {
        Node node = this.fetchNode(id);
        NodeType nodeType = NodeType.of(node);
        switch (nodeType) {
            case TOPIC: {
                return this.buildTopic(node);
            }
            case ASSOC: {
                return this.buildAssociation(node);
            }
        }
        throw new RuntimeException("Unexpected node type: " + (Object)((Object)nodeType));
    }

    public List<AssociationModel> fetchTopicAssociations(long topicId) {
        return this.fetchAssociations(this.fetchTopicNode(topicId));
    }

    public List<AssociationModel> fetchAssociationAssociations(long assocId) {
        return this.fetchAssociations(this.fetchAssociationNode(assocId));
    }

    public List<RelatedTopicModel> fetchTopicRelatedTopics(long topicId, String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri) {
        return this.buildRelatedTopics(this.queryAssociationIndex(assocTypeUri, myRoleTypeUri, NodeType.TOPIC, topicId, null, othersRoleTypeUri, NodeType.TOPIC, -1L, othersTopicTypeUri), topicId);
    }

    public List<RelatedAssociationModel> fetchTopicRelatedAssociations(long topicId, String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersAssocTypeUri) {
        return this.buildRelatedAssociations(this.queryAssociationIndex(assocTypeUri, myRoleTypeUri, NodeType.TOPIC, topicId, null, othersRoleTypeUri, NodeType.ASSOC, -1L, othersAssocTypeUri), topicId);
    }

    public List<RelatedTopicModel> fetchAssociationRelatedTopics(long assocId, String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri) {
        return this.buildRelatedTopics(this.queryAssociationIndex(assocTypeUri, myRoleTypeUri, NodeType.ASSOC, assocId, null, othersRoleTypeUri, NodeType.TOPIC, -1L, othersTopicTypeUri), assocId);
    }

    public List<RelatedAssociationModel> fetchAssociationRelatedAssociations(long assocId, String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersAssocTypeUri) {
        return this.buildRelatedAssociations(this.queryAssociationIndex(assocTypeUri, myRoleTypeUri, NodeType.ASSOC, assocId, null, othersRoleTypeUri, NodeType.ASSOC, -1L, othersAssocTypeUri), assocId);
    }

    public List<RelatedTopicModel> fetchRelatedTopics(long id, String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri) {
        return this.buildRelatedTopics(this.queryAssociationIndex(assocTypeUri, myRoleTypeUri, null, id, null, othersRoleTypeUri, NodeType.TOPIC, -1L, othersTopicTypeUri), id);
    }

    public List<RelatedAssociationModel> fetchRelatedAssociations(long id, String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersAssocTypeUri) {
        return this.buildRelatedAssociations(this.queryAssociationIndex(assocTypeUri, myRoleTypeUri, null, id, null, othersRoleTypeUri, NodeType.ASSOC, -1L, othersAssocTypeUri), id);
    }

    public Object fetchProperty(long id, String propUri) {
        return this.fetchNode(id).getProperty(propUri);
    }

    public boolean hasProperty(long id, String propUri) {
        return this.fetchNode(id).hasProperty(propUri);
    }

    public List<TopicModel> fetchTopicsByProperty(String propUri, Object propValue) {
        return this.buildTopics((Iterable<Node>)this.queryIndexByProperty(this.topicContentExact, propUri, propValue));
    }

    public List<TopicModel> fetchTopicsByPropertyRange(String propUri, Number from, Number to) {
        return this.buildTopics((Iterable<Node>)this.queryIndexByPropertyRange(this.topicContentExact, propUri, from, to));
    }

    public List<AssociationModel> fetchAssociationsByProperty(String propUri, Object propValue) {
        return this.buildAssociations((Iterable<Node>)this.queryIndexByProperty(this.assocContentExact, propUri, propValue));
    }

    public List<AssociationModel> fetchAssociationsByPropertyRange(String propUri, Number from, Number to) {
        return this.buildAssociations((Iterable<Node>)this.queryIndexByPropertyRange(this.assocContentExact, propUri, from, to));
    }

    public void storeTopicProperty(long topicId, String propUri, Object propValue, boolean addToIndex) {
        Index<Node> exactIndex = addToIndex ? this.topicContentExact : null;
        this.storeAndIndexExactValue(this.fetchTopicNode(topicId), propUri, propValue, exactIndex);
    }

    public void storeAssociationProperty(long assocId, String propUri, Object propValue, boolean addToIndex) {
        Index<Node> exactIndex = addToIndex ? this.assocContentExact : null;
        this.storeAndIndexExactValue(this.fetchAssociationNode(assocId), propUri, propValue, exactIndex);
    }

    public void indexTopicProperty(long topicId, String propUri, Object propValue) {
        this.indexExactValue(this.fetchTopicNode(topicId), propUri, propValue, this.topicContentExact);
    }

    public void indexAssociationProperty(long assocId, String propUri, Object propValue) {
        this.storeAndIndexExactValue(this.fetchAssociationNode(assocId), propUri, propValue, this.assocContentExact);
    }

    public void deleteTopicProperty(long topicId, String propUri) {
        Node topicNode = this.fetchTopicNode(topicId);
        topicNode.removeProperty(propUri);
        this.removeTopicPropertyFromIndex(topicNode, propUri);
    }

    public void deleteAssociationProperty(long assocId, String propUri) {
        Node assocNode = this.fetchAssociationNode(assocId);
        assocNode.removeProperty(propUri);
        this.removeAssociationPropertyFromIndex(assocNode, propUri);
    }

    public DMXTransaction beginTx() {
        return new Neo4jTransactionAdapter(this.neo4j);
    }

    public boolean setupRootNode() {
        try {
            Node rootNode = this.fetchNode(0L);
            if (rootNode.getProperty(KEY_NODE_TYPE, null) != null) {
                return false;
            }
            rootNode.setProperty(KEY_NODE_TYPE, (Object)"topic");
            rootNode.setProperty(KEY_VALUE, (Object)"Meta Type");
            this.storeAndIndexTopicUri(rootNode, "dm4.core.meta_type");
            this.storeAndIndexTopicTypeUri(rootNode, "dm4.core.meta_meta_type");
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException("Setting up the root node (0) failed", e);
        }
    }

    public void shutdown() {
        this.neo4j.shutdown();
    }

    public Object getDatabaseVendorObject() {
        return this.neo4j;
    }

    public Object getDatabaseVendorObject(long objectId) {
        return this.fetchNode(objectId);
    }

    public ModelFactory getModelFactory() {
        return this.mf;
    }

    private void storeAndIndexTopicUri(Node topicNode, String uri) {
        this.checkUriUniqueness(uri);
        this.storeAndIndexExactValue(topicNode, KEY_URI, uri, this.topicContentExact);
    }

    private void storeAndIndexAssociationUri(Node assocNode, String uri) {
        this.checkUriUniqueness(uri);
        this.storeAndIndexExactValue(assocNode, KEY_URI, uri, this.assocContentExact);
    }

    private void storeAndIndexTopicTypeUri(Node topicNode, String topicTypeUri) {
        this.storeAndIndexExactValue(topicNode, KEY_TPYE_URI, topicTypeUri, this.topicContentExact);
    }

    private void storeAndIndexAssociationTypeUri(Node assocNode, String assocTypeUri) {
        this.storeAndIndexExactValue(assocNode, KEY_TPYE_URI, assocTypeUri, this.assocContentExact);
    }

    private void storeAndIndexExactValue(Node node, String key, Object value, Index<Node> exactIndex) {
        node.setProperty(key, value);
        if (exactIndex != null) {
            this.indexExactValue(node, key, value, exactIndex);
        }
    }

    private void indexExactValue(Node node, String key, Object value, Index<Node> exactIndex) {
        if (value instanceof Number) {
            value = ValueContext.numeric((Number)((Number)value));
        }
        this.indexNodeValue(node, value, Arrays.asList(IndexMode.KEY), key, exactIndex, null);
    }

    private void indexTopicNodeValue(Node topicNode, List<IndexMode> indexModes, String indexKey, Object indexValue) {
        this.indexNodeValue(topicNode, indexValue, indexModes, indexKey, this.topicContentExact, this.topicContentFulltext);
    }

    private void indexAssociationNodeValue(Node assocNode, List<IndexMode> indexModes, String indexKey, Object indexValue) {
        this.indexNodeValue(assocNode, indexValue, indexModes, indexKey, this.assocContentExact, this.assocContentFulltext);
    }

    private Object getIndexValue(SimpleValue value, SimpleValue indexValue) {
        return indexValue != null ? indexValue.value() : value.value();
    }

    private void indexNodeValue(Node node, Object value, List<IndexMode> indexModes, String indexKey, Index<Node> exactIndex, Index<Node> fulltextIndex) {
        for (IndexMode indexMode : indexModes) {
            if (indexMode == IndexMode.OFF) {
                return;
            }
            if (indexMode == IndexMode.KEY) {
                exactIndex.remove((PropertyContainer)node, indexKey);
                exactIndex.add((PropertyContainer)node, indexKey, value);
                continue;
            }
            if (indexMode == IndexMode.FULLTEXT) {
                fulltextIndex.remove((PropertyContainer)node, KEY_FULLTEXT);
                fulltextIndex.add((PropertyContainer)node, KEY_FULLTEXT, value);
                continue;
            }
            if (indexMode == IndexMode.FULLTEXT_KEY) {
                fulltextIndex.remove((PropertyContainer)node, indexKey);
                fulltextIndex.add((PropertyContainer)node, indexKey, value);
                continue;
            }
            throw new RuntimeException("Unexpected index mode: \"" + indexMode + "\"");
        }
    }

    private void indexAssociation(Node assocNode, String roleTypeUri1, Node playerNode1, String roleTypeUri2, Node playerNode2) {
        this.indexAssociationId(assocNode);
        this.indexAssociationType(assocNode, this.typeUri(assocNode));
        this.indexAssociationRole(assocNode, 1, roleTypeUri1, playerNode1);
        this.indexAssociationRole(assocNode, 2, roleTypeUri2, playerNode2);
    }

    private void indexAssociationId(Node assocNode) {
        this.assocMetadata.add((PropertyContainer)assocNode, KEY_ASSOC_ID, (Object)assocNode.getId());
    }

    private void indexAssociationType(Node assocNode, String assocTypeUri) {
        this.reindexValue(assocNode, KEY_ASSOC_TPYE_URI, assocTypeUri);
    }

    private void indexAssociationRole(Node assocNode, int pos, String roleTypeUri, Node playerNode) {
        this.assocMetadata.add((PropertyContainer)assocNode, KEY_ROLE_TPYE_URI + pos, (Object)roleTypeUri);
        this.assocMetadata.add((PropertyContainer)assocNode, KEY_PLAYER_TPYE + pos, (Object)NodeType.of(playerNode).stringify());
        this.assocMetadata.add((PropertyContainer)assocNode, KEY_PLAYER_ID + pos, (Object)playerNode.getId());
        this.assocMetadata.add((PropertyContainer)assocNode, KEY_PLAYER_TYPE_URI + pos, (Object)this.typeUri(playerNode));
    }

    private void indexAssociationRoleType(Node assocNode, long playerId, String roleTypeUri) {
        int pos = this.lookupPlayerPosition(assocNode.getId(), playerId);
        this.reindexValue(assocNode, KEY_ROLE_TPYE_URI, pos, roleTypeUri);
    }

    private int lookupPlayerPosition(long assocId, long playerId) {
        boolean pos1 = this.isPlayerAtPosition(1, assocId, playerId);
        boolean pos2 = this.isPlayerAtPosition(2, assocId, playerId);
        if (pos1 && pos2) {
            throw new RuntimeException("Ambiguity: both players have ID " + playerId + " in association " + assocId);
        }
        if (pos1) {
            return 1;
        }
        if (pos2) {
            return 2;
        }
        throw new IllegalArgumentException("ID " + playerId + " is not a player in association " + assocId);
    }

    private boolean isPlayerAtPosition(int pos, long assocId, long playerId) {
        BooleanQuery query = new BooleanQuery();
        this.addTermQuery(KEY_ASSOC_ID, assocId, query);
        this.addTermQuery(KEY_PLAYER_ID + pos, playerId, query);
        return this.assocMetadata.query((Object)query).getSingle() != null;
    }

    private void reindexTypeUri(Node playerNode, String typeUri) {
        this.reindexTypeUri(1, playerNode, typeUri);
        this.reindexTypeUri(2, playerNode, typeUri);
    }

    private void reindexTypeUri(int pos, Node playerNode, String typeUri) {
        for (Node assocNode : this.lookupAssociations(pos, playerNode)) {
            this.reindexValue(assocNode, KEY_PLAYER_TYPE_URI, pos, typeUri);
        }
    }

    private IndexHits<Node> lookupAssociations(int pos, Node playerNode) {
        return this.assocMetadata.get(KEY_PLAYER_ID + pos, (Object)playerNode.getId());
    }

    private void reindexValue(Node assocNode, String key, int pos, String value) {
        this.reindexValue(assocNode, key + pos, value);
    }

    private void reindexValue(Node assocNode, String key, String value) {
        this.assocMetadata.remove((PropertyContainer)assocNode, key);
        this.assocMetadata.add((PropertyContainer)assocNode, key, (Object)value);
    }

    private IndexHits<Node> queryIndexByProperty(Index<Node> index, String propUri, Object propValue) {
        if (propValue instanceof Number) {
            propValue = ValueContext.numeric((Number)((Number)propValue));
        }
        return index.get(propUri, propValue);
    }

    private IndexHits<Node> queryIndexByPropertyRange(Index<Node> index, String propUri, Number from, Number to) {
        return index.query((Object)this.buildNumericRangeQuery(propUri, from, to));
    }

    private List<AssociationModel> queryAssociationIndex(String assocTypeUri, String roleTypeUri1, NodeType playerType1, long playerId1, String playerTypeUri1, String roleTypeUri2, NodeType playerType2, long playerId2, String playerTypeUri2) {
        return this.buildAssociations((Iterable<Node>)this.assocMetadata.query((Object)this.buildAssociationQuery(assocTypeUri, roleTypeUri1, playerType1, playerId1, playerTypeUri1, roleTypeUri2, playerType2, playerId2, playerTypeUri2)));
    }

    private QueryContext buildNumericRangeQuery(String propUri, Number from, Number to) {
        return QueryContext.numericRange((String)propUri, (Number)from, (Number)to);
    }

    private Query buildAssociationQuery(String assocTypeUri, String roleTypeUri1, NodeType playerType1, long playerId1, String playerTypeUri1, String roleTypeUri2, NodeType playerType2, long playerId2, String playerTypeUri2) {
        BooleanQuery direction1 = new BooleanQuery();
        this.addRole(direction1, 1, roleTypeUri1, playerType1, playerId1, playerTypeUri1);
        this.addRole(direction1, 2, roleTypeUri2, playerType2, playerId2, playerTypeUri2);
        BooleanQuery direction2 = new BooleanQuery();
        this.addRole(direction2, 1, roleTypeUri2, playerType2, playerId2, playerTypeUri2);
        this.addRole(direction2, 2, roleTypeUri1, playerType1, playerId1, playerTypeUri1);
        BooleanQuery roleQuery = new BooleanQuery();
        roleQuery.add((Query)direction1, BooleanClause.Occur.SHOULD);
        roleQuery.add((Query)direction2, BooleanClause.Occur.SHOULD);
        BooleanQuery query = new BooleanQuery();
        if (assocTypeUri != null) {
            this.addTermQuery(KEY_ASSOC_TPYE_URI, assocTypeUri, query);
        }
        query.add((Query)roleQuery, BooleanClause.Occur.MUST);
        return query;
    }

    private void addRole(BooleanQuery query, int pos, String roleTypeUri, NodeType playerType, long playerId, String playerTypeUri) {
        if (roleTypeUri != null) {
            this.addTermQuery(KEY_ROLE_TPYE_URI + pos, roleTypeUri, query);
        }
        if (playerType != null) {
            this.addTermQuery(KEY_PLAYER_TPYE + pos, playerType, query);
        }
        if (playerId != -1L) {
            this.addTermQuery(KEY_PLAYER_ID + pos, playerId, query);
        }
        if (playerTypeUri != null) {
            this.addTermQuery(KEY_PLAYER_TYPE_URI + pos, playerTypeUri, query);
        }
    }

    private void addTermQuery(String key, long value, BooleanQuery query) {
        this.addTermQuery(key, Long.toString(value), query);
    }

    private void addTermQuery(String key, NodeType nodeType, BooleanQuery query) {
        this.addTermQuery(key, nodeType.stringify(), query);
    }

    private void addTermQuery(String key, String value, BooleanQuery query) {
        query.add((Query)new TermQuery(new Term(key, value)), BooleanClause.Occur.MUST);
    }

    private void removeTopicFromIndex(Node topicNode) {
        this.topicContentExact.remove((PropertyContainer)topicNode);
        this.topicContentFulltext.remove((PropertyContainer)topicNode);
    }

    private void removeAssociationFromIndex(Node assocNode) {
        this.assocContentExact.remove((PropertyContainer)assocNode);
        this.assocContentFulltext.remove((PropertyContainer)assocNode);
        this.assocMetadata.remove((PropertyContainer)assocNode);
    }

    private void removeTopicPropertyFromIndex(Node topicNode, String propUri) {
        this.topicContentExact.remove((PropertyContainer)topicNode, propUri);
    }

    private void removeAssociationPropertyFromIndex(Node assocNode, String propUri) {
        this.assocContentExact.remove((PropertyContainer)assocNode, propUri);
    }

    private Index<Node> createExactIndex(String name) {
        return this.neo4j.index().forNodes(name);
    }

    private Index<Node> createFulltextIndex(String name) {
        if (this.neo4j.index().existsForNodes(name)) {
            return this.neo4j.index().forNodes(name);
        }
        Map configuration = MapUtil.stringMap((String[])new String[]{"provider", "lucene", "type", KEY_FULLTEXT});
        return this.neo4j.index().forNodes(name, configuration);
    }

    TopicModel buildTopic(Node topicNode) {
        try {
            return this.mf.newTopicModel(topicNode.getId(), this.uri(topicNode), this.typeUri(topicNode), this.simpleValue(topicNode), null);
        }
        catch (Exception e) {
            throw new RuntimeException("Building a TopicModel failed (id=" + topicNode.getId() + ", typeUri=" + this.typeUri(topicNode) + ")");
        }
    }

    private List<TopicModel> buildTopics(Iterable<Node> topicNodes) {
        ArrayList<TopicModel> topics = new ArrayList<TopicModel>();
        for (Node topicNode : topicNodes) {
            topics.add(this.buildTopic(topicNode));
        }
        return topics;
    }

    AssociationModel buildAssociation(Node assocNode) {
        try {
            List<RoleModel> roleModels = this.buildRoleModels(assocNode);
            return this.mf.newAssociationModel(assocNode.getId(), this.uri(assocNode), this.typeUri(assocNode), roleModels.get(0), roleModels.get(1), this.simpleValue(assocNode), null);
        }
        catch (Exception e) {
            throw new RuntimeException("Building an AssociationModel failed (id=" + assocNode.getId() + ", typeUri=" + this.typeUri(assocNode) + ")");
        }
    }

    private List<AssociationModel> buildAssociations(Iterable<Node> assocNodes) {
        ArrayList<AssociationModel> assocs = new ArrayList<AssociationModel>();
        for (Node assocNode : assocNodes) {
            assocs.add(this.buildAssociation(assocNode));
        }
        return assocs;
    }

    private List<RoleModel> buildRoleModels(Node assocNode) {
        ArrayList<RoleModel> roleModels = new ArrayList<RoleModel>();
        for (Relationship rel : this.fetchRelationships(assocNode)) {
            Node node = rel.getEndNode();
            String roleTypeUri = rel.getType().name();
            RoleModel roleModel = NodeType.of(node).createRoleModel(node, roleTypeUri, this.mf);
            roleModels.add(roleModel);
        }
        return roleModels;
    }

    private Node storePlayerRelationship(Node assocNode, RoleModel roleModel) {
        Node playerNode = this.fetchPlayerNode(roleModel);
        assocNode.createRelationshipTo(playerNode, this.getRelationshipType(roleModel.getRoleTypeUri()));
        return playerNode;
    }

    private Node fetchPlayerNode(RoleModel roleModel) {
        if (roleModel instanceof TopicRoleModel) {
            return this.fetchTopicPlayerNode((TopicRoleModel)roleModel);
        }
        if (roleModel instanceof AssociationRoleModel) {
            return this.fetchAssociationNode(roleModel.getPlayerId());
        }
        throw new RuntimeException("Unexpected role model: " + roleModel);
    }

    private Node fetchTopicPlayerNode(TopicRoleModel roleModel) {
        if (roleModel.topicIdentifiedByUri()) {
            return this.fetchTopicNodeByUri(roleModel.getTopicUri());
        }
        return this.fetchTopicNode(roleModel.getPlayerId());
    }

    private Relationship fetchRelationship(Node assocNode, long playerId) {
        boolean match2;
        List<Relationship> rels = this.fetchRelationships(assocNode);
        boolean match1 = this.playerId(rels.get(0)) == playerId;
        boolean bl = match2 = this.playerId(rels.get(1)) == playerId;
        if (match1 && match2) {
            throw new RuntimeException("Ambiguity: both players have ID " + playerId + " in association " + assocNode.getId());
        }
        if (match1) {
            return rels.get(0);
        }
        if (match2) {
            return rels.get(1);
        }
        throw new IllegalArgumentException("ID " + playerId + " is not a player in association " + assocNode.getId());
    }

    private List<Relationship> fetchRelationships(Node assocNode) {
        ArrayList<Relationship> rels = new ArrayList<Relationship>();
        for (Relationship rel : assocNode.getRelationships(Direction.OUTGOING)) {
            rels.add(rel);
        }
        if (rels.size() != 2) {
            throw new RuntimeException("Association " + assocNode.getId() + " connects " + rels.size() + " player instead of 2");
        }
        return rels;
    }

    private long playerId(Relationship rel) {
        return rel.getEndNode().getId();
    }

    private List<AssociationModel> fetchAssociations(Node node) {
        ArrayList<AssociationModel> assocs = new ArrayList<AssociationModel>();
        for (Relationship rel : node.getRelationships(Direction.INCOMING)) {
            Node assocNode = rel.getStartNode();
            if (!assocNode.hasProperty(KEY_NODE_TYPE)) continue;
            assocs.add(this.buildAssociation(assocNode));
        }
        return assocs;
    }

    private Node fetchTopicNode(long topicId) {
        return this.checkNodeType(this.fetchNode(topicId), NodeType.TOPIC);
    }

    private Node fetchAssociationNode(long assocId) {
        return this.checkNodeType(this.fetchNode(assocId), NodeType.ASSOC);
    }

    private Node fetchNode(long id) {
        return this.neo4j.getNodeById(id);
    }

    private Node fetchTopicNodeByUri(String uri) {
        Node node = (Node)this.topicContentExact.get(KEY_URI, (Object)uri).getSingle();
        if (node == null) {
            throw new RuntimeException("Topic with URI \"" + uri + "\" not found in DB");
        }
        return this.checkNodeType(node, NodeType.TOPIC);
    }

    private Node checkNodeType(Node node, NodeType type) {
        if (NodeType.of(node) != type) {
            throw new IllegalArgumentException(type.error(node));
        }
        return node;
    }

    private RelationshipType getRelationshipType(String typeName) {
        return this.relTypeCache.get(typeName);
    }

    private String uri(Node node) {
        return (String)node.getProperty(KEY_URI);
    }

    private String typeUri(Node node) {
        return (String)node.getProperty(KEY_TPYE_URI);
    }

    private SimpleValue simpleValue(Node node) {
        return new SimpleValue(node.getProperty(KEY_VALUE));
    }

    private List<RelatedTopicModel> buildRelatedTopics(List<AssociationModel> assocs, long playerId) {
        ArrayList<RelatedTopicModel> relTopics = new ArrayList<RelatedTopicModel>();
        for (AssociationModel assoc : assocs) {
            relTopics.add(this.mf.newRelatedTopicModel(this.fetchTopic(assoc.getOtherPlayerId(playerId)), assoc));
        }
        return relTopics;
    }

    private List<RelatedAssociationModel> buildRelatedAssociations(List<AssociationModel> assocs, long playerId) {
        ArrayList<RelatedAssociationModel> relAssocs = new ArrayList<RelatedAssociationModel>();
        for (AssociationModel assoc : assocs) {
            relAssocs.add(this.mf.newRelatedAssociationModel(this.fetchAssociation(assoc.getOtherPlayerId(playerId)), assoc));
        }
        return relAssocs;
    }

    private void setDefaults(DMXObjectModel model) {
        if (model.getUri() == null) {
            model.setUri("");
        }
        if (model.getSimpleValue() == null) {
            model.setSimpleValue("");
        }
    }

    private void checkUriUniqueness(String uri) {
        if (uri.equals("")) {
            return;
        }
        Node n1 = (Node)this.topicContentExact.get(KEY_URI, (Object)uri).getSingle();
        Node n2 = (Node)this.assocContentExact.get(KEY_URI, (Object)uri).getSingle();
        if (n1 != null || n2 != null) {
            throw new RuntimeException("URI \"" + uri + "\" is not unique");
        }
    }
}

