/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.impl;

import com.sun.jersey.api.core.DefaultResourceConfig;
import com.sun.jersey.api.core.ResourceConfig;
import com.sun.jersey.spi.container.servlet.ServletContainer;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Path;
import javax.ws.rs.core.Application;
import javax.ws.rs.ext.Provider;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import systems.dmx.core.impl.CoreEvent;
import systems.dmx.core.impl.JerseyRequestFilter;
import systems.dmx.core.impl.JerseyResponseFilter;
import systems.dmx.core.impl.PersistenceLayer;
import systems.dmx.core.impl.RestResourcesPublication;
import systems.dmx.core.impl.StaticResourcesPublication;
import systems.dmx.core.impl.TransactionFactory;
import systems.dmx.core.osgi.CoreActivator;
import systems.dmx.core.service.WebSocketsService;
import systems.dmx.core.util.JavaUtils;
import systems.dmx.core.util.UniversalExceptionMapper;

class WebPublishingService {
    private static final String ROOT_APPLICATION_PATH = System.getProperty("dm4.webservice.path", "/");
    private ResourceConfig jerseyApplication;
    private int classCount = 0;
    private int singletonCount = 0;
    private ServletContainer jerseyServlet;
    private boolean isJerseyServletRegistered = false;
    private PersistenceLayer pl;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    WebPublishingService(PersistenceLayer pl, WebSocketsService ws) {
        try {
            this.logger.info("Setting up the WebPublishingService");
            this.pl = pl;
            this.jerseyApplication = new DefaultResourceConfig();
            Map properties = this.jerseyApplication.getProperties();
            properties.put("com.sun.jersey.spi.container.ContainerRequestFilters", new JerseyRequestFilter(pl.em));
            properties.put("com.sun.jersey.spi.container.ContainerResponseFilters", new JerseyResponseFilter(pl.em, ws));
            properties.put("com.sun.jersey.spi.container.ResourceFilters", new TransactionFactory(pl));
            this.jerseyServlet = new ServletContainer((Application)this.jerseyApplication);
        }
        catch (Exception e) {
            throw new RuntimeException("Setting up the WebPublishingService failed", e);
        }
    }

    StaticResourcesPublication publishWebResources(String uriNamespace, Bundle bundle) throws NamespaceException {
        this.getHttpService().registerResources(uriNamespace, "/web", (HttpContext)new BundleResourcesHTTPContext(bundle));
        return new StaticResourcesPublication(uriNamespace, this);
    }

    StaticResourcesPublication publishFileSystem(String uriNamespace, String path) throws NamespaceException {
        this.getHttpService().registerResources(uriNamespace, "/", (HttpContext)new FileSystemHTTPContext(path));
        return new StaticResourcesPublication(uriNamespace, this);
    }

    void unpublishStaticResources(String uriNamespace) {
        HttpService httpService = this.getHttpService();
        if (httpService != null) {
            httpService.unregister(uriNamespace);
        } else {
            this.logger.warning("HTTP service is already gone");
        }
    }

    synchronized RestResourcesPublication publishRestResources(List<Object> singletons, List<Class<?>> classes) {
        try {
            this.addToApplication(singletons, classes);
            if (!this.isJerseyServletRegistered) {
                if (this.hasRootResources()) {
                    this.registerJerseyServlet();
                }
            } else {
                this.reloadJerseyServlet();
            }
            return new RestResourcesPublication(singletons, classes, this);
        }
        catch (Exception e) {
            this.unpublishRestResources(singletons, classes);
            throw new RuntimeException("Adding classes/singletons to Jersey application failed", e);
        }
    }

    synchronized void unpublishRestResources(List<Object> singletons, List<Class<?>> classes) {
        this.removeFromApplication(singletons, classes);
        if (!this.hasRootResources()) {
            this.unregisterJerseyServlet();
        } else {
            this.reloadJerseyServlet();
        }
    }

    boolean isRootResource(Object object) {
        return this.getUriNamespace(object) != null;
    }

    String getUriNamespace(Object object) {
        Path path = object.getClass().getAnnotation(Path.class);
        return path != null ? path.value() : null;
    }

    boolean isProviderClass(Class clazz) {
        return clazz.isAnnotationPresent(Provider.class);
    }

    private HttpService getHttpService() {
        return CoreActivator.getHttpService();
    }

    private void addToApplication(List<Object> singletons, List<Class<?>> classes) {
        this.getClasses().addAll(classes);
        this.getSingletons().addAll(singletons);
        this.classCount += classes.size();
        this.singletonCount += singletons.size();
        this.logResourceInfo();
    }

    private void removeFromApplication(List<Object> singletons, List<Class<?>> classes) {
        this.getClasses().removeAll(classes);
        this.getSingletons().removeAll(singletons);
        this.classCount -= classes.size();
        this.singletonCount -= singletons.size();
        this.logResourceInfo();
    }

    private boolean hasRootResources() {
        return this.singletonCount > 0;
    }

    private void logResourceInfo() {
        this.logger.fine("##### DM Classes: " + this.classCount + ", All: " + this.getClasses().size() + " " + this.getClasses());
        this.logger.fine("##### DM Singletons: " + this.singletonCount + ", All: " + this.getSingletons().size() + " " + this.getSingletons());
    }

    private Set<Class<?>> getClasses() {
        return this.jerseyApplication.getClasses();
    }

    private Set<Object> getSingletons() {
        return this.jerseyApplication.getSingletons();
    }

    private void registerJerseyServlet() {
        try {
            this.logger.fine("########## Registering Jersey servlet at HTTP service (URI namespace=\"" + ROOT_APPLICATION_PATH + "\")");
            this.getHttpService().registerServlet(ROOT_APPLICATION_PATH, (Servlet)this.jerseyServlet, null, null);
            this.isJerseyServletRegistered = true;
        }
        catch (Exception e) {
            throw new RuntimeException("Registering Jersey servlet at HTTP service failed (URI namespace=\"" + ROOT_APPLICATION_PATH + "\")", e);
        }
    }

    private void unregisterJerseyServlet() {
        this.logger.fine("########## Unregistering Jersey servlet at HTTP service (URI namespace=\"" + ROOT_APPLICATION_PATH + "\")");
        HttpService httpService = this.getHttpService();
        if (httpService != null) {
            httpService.unregister(ROOT_APPLICATION_PATH);
        } else {
            this.logger.warning("HTTP service is already gone");
        }
        this.isJerseyServletRegistered = false;
    }

    private void reloadJerseyServlet() {
        this.logger.fine("##### Reloading Jersey servlet");
        this.jerseyServlet.reload();
    }

    private boolean staticResourceFilter(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            this.pl.em.fireEvent(CoreEvent.STATIC_RESOURCE_FILTER, request, response);
            return true;
        }
        catch (Throwable e) {
            new UniversalExceptionMapper(e, request).initResponse(response);
            return false;
        }
    }

    private class FileSystemHTTPContext
    implements HttpContext {
        private String basePath;

        private FileSystemHTTPContext(String basePath) {
            this.basePath = basePath;
        }

        public URL getResource(String name) {
            try {
                File index;
                File file = new File(this.basePath, name);
                if (file.isDirectory() && (index = new File(file, "index.html")).exists()) {
                    file = index;
                }
                URL url = file.toURI().toURL();
                WebPublishingService.this.logger.fine("### Mapping resource name \"" + name + "\" to URL \"" + url + "\"");
                return url;
            }
            catch (Exception e) {
                throw new RuntimeException("Mapping resource name \"" + name + "\" to URL failed", e);
            }
        }

        public String getMimeType(String name) {
            return JavaUtils.getFileType(name);
        }

        public boolean handleSecurity(HttpServletRequest request, HttpServletResponse response) throws IOException {
            return WebPublishingService.this.staticResourceFilter(request, response);
        }
    }

    private class BundleResourcesHTTPContext
    implements HttpContext {
        private Bundle bundle;

        private BundleResourcesHTTPContext(Bundle bundle) {
            this.bundle = bundle;
        }

        public URL getResource(String name) {
            if (name.equals("/web") || name.equals("/web/")) {
                name = "/web/index.html";
            }
            return this.bundle.getResource(name);
        }

        public String getMimeType(String name) {
            return JavaUtils.getFileType(name);
        }

        public boolean handleSecurity(HttpServletRequest request, HttpServletResponse response) throws IOException {
            return WebPublishingService.this.staticResourceFilter(request, response);
        }
    }
}

