/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.impl;

import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.websocket.WebSocket;
import org.eclipse.jetty.websocket.WebSocketHandler;
import systems.dmx.core.impl.WebSocketConnection;
import systems.dmx.core.impl.WebSocketConnectionPool;
import systems.dmx.core.service.CoreService;
import systems.dmx.core.service.WebSocketsService;
import systems.dmx.core.util.JavaUtils;

class WebSocketsServiceImpl
implements WebSocketsService {
    private static final int WEBSOCKETS_PORT = Integer.getInteger("dm4.websockets.port", 8081);
    private static final String WEBSOCKETS_URL = System.getProperty("dm4.websockets.url", "ws://localhost:8081");
    private WebSocketsServer server;
    private WebSocketConnectionPool pool = new WebSocketConnectionPool();
    private SendMessageWorker worker = new SendMessageWorker();
    private CoreService dm4;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    WebSocketsServiceImpl(CoreService dm4) {
        this.dm4 = dm4;
        this.init();
    }

    @Override
    public void messageToAll(String pluginUri, String message) {
        this.broadcast(pluginUri, message, null);
    }

    @Override
    public void messageToAllButOne(HttpServletRequest request, String pluginUri, String message) {
        WebSocketConnection connection = this.getConnection(request, pluginUri);
        if (connection != null) {
            this.broadcast(pluginUri, message, connection);
        }
    }

    @Override
    public void messageToOne(HttpServletRequest request, String pluginUri, String message) {
        WebSocketConnection connection = this.getConnection(request, pluginUri);
        if (connection != null) {
            this.queueMessage(connection, message);
        }
    }

    @Override
    public String getWebSocketsURL() {
        return WEBSOCKETS_URL;
    }

    private void init() {
        try {
            this.logger.info("##### Starting Jetty WebSocket server #####");
            this.server = new WebSocketsServer(WEBSOCKETS_PORT);
            this.server.start();
            this.worker.start();
            this.logger.info("### Jetty WebSocket server started successfully");
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Starting Jetty WebSocket server failed", e);
        }
    }

    void shutdown() {
        try {
            if (this.server != null) {
                this.logger.info("##### Stopping Jetty WebSocket server #####");
                this.worker.interrupt();
                this.server.stop();
            } else {
                this.logger.info("Stopping Jetty WebSocket server SKIPPED -- not yet started");
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Stopping Jetty WebSocket server failed", e);
        }
    }

    private WebSocketConnection getConnection(HttpServletRequest request, String pluginUri) {
        try {
            HttpSession session = request.getSession(false);
            if (session == null) {
                throw new RuntimeException("No valid session is associated with the request");
            }
            return this.pool.getConnection(pluginUri, session.getId());
        }
        catch (IllegalStateException e) {
            return null;
        }
    }

    private void broadcast(String pluginUri, String message, WebSocketConnection exclude) {
        Collection<WebSocketConnection> connections = this.pool.getConnections(pluginUri);
        if (connections != null) {
            for (WebSocketConnection connection : connections) {
                if (connection == exclude) continue;
                this.queueMessage(connection, message);
            }
        }
    }

    private void queueMessage(WebSocketConnection connection, String message) {
        this.worker.queueMessage(connection, message);
    }

    private static class QueuedMessage {
        private WebSocketConnection connection;
        private String message;

        private QueuedMessage(WebSocketConnection connection, String message) {
            this.connection = connection;
            this.message = message;
        }
    }

    private class SendMessageWorker
    extends Thread {
        private BlockingQueue<QueuedMessage> messages = new LinkedBlockingQueue<QueuedMessage>();

        private SendMessageWorker() {
            this.setPriority(1);
        }

        @Override
        public void run() {
            try {
                while (true) {
                    QueuedMessage message = this.messages.take();
                    SendMessageWorker.yield();
                    message.connection.sendMessage(message.message);
                }
            }
            catch (InterruptedException e) {
                WebSocketsServiceImpl.this.logger.info("### SendMessageWorker thread received an InterruptedException -- terminating");
            }
            catch (Exception e) {
                WebSocketsServiceImpl.this.logger.log(Level.WARNING, "An exception occurred in the SendMessageWorker thread -- terminating:", e);
            }
        }

        private void queueMessage(WebSocketConnection connection, String message) {
            try {
                this.messages.put(new QueuedMessage(connection, message));
            }
            catch (InterruptedException e) {
                WebSocketsServiceImpl.this.logger.log(Level.WARNING, "Queueing a message failed:", e);
            }
        }
    }

    private class WebSocketsServer
    extends Server {
        private int counter = 0;

        private WebSocketsServer(int port) {
            SelectChannelConnector connector = new SelectChannelConnector();
            connector.setPort(port);
            this.addConnector((Connector)connector);
            this.setHandler((Handler)new WebSocketHandler(){

                public WebSocket doWebSocketConnect(HttpServletRequest request, String protocol) {
                    WebSocketsServer.this.checkProtocol(protocol);
                    return new WebSocketConnection(protocol, WebSocketsServer.this.sessionId(request), WebSocketsServiceImpl.this.pool, WebSocketsServiceImpl.this.dm4);
                }
            });
        }

        private void checkProtocol(String pluginUri) {
            try {
                if (pluginUri == null) {
                    throw new RuntimeException("A plugin URI is missing in the WebSocket handshake -- Add your plugin's URI as the 2nd argument to the JavaScript WebSocket constructor");
                }
                WebSocketsServiceImpl.this.dm4.getPlugin(pluginUri);
            }
            catch (Exception e) {
                throw new RuntimeException("Opening a WebSocket connection " + (pluginUri != null ? "for plugin \"" + pluginUri + "\" " : "") + "failed", e);
            }
        }

        private String sessionId(HttpServletRequest request) {
            String sessionId = JavaUtils.cookieValue(request, "JSESSIONID");
            return sessionId != null ? sessionId : "anonymous-" + this.counter++;
        }
    }
}

