/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.model.topicmaps;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.jettison.json.JSONObject;
import systems.dmx.core.JSONEnabled;
import systems.dmx.core.util.DMXUtils;

public class ViewProperties
implements Iterable<String>,
JSONEnabled {
    private Map<String, Object> viewProps = new HashMap<String, Object>();

    public ViewProperties(JSONObject viewProps) {
        DMXUtils.toMap(viewProps, this.viewProps);
    }

    public ViewProperties() {
    }

    public ViewProperties(int x, int y, boolean visibility, boolean pinned) {
        this.initPos(x, y);
        this.initVisibility(visibility);
        this.initPinned(pinned);
    }

    public ViewProperties(int x, int y) {
        this.initPos(x, y);
    }

    public ViewProperties(boolean visibility) {
        this.initVisibility(visibility);
    }

    public Object get(String propUri) {
        return this.viewProps.get(propUri);
    }

    public ViewProperties put(String propUri, Object value) {
        this.viewProps.put(propUri, value);
        return this;
    }

    public int getInt(String propUri) {
        return (Integer)this.get(propUri);
    }

    public boolean getBoolean(String propUri) {
        return (Boolean)this.get(propUri);
    }

    @Override
    public Iterator<String> iterator() {
        return this.viewProps.keySet().iterator();
    }

    @Override
    public JSONObject toJSON() {
        return new JSONObject(this.viewProps);
    }

    public String toString() {
        return this.viewProps.toString();
    }

    private void initPos(int x, int y) {
        this.put("dm4.topicmaps.x", x);
        this.put("dm4.topicmaps.y", y);
    }

    private void initVisibility(boolean visibility) {
        this.put("dm4.topicmaps.visibility", visibility);
    }

    private void initPinned(boolean pinned) {
        this.put("dm4.topicmaps.pinned", pinned);
    }
}

