/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.storage.neo4j;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import systems.dmx.core.service.ModelFactory;
import systems.dmx.core.storage.spi.DMXStorage;
import systems.dmx.storage.neo4j.Neo4jStorage;

public class Neo4jStorageActivator
implements BundleActivator {
    private static final String DATABASE_PATH = System.getProperty("dm4.database.path", "deepamehta-db");
    private static BundleContext bundleContext;
    ModelFactory mf;
    private ServiceTracker modelFactoryTracker;
    private DMXStorage storage;
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    public void start(BundleContext bundleContext) {
        try {
            this.logger.info("========== Starting \"DMX Storage - Neo4j\" ==========");
            Neo4jStorageActivator.bundleContext = bundleContext;
            this.modelFactoryTracker = this.createServiceTracker(ModelFactory.class);
            this.modelFactoryTracker.open();
        }
        catch (Throwable e) {
            this.logger.log(Level.SEVERE, "An error occurred while starting \"DMX Storage - Neo4j\":", e);
        }
    }

    public void stop(BundleContext bundleContext) {
        try {
            this.logger.info("========== Stopping \"DMX Storage - Neo4j\" ==========");
            this.modelFactoryTracker.close();
            if (this.storage != null) {
                this.storage.shutdown();
            }
        }
        catch (Throwable e) {
            this.logger.log(Level.SEVERE, "An error occurred while stopping \"DMX Storage - Neo4j\":", e);
        }
    }

    private ServiceTracker createServiceTracker(final Class serviceInterface) {
        return new ServiceTracker(bundleContext, serviceInterface.getName(), null){

            public Object addingService(ServiceReference serviceRef) {
                Object service = null;
                try {
                    service = super.addingService(serviceRef);
                    Neo4jStorageActivator.this.addService(service);
                }
                catch (Throwable e) {
                    Neo4jStorageActivator.this.logger.log(Level.SEVERE, "An error occurred while adding service " + serviceInterface.getName() + " to \"DMX Storage - Neo4j\":", e);
                }
                return service;
            }

            public void removedService(ServiceReference ref, Object service) {
                try {
                    Neo4jStorageActivator.this.removeService(service);
                    super.removedService(ref, service);
                }
                catch (Throwable e) {
                    Neo4jStorageActivator.this.logger.log(Level.SEVERE, "An error occurred while removing service " + serviceInterface.getName() + " from \"DMX Storage - Neo4j\":", e);
                }
            }
        };
    }

    private void addService(Object service) {
        if (service instanceof ModelFactory) {
            this.logger.info("Adding ModelFactory service to DMX Storage - Neo4j");
            this.mf = (ModelFactory)service;
            this.checkRequirementsForActivation();
        }
    }

    private void removeService(Object service) {
        if (service == this.mf) {
            this.logger.info("Removing ModelFactory service from DMX Storage - Neo4j");
            this.mf = null;
        }
    }

    private void checkRequirementsForActivation() {
        if (this.mf != null) {
            this.storage = new Neo4jStorage(DATABASE_PATH, this.mf);
            this.logger.info("Registering DMX storage service - Neo4j - at OSGi framework");
            bundleContext.registerService(DMXStorage.class.getName(), (Object)this.storage, null);
        }
    }
}

