/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.workspaces.migrations;

import java.util.logging.Logger;
import systems.dmx.core.AssociationDefinition;
import systems.dmx.core.AssociationType;
import systems.dmx.core.DMXObject;
import systems.dmx.core.DMXType;
import systems.dmx.core.Topic;
import systems.dmx.core.TopicType;
import systems.dmx.core.service.Inject;
import systems.dmx.core.service.Migration;
import systems.dmx.workspaces.WorkspacesService;

public class Migration6
extends Migration {
    @Inject
    private WorkspacesService wsService;
    private long dmxWorkspaceId;
    private long types = 0L;
    private long standardTypes = 0L;
    private long assocDefs = 0L;
    private long configTopics = 0L;
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());

    public void run() {
        this.logger.info("########## Assigning standard association definitions (and their view config topics) to DMX workspace");
        this.dmxWorkspaceId = this.getDMXWorkspace().getId();
        for (TopicType topicType : this.dm4.getAllTopicTypes()) {
            this.assignWorkspace((DMXType)topicType);
        }
        for (AssociationType assocType : this.dm4.getAllAssociationTypes()) {
            this.assignWorkspace((DMXType)assocType);
        }
        this.logger.info("########## Assigning standard association definitions (and their view config topics) to DMX workspace complete\n    Types processed: " + this.types + "\n    Standard types: " + this.standardTypes + "\n    Association definitions: " + this.assocDefs + "\n    View config topics: " + this.configTopics);
    }

    private void assignWorkspace(DMXType type) {
        ++this.types;
        if (this.isDMXStandardType(type)) {
            ++this.standardTypes;
            for (AssociationDefinition assocDef : type.getAssocDefs()) {
                ++this.assocDefs;
                this.assignToDMXWorkspace((DMXObject)assocDef);
                for (Topic configTopic : assocDef.getViewConfig().getConfigTopics()) {
                    ++this.configTopics;
                    this.assignToDMXWorkspace((DMXObject)configTopic);
                }
            }
        }
    }

    private void assignToDMXWorkspace(DMXObject object) {
        this.wsService.assignToWorkspace(object, this.dmxWorkspaceId);
    }

    private Topic getDMXWorkspace() {
        return this.wsService.getWorkspace("dm4.workspaces.deepamehta");
    }

    private boolean isDMXStandardType(DMXType type) {
        return type.getUri().startsWith("dm4.");
    }
}

