/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.topicmaps.migrations;

import java.util.logging.Logger;
import systems.dmx.core.Association;
import systems.dmx.core.ChildTopics;
import systems.dmx.core.Topic;
import systems.dmx.core.service.Migration;

public class Migration4
extends Migration {
    private long assocs = 0L;
    private long topicsDeleted = 0L;
    private long typesDeleted = 0L;
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());

    public void run() {
        this.logger.info("########## Converting \"Topic Mapcontext\" associations");
        for (Association assoc : this.dm4.getAssociationsByType("dm4.topicmaps.topic_mapcontext")) {
            this.migrateMapcontextAssociation(assoc);
        }
        this.deleteTopicType("dm4.topicmaps.x");
        this.deleteTopicType("dm4.topicmaps.y");
        this.deleteTopicType("dm4.topicmaps.visibility");
        this.dm4.getAssociationType("dm4.topicmaps.topic_mapcontext").setDataTypeUri("dm4.core.text");
        this.logger.info("########## Converting \"Topic Mapcontext\" associations complete\n    Associations processed: " + this.assocs + "\n    X, Y, Visibility topics deleted: " + this.topicsDeleted + "\n    Topic types deleted: " + this.typesDeleted);
    }

    private void migrateMapcontextAssociation(Association assoc) {
        ++this.assocs;
        ChildTopics childs = assoc.getChildTopics();
        int x = childs.getInt("dm4.topicmaps.x");
        int y = childs.getInt("dm4.topicmaps.y");
        boolean visibility = childs.getBoolean("dm4.topicmaps.visibility");
        assoc.setProperty("dm4.topicmaps.x", (Object)x, false);
        assoc.setProperty("dm4.topicmaps.y", (Object)y, false);
        assoc.setProperty("dm4.topicmaps.visibility", (Object)visibility, false);
    }

    private void deleteTopicType(String topicTypeUri) {
        ++this.typesDeleted;
        for (Topic topic : this.dm4.getTopicsByType(topicTypeUri)) {
            topic.delete();
            ++this.topicsDeleted;
        }
        this.dm4.deleteTopicType(topicTypeUri);
    }
}

