/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.webclient;

import java.awt.Desktop;
import java.net.URI;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import systems.dmx.core.Association;
import systems.dmx.core.AssociationType;
import systems.dmx.core.DMXObject;
import systems.dmx.core.DMXType;
import systems.dmx.core.JSONEnabled;
import systems.dmx.core.RelatedTopic;
import systems.dmx.core.Topic;
import systems.dmx.core.TopicType;
import systems.dmx.core.ViewConfiguration;
import systems.dmx.core.model.AssociationTypeModel;
import systems.dmx.core.model.RoleModel;
import systems.dmx.core.model.TopicModel;
import systems.dmx.core.model.TopicTypeModel;
import systems.dmx.core.model.TypeModel;
import systems.dmx.core.osgi.PluginActivator;
import systems.dmx.core.service.Directive;
import systems.dmx.core.service.Directives;
import systems.dmx.core.service.Transactional;
import systems.dmx.core.service.event.AllPluginsActiveListener;
import systems.dmx.core.service.event.IntroduceAssociationTypeListener;
import systems.dmx.core.service.event.IntroduceTopicTypeListener;
import systems.dmx.core.service.event.PostUpdateTopicListener;
import systems.dmx.core.service.event.PreCreateAssociationTypeListener;
import systems.dmx.core.service.event.PreCreateTopicTypeListener;

@Path(value="/webclient")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class WebclientPlugin
extends PluginActivator
implements AllPluginsActiveListener,
IntroduceTopicTypeListener,
IntroduceAssociationTypeListener,
PreCreateTopicTypeListener,
PreCreateAssociationTypeListener,
PostUpdateTopicListener {
    private static final String VIEW_CONFIG_LABEL = "View Configuration";
    private boolean hasWebclientLaunched = false;
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());

    @GET
    @Path(value="/search")
    @Transactional
    public Topic searchTopics(@QueryParam(value="search") String searchTerm, @QueryParam(value="field") String fieldUri) {
        try {
            this.logger.info("searchTerm=\"" + searchTerm + "\", fieldUri=\"" + fieldUri + "\"");
            List singleTopics = this.dmx.searchTopics(searchTerm, fieldUri);
            Set<Topic> topics = this.findSearchableUnits(singleTopics);
            this.logger.info(singleTopics.size() + " single topics found, " + topics.size() + " searchable units");
            return this.createSearchTopic(searchTerm, topics);
        }
        catch (Exception e) {
            throw new RuntimeException("Searching topics failed", e);
        }
    }

    @GET
    @Path(value="/search/by_type/{type_uri}")
    @Transactional
    public Topic getTopics(@PathParam(value="type_uri") String typeUri) {
        try {
            this.logger.info("typeUri=\"" + typeUri + "\"");
            String searchTerm = this.dmx.getTopicType(typeUri).getSimpleValue() + "(s)";
            List topics = this.dmx.getTopicsByType(typeUri);
            return this.createSearchTopic(searchTerm, topics);
        }
        catch (Exception e) {
            throw new RuntimeException("Searching topics of type \"" + typeUri + "\" failed", e);
        }
    }

    @GET
    @Path(value="/object/{id}/related_topics")
    public List<RelatedTopic> getRelatedTopics(@PathParam(value="id") long objectId) {
        DMXObject object = this.dmx.getObject(objectId);
        List relTopics = object.getRelatedTopics(null);
        Iterator i = relTopics.iterator();
        int removed = 0;
        while (i.hasNext()) {
            RelatedTopic relTopic = (RelatedTopic)i.next();
            if (!this.isDirectModelledChildTopic(object, relTopic)) continue;
            i.remove();
            ++removed;
        }
        this.logger.fine("### " + removed + " topics are removed from result set of object " + objectId);
        return relTopics;
    }

    public void allPluginsActive() {
        String webclientUrl = this.getWebclientUrl();
        if (this.hasWebclientLaunched) {
            this.logger.info("### Launching webclient (url=\"" + webclientUrl + "\") SKIPPED -- already launched");
            return;
        }
        try {
            this.logger.info("### Launching webclient (url=\"" + webclientUrl + "\")");
            Desktop.getDesktop().browse(new URI(webclientUrl));
            this.hasWebclientLaunched = true;
        }
        catch (Exception e) {
            this.logger.warning("### Launching webclient failed (" + e + ")");
            this.logger.warning("### To launch it manually: " + webclientUrl);
        }
    }

    public void preCreateTopicType(TopicTypeModel model) {
        this.addDefaultViewConfig((TypeModel)model);
    }

    public void preCreateAssociationType(AssociationTypeModel model) {
        this.addDefaultViewConfig((TypeModel)model);
    }

    public void postUpdateTopic(Topic topic, TopicModel updateModel, TopicModel oldTopic) {
        if (topic.getTypeUri().equals("dmx.webclient.view_config")) {
            this.updateType(topic);
            this.setConfigTopicLabel(topic);
        }
    }

    public void introduceTopicType(TopicType topicType) {
        this.setViewConfigLabel(topicType.getViewConfig());
    }

    public void introduceAssociationType(AssociationType assocType) {
        this.setViewConfigLabel(assocType.getViewConfig());
    }

    private Set<Topic> findSearchableUnits(List<? extends Topic> topics) {
        LinkedHashSet<Topic> searchableUnits = new LinkedHashSet<Topic>();
        for (Topic topic : topics) {
            if (this.searchableAsUnit(topic)) {
                searchableUnits.add(topic);
                continue;
            }
            List parentTopics = topic.getRelatedTopics((String)null, "dmx.core.child", "dmx.core.parent", null);
            if (parentTopics.isEmpty()) {
                searchableUnits.add(topic);
                continue;
            }
            searchableUnits.addAll(this.findSearchableUnits(parentTopics));
        }
        return searchableUnits;
    }

    private Topic createSearchTopic(final String searchTerm, final Collection<Topic> resultItems) {
        try {
            return (Topic)this.dmx.getAccessControl().runWithoutWorkspaceAssignment((Callable)new Callable<Topic>(){

                @Override
                public Topic call() {
                    Topic searchTopic = WebclientPlugin.this.dmx.createTopic(WebclientPlugin.this.mf.newTopicModel("dmx.webclient.search", WebclientPlugin.this.mf.newChildTopicsModel().put("dmx.webclient.search_term", (Object)searchTerm)));
                    for (Topic resultItem : resultItems) {
                        WebclientPlugin.this.dmx.createAssociation(WebclientPlugin.this.mf.newAssociationModel("dmx.webclient.search_result_item", (RoleModel)WebclientPlugin.this.mf.newTopicRoleModel(searchTopic.getId(), "dmx.core.default"), (RoleModel)WebclientPlugin.this.mf.newTopicRoleModel(resultItem.getId(), "dmx.core.default")));
                    }
                    return searchTopic;
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException("Creating search topic for \"" + searchTerm + "\" failed", e);
        }
    }

    private boolean searchableAsUnit(Topic topic) {
        TopicType topicType = this.dmx.getTopicType(topic.getTypeUri());
        Boolean searchableAsUnit = (Boolean)this.getViewConfigValue(topicType, "searchable_as_unit");
        return searchableAsUnit != null ? searchableAsUnit : false;
    }

    private Object getViewConfigValue(TopicType topicType, String setting) {
        return topicType.getViewConfigValue("dmx.webclient.view_config", "dmx.webclient." + setting);
    }

    private void updateType(Topic viewConfig) {
        RelatedTopic type = viewConfig.getRelatedTopic("dmx.core.aggregation", "dmx.core.view_config", "dmx.core.type", null);
        if (type != null) {
            String typeUri = type.getTypeUri();
            if (typeUri.equals("dmx.core.topic_type") || typeUri.equals("dmx.core.meta_type")) {
                this.updateTopicType((Topic)type, viewConfig);
            } else if (typeUri.equals("dmx.core.assoc_type")) {
                this.updateAssociationType((Topic)type, viewConfig);
            } else {
                throw new RuntimeException("View Configuration " + viewConfig.getId() + " is associated to an unexpected topic (type=" + type + "\nviewConfig=" + viewConfig + ")");
            }
        }
    }

    private void updateTopicType(Topic type, Topic viewConfig) {
        this.logger.info("### Updating view config of topic type \"" + type.getUri() + "\"");
        TopicType topicType = this.dmx.getTopicType(type.getUri());
        this.updateViewConfig((DMXType)topicType, viewConfig);
        Directives.get().add(Directive.UPDATE_TOPIC_TYPE, (JSONEnabled)topicType);
    }

    private void updateAssociationType(Topic type, Topic viewConfig) {
        this.logger.info("### Updating view config of assoc type \"" + type.getUri() + "\"");
        AssociationType assocType = this.dmx.getAssociationType(type.getUri());
        this.updateViewConfig((DMXType)assocType, viewConfig);
        Directives.get().add(Directive.UPDATE_ASSOCIATION_TYPE, (JSONEnabled)assocType);
    }

    private void updateViewConfig(DMXType type, Topic viewConfig) {
        type.getModel().getViewConfig().updateConfigTopic(viewConfig.getModel());
    }

    private void setViewConfigLabel(ViewConfiguration viewConfig) {
        for (Topic configTopic : viewConfig.getConfigTopics()) {
            this.setConfigTopicLabel(configTopic);
        }
    }

    private void setConfigTopicLabel(Topic viewConfig) {
        viewConfig.setSimpleValue(VIEW_CONFIG_LABEL);
    }

    private void addDefaultViewConfig(TypeModel typeModel) {
    }

    private String getWebclientUrl() {
        String port;
        String protocol;
        boolean isHttpsEnabled = Boolean.getBoolean("org.apache.felix.https.enable");
        if (isHttpsEnabled) {
            protocol = "https";
            port = System.getProperty("org.osgi.service.http.port.secure");
        } else {
            protocol = "http";
            port = System.getProperty("org.osgi.service.http.port");
        }
        return protocol + "://localhost:" + port + "/systems.dmx.webclient/";
    }

    private boolean isDirectModelledChildTopic(DMXObject parentObject, RelatedTopic childTopic) {
        if (this.hasAssocDef(parentObject, childTopic)) {
            Association assoc = childTopic.getRelatingAssociation();
            return assoc.matches("dmx.core.parent", parentObject.getId(), "dmx.core.child", childTopic.getId());
        }
        return false;
    }

    private boolean hasAssocDef(DMXObject parentObject, RelatedTopic childTopic) {
        DMXType parentType = parentObject.getType();
        String childTypeUri = childTopic.getTypeUri();
        String assocTypeUri = childTopic.getRelatingAssociation().getTypeUri();
        String assocDefUri = childTypeUri + "#" + assocTypeUri;
        if (parentType.hasAssocDef(assocDefUri)) {
            return true;
        }
        if (parentType.hasAssocDef(childTypeUri)) {
            return parentType.getAssocDef(childTypeUri).getInstanceLevelAssocTypeUri().equals(assocTypeUri);
        }
        return false;
    }
}

