/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.accesscontrol.migrations;

import java.util.List;
import java.util.logging.Logger;
import systems.dmx.accesscontrol.AccessControlService;
import systems.dmx.config.ConfigService;
import systems.dmx.core.DMXObject;
import systems.dmx.core.Topic;
import systems.dmx.core.service.Inject;
import systems.dmx.core.service.Migration;
import systems.dmx.workspaces.WorkspacesService;

public class Migration12
extends Migration {
    @Inject
    private AccessControlService acService;
    @Inject
    private WorkspacesService wsService;
    @Inject
    private ConfigService configService;
    private long administrationWorkspaceId;
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());

    public void run() {
        Topic systemWorkspace = this.wsService.createWorkspace("Administration", "dmx.workspaces.administration", AccessControlService.ADMINISTRATION_WORKSPACE_SHARING_MODE);
        this.acService.setWorkspaceOwner(systemWorkspace, "admin");
        this.administrationWorkspaceId = this.dmx.getAccessControl().getAdministrationWorkspaceId();
        this.assignConfigTopics("dmx.accesscontrol.login_enabled");
        this.assignConfigTopics("dmx.files.disk_quota");
        List usernames = this.dmx.getTopicsByType("dmx.accesscontrol.username");
        this.logger.info("########## Creating config topics of type \"dmx.workspaces.enabled_sharing_modes\" for " + usernames.size() + " usernames");
        for (Topic username : usernames) {
            this.configService.createConfigTopic("dmx.workspaces.enabled_sharing_modes", username);
        }
    }

    private void assignConfigTopics(String configTypeUri) {
        List configTopics = this.dmx.getTopicsByType(configTypeUri);
        this.logger.info("########## Reassigning " + configTopics.size() + " config topics of type \"" + configTypeUri + "\" to workspace \"Administration\"");
        for (Topic configTopic : configTopics) {
            this.wsService.assignToWorkspace((DMXObject)configTopic, this.administrationWorkspaceId);
        }
    }
}

