/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.files.migrations;

import java.util.List;
import java.util.logging.Logger;
import systems.dmx.core.Topic;
import systems.dmx.core.model.SimpleValue;
import systems.dmx.core.service.Migration;

public class Migration4
extends Migration {
    private static final boolean FILE_REPOSITORY_PER_WORKSPACE = Boolean.getBoolean("dmx.filerepo.per_workspace");
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());

    public void run() {
        if (FILE_REPOSITORY_PER_WORKSPACE) {
            List workspaces = this.dmx.getTopicsByType("dmx.workspaces.workspace");
            this.logger.info("########## Renaming root Folder topics of " + workspaces.size() + " possible workspaces");
            int renamed = 0;
            for (Topic workspace : workspaces) {
                Topic folderTopic = this.fetchFolderTopic("/workspace-" + workspace.getId());
                if (folderTopic == null) continue;
                folderTopic.getChildTopics().set("dmx.files.folder_name", (Object)workspace.getSimpleValue().toString());
                ++renamed;
            }
            this.logger.info("########## Root Folder topics renamed: " + renamed);
        } else {
            this.logger.info("########## Renaming root Folder topics SKIPPED -- per-workspace file repositories are switched off");
        }
        this.dmx.getTopicType("dmx.files.disk_quota").setSimpleValue("Disk Quota (MB)");
        this.setTopicTypeViewConfigValue("dmx.files.size", "simple_renderer_uri", "dmx.files.file_size_renderer");
    }

    private Topic fetchFolderTopic(String repoPath) {
        Topic topic = this.dmx.getTopicByValue("dmx.files.path", new SimpleValue(repoPath));
        return topic != null ? topic.getRelatedTopic("dmx.core.composition", "dmx.core.child", "dmx.core.parent", "dmx.files.folder") : null;
    }
}

