/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.accesscontrol.migrations;

import java.util.logging.Logger;
import systems.dmx.core.Association;
import systems.dmx.core.DMXObject;
import systems.dmx.core.Topic;
import systems.dmx.core.service.Migration;

public class Migration2
extends Migration {
    private long count;
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());

    public void run() {
        this.count = 0L;
        for (Topic topic : this.dmx.getAllTopics()) {
            this.migrateObject((DMXObject)topic, "topic");
        }
        this.count = 0L;
        for (Association assoc : this.dmx.getAllAssociations()) {
            this.migrateObject((DMXObject)assoc, "association");
        }
    }

    private void migrateObject(DMXObject object, String type) {
        try {
            ++this.count;
            String info = "### Migrating " + type + " " + object.getId() + " (#" + this.count + ")";
            if (object.hasProperty("creator")) {
                this.logger.info(info);
                this.renameProperty(object, "creator", "dmx.accesscontrol.creator", true);
                this.renameProperty(object, "owner", "dmx.accesscontrol.owner", true);
                this.renameProperty(object, "acl", "dmx.accesscontrol.acl", false);
            } else {
                this.logger.info(info + " SKIPPED -- Access control information not availble");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Migrating " + type + " " + object.getId() + " failed (" + object + ")", e);
        }
    }

    private void renameProperty(DMXObject object, String oldPropUri, String newPropUri, boolean addToIndex) {
        String propValue = (String)object.getProperty(oldPropUri);
        object.setProperty(newPropUri, (Object)propValue, addToIndex);
        object.removeProperty(oldPropUri);
    }
}

