/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.migrations;

import java.util.List;
import java.util.logging.Logger;
import systems.dmx.core.Association;
import systems.dmx.core.ChildTopics;
import systems.dmx.core.RelatedTopic;
import systems.dmx.core.service.Migration;

public class Migration7
extends Migration {
    private int[][] count = new int[2][2];
    private Logger logger = Logger.getLogger(this.getClass().getName());

    @Override
    public void run() {
        this.logger.info("########## Repairing assoc defs with missing \"Include in Label\" topic");
        this.dmx.getAssociationType("dmx.core.aggregation_def").getAssocDef("dmx.core.assoc_type#dmx.core.custom_assoc_type").getChildTopics().set("dmx.core.include_in_label", false);
        this.dmx.getAssociationType("dmx.core.composition_def").getAssocDef("dmx.core.assoc_type#dmx.core.custom_assoc_type").getChildTopics().set("dmx.core.include_in_label", false);
        this.process(this.dmx.getAssociationsByType("dmx.core.composition_def"), 0);
        this.process(this.dmx.getAssociationsByType("dmx.core.aggregation_def"), 1);
        this.logger.info("########## Repairing assoc defs with missing \"Include in Label\" topic complete\n    Composition defs repaired: " + this.count[0][1] + "/" + this.count[0][0] + "\n    Aggregation defs repaired: " + this.count[1][1] + "/" + this.count[1][0]);
    }

    private void process(List<Association> assocs, int i) {
        for (Association assoc : assocs) {
            ChildTopics childs = assoc.getChildTopics();
            RelatedTopic includeInLabel = childs.getTopicOrNull("dmx.core.include_in_label");
            if (includeInLabel == null) {
                childs.set("dmx.core.include_in_label", false);
                int[] nArray = this.count[i];
                nArray[1] = nArray[1] + 1;
            }
            int[] nArray = this.count[i];
            nArray[0] = nArray[0] + 1;
        }
    }
}

