/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.caching;

import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerResponse;
import java.util.Date;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Path;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import systems.dmx.core.DMXObject;
import systems.dmx.core.osgi.PluginActivator;
import systems.dmx.core.service.Inject;
import systems.dmx.core.service.event.ServiceRequestFilterListener;
import systems.dmx.core.service.event.ServiceResponseFilterListener;
import systems.dmx.core.util.JavaUtils;
import systems.dmx.time.TimeService;

@Path(value="/cache")
public class CachingPlugin
extends PluginActivator
implements ServiceRequestFilterListener,
ServiceResponseFilterListener {
    private static String CACHABLE_PATH = "core/(topic|association)/(\\d+)";
    private static String HEADER_CACHE_CONTROL = "Cache-Control";
    @Inject
    private TimeService timeService;
    @Context
    HttpServletRequest req;
    private Pattern cachablePath = Pattern.compile(CACHABLE_PATH);
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());

    public void serviceRequestFilter(ContainerRequest request) {
        long objectId = this.requestObjectId(request);
        if (objectId != -1L) {
            if (this.timeService == null) {
                throw new RuntimeException("Time service is not available");
            }
            long time = this.timeService.getModificationTime(objectId);
            Response.ResponseBuilder builder = request.evaluatePreconditions(new Date(time));
            if (builder != null) {
                Response response = builder.build();
                Response.Status status = Response.Status.fromStatusCode((int)response.getStatus());
                this.logger.fine("### Preconditions of request \"" + JavaUtils.requestInfo((HttpServletRequest)this.req) + "\" are not met -- Responding with " + JavaUtils.responseInfo((Response.StatusType)status));
                throw new WebApplicationException(response);
            }
        }
    }

    public void serviceResponseFilter(ContainerResponse response) {
        DMXObject object = this.responseObject(response);
        if (object != null) {
            this.setCacheControlHeader(response, "max-age=0");
        }
    }

    private long requestObjectId(ContainerRequest request) {
        Matcher m = this.cachablePath.matcher(request.getPath());
        if (m.matches()) {
            long objectId = Long.parseLong(m.group(2));
            String objectType = m.group(1);
            if (!objectType.equals("topic") && !objectType.equals("association")) {
                throw new RuntimeException("Unexpected object type: \"" + objectType + "\"");
            }
            return objectId;
        }
        return -1L;
    }

    private DMXObject responseObject(ContainerResponse response) {
        Object entity = response.getEntity();
        return entity instanceof DMXObject ? (DMXObject)entity : null;
    }

    private void setCacheControlHeader(ContainerResponse response, String value) {
        this.setHeader(response, HEADER_CACHE_CONTROL, value);
    }

    private void setHeader(ContainerResponse response, String header, String value) {
        MultivaluedMap headers = response.getHttpHeaders();
        if (headers.containsKey((Object)header)) {
            throw new RuntimeException("Response already has a \"" + header + "\" header");
        }
        headers.putSingle((Object)header, (Object)value);
    }
}

