/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.workspaces.migrations;

import java.util.logging.Logger;
import systems.dmx.core.Association;
import systems.dmx.core.DMXObject;
import systems.dmx.core.Topic;
import systems.dmx.core.service.Inject;
import systems.dmx.core.service.Migration;
import systems.dmx.facets.FacetsService;
import systems.dmx.workspaces.WorkspacesService;

public class Migration9
extends Migration {
    @Inject
    private WorkspacesService workspacesService;
    @Inject
    private FacetsService facetsService;
    private long topicContext = 0L;
    private long assocContext = 0L;
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());

    public void run() {
        this.logger.info("########## Deleting workspace assignments of \"Mapcontext\" associations");
        for (Association assoc : this.dmx.getAssociationsByType("dmx.topicmaps.topic_mapcontext")) {
            this.deleteWorkspaceAssignment(assoc);
            ++this.topicContext;
        }
        for (Association assoc : this.dmx.getAssociationsByType("dmx.topicmaps.association_mapcontext")) {
            this.deleteWorkspaceAssignment(assoc);
            ++this.assocContext;
        }
        this.logger.info("########## Deleting workspace assignments of \"Mapcontext\" associations complete\n    \"Topic Mapcontext\" associations processed: " + this.topicContext + "\n    \"Association Mapcontext\" associations processed: " + this.assocContext);
    }

    private void deleteWorkspaceAssignment(Association assoc) {
        Topic workspace = this.workspacesService.getAssignedWorkspace(assoc.getId());
        if (workspace != null) {
            this.facetsService.updateFacet((DMXObject)assoc, "dmx.workspaces.workspace_facet", this.mf.newFacetValueModel("dmx.workspaces.workspace").putDeletionRef(workspace.getId()));
            assoc.removeProperty("dmx.workspaces.workspace_id");
        }
    }
}

