/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.accesscontrol.migrations;

import java.util.List;
import java.util.logging.Logger;
import systems.dmx.accesscontrol.AccessControlService;
import systems.dmx.core.ChildTopics;
import systems.dmx.core.DMXObject;
import systems.dmx.core.RelatedTopic;
import systems.dmx.core.Topic;
import systems.dmx.core.service.Inject;
import systems.dmx.core.service.Migration;
import systems.dmx.core.service.accesscontrol.SharingMode;
import systems.dmx.workspaces.WorkspacesService;

public class Migration8
extends Migration {
    @Inject
    private AccessControlService acService;
    @Inject
    private WorkspacesService wsService;
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());

    public void run() {
        List userAccounts = this.dmx.getTopicsByType("dmx.accesscontrol.user_account");
        this.logger.info("########## Converting " + userAccounts.size() + " user accounts");
        for (Topic userAccount : userAccounts) {
            ChildTopics childTopics = userAccount.getChildTopics();
            RelatedTopic usernameTopic = childTopics.getTopic("dmx.accesscontrol.username");
            RelatedTopic passwordTopic = childTopics.getTopic("dmx.accesscontrol.password");
            Topic privateWorkspace = this.wsService.createWorkspace("Private Workspace", null, SharingMode.PRIVATE);
            String username = usernameTopic.getSimpleValue().toString();
            this.acService.setWorkspaceOwner(privateWorkspace, username);
            long privateWorkspaceId = privateWorkspace.getId();
            this.wsService.assignToWorkspace((DMXObject)userAccount, privateWorkspaceId);
            this.wsService.assignToWorkspace((DMXObject)passwordTopic, privateWorkspaceId);
            this.createMemberships((Topic)usernameTopic);
            Topic systemWorkspace = this.wsService.getWorkspace("dmx.workspaces.system");
            this.wsService.assignToWorkspace((DMXObject)usernameTopic, systemWorkspace.getId());
        }
    }

    private void createMemberships(Topic usernameTopic) {
        String username = usernameTopic.getSimpleValue().toString();
        List workspaces = usernameTopic.getRelatedTopics("dmx.core.aggregation", "dmx.core.parent", "dmx.core.child", "dmx.workspaces.workspace");
        this.logger.info("######## User \"" + username + "\" is member of " + workspaces.size() + " workspaces");
        for (RelatedTopic workspace : workspaces) {
            long workspaceId = workspace.getId();
            String owner = this.acService.getWorkspaceOwner(workspaceId);
            boolean isOwner = username.equals(owner);
            this.logger.info("##### Workspace \"" + workspace.getSimpleValue() + "\" (id=" + workspace.getId() + "), owner: " + owner + " -> create " + (isOwner ? "NO " : "") + "Membership");
            if (!isOwner) {
                this.acService.createMembership(username, workspaceId);
            }
            workspace.getRelatingAssociation().delete();
        }
    }
}

