/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.workspaces.migrations;

import java.util.List;
import java.util.logging.Logger;
import systems.dmx.core.Association;
import systems.dmx.core.DMXObject;
import systems.dmx.core.RelatedTopic;
import systems.dmx.core.Topic;
import systems.dmx.core.service.Migration;

public class Migration5
extends Migration {
    private static final String PROP_WORKSPACE_ID = "dmx.workspaces.workspace_id";
    private long objects = 0L;
    private long initialized = 0L;
    private long ambiguous = 0L;
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());

    public void run() {
        this.logger.info("########## Initializing workspace properties");
        for (Topic topic : this.dmx.getAllTopics()) {
            this.initWorkspaceProperty((DMXObject)topic);
        }
        for (Association assoc : this.dmx.getAllAssociations()) {
            this.initWorkspaceProperty((DMXObject)assoc);
        }
        this.logger.info("########## Initializing workspace properties complete\n    Objects processed: " + this.objects + "\n    initialized: " + this.initialized + "\n    ambiguous: " + this.ambiguous);
        this.dmx.getTopicType("dmx.workspaces.workspace_facet").getAssocDef("dmx.workspaces.workspace").setChildCardinalityUri("dmx.core.one");
        this.dmx.getTopicByUri("de.workspaces.deepamehta").setUri("dmx.workspaces.deepamehta");
        for (Topic workspace : this.dmx.getTopicsByType("dmx.workspaces.workspace")) {
            workspace.update(this.mf.newTopicModel(this.mf.newChildTopicsModel().putRef("dmx.workspaces.sharing_mode", "dmx.workspaces.public")));
        }
    }

    private void initWorkspaceProperty(DMXObject object) {
        List workspaces = object.getRelatedTopics("dmx.core.aggregation", "dmx.core.parent", "dmx.core.child", "dmx.workspaces.workspace");
        ++this.objects;
        switch (workspaces.size()) {
            case 0: {
                break;
            }
            case 1: {
                long workspaceId = ((RelatedTopic)workspaces.get(0)).getId();
                object.setProperty(PROP_WORKSPACE_ID, (Object)workspaceId, false);
                ++this.initialized;
                break;
            }
            default: {
                if (this.isUserAccountRelated(object)) break;
                this.logger.warning("##### " + this.info(object) + " has ambiguous workspace assignments (" + workspaces.size() + ") -- This object will get NO workspace assignment in DM 4.5 and will not be editable anymore");
                ++this.ambiguous;
            }
        }
    }

    private boolean isUserAccountRelated(DMXObject object) {
        String typeUri = object.getTypeUri();
        return typeUri.equals("dmx.accesscontrol.user_account") || typeUri.equals("dmx.accesscontrol.username") || typeUri.equals("dmx.accesscontrol.password");
    }

    private String info(DMXObject object) {
        if (object instanceof Topic) {
            return "topic " + object.getId() + " (typeUri=\"" + object.getTypeUri() + "\", value=\"" + object.getSimpleValue() + "\", uri=\"" + object.getUri() + "\")";
        }
        if (object instanceof Association) {
            return "association " + object.getId() + " (typeUri=\"" + object.getTypeUri() + "\")";
        }
        throw new RuntimeException("Unexpected object: " + object);
    }
}

