/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.topicmaps.migrations;

import java.util.logging.Logger;
import systems.dmx.core.Association;
import systems.dmx.core.ChildTopics;
import systems.dmx.core.Topic;
import systems.dmx.core.service.Migration;

public class Migration4
extends Migration {
    private long assocs = 0L;
    private long topicsDeleted = 0L;
    private long typesDeleted = 0L;
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());

    public void run() {
        this.logger.info("########## Converting \"Topic Mapcontext\" associations");
        for (Association assoc : this.dmx.getAssociationsByType("dmx.topicmaps.topic_mapcontext")) {
            this.migrateMapcontextAssociation(assoc);
        }
        this.deleteTopicType("dmx.topicmaps.x");
        this.deleteTopicType("dmx.topicmaps.y");
        this.deleteTopicType("dmx.topicmaps.visibility");
        this.dmx.getAssociationType("dmx.topicmaps.topic_mapcontext").setDataTypeUri("dmx.core.text");
        this.logger.info("########## Converting \"Topic Mapcontext\" associations complete\n    Associations processed: " + this.assocs + "\n    X, Y, Visibility topics deleted: " + this.topicsDeleted + "\n    Topic types deleted: " + this.typesDeleted);
    }

    private void migrateMapcontextAssociation(Association assoc) {
        ++this.assocs;
        ChildTopics childs = assoc.getChildTopics();
        int x = childs.getInt("dmx.topicmaps.x");
        int y = childs.getInt("dmx.topicmaps.y");
        boolean visibility = childs.getBoolean("dmx.topicmaps.visibility");
        assoc.setProperty("dmx.topicmaps.x", (Object)x, false);
        assoc.setProperty("dmx.topicmaps.y", (Object)y, false);
        assoc.setProperty("dmx.topicmaps.visibility", (Object)visibility, false);
    }

    private void deleteTopicType(String topicTypeUri) {
        ++this.typesDeleted;
        for (Topic topic : this.dmx.getTopicsByType(topicTypeUri)) {
            topic.delete();
            ++this.topicsDeleted;
        }
        this.dmx.deleteTopicType(topicTypeUri);
    }
}

