/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.contacts.migrations;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import systems.dmx.core.RelatedTopic;
import systems.dmx.core.Topic;
import systems.dmx.core.service.Migration;

public class Migration2
extends Migration {
    private List<Entry> phoneEntries = new ArrayList<Entry>();
    private List<Entry> addressEntries = new ArrayList<Entry>();
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());

    public void run() {
        this.logger.info("########## Converting Phone Entry and Address Entry topics");
        this.bufferContentAndDeleteTypes();
        this.dmx.createAssociationType(this.mf.newAssociationTypeModel("dmx.contacts.phone_entry", "Phone Entry", "dmx.core.identity").addAssocDef(this.mf.newAssociationDefinitionModel("dmx.core.aggregation_def", "dmx.contacts.phone_entry", "dmx.contacts.phone_label", "dmx.core.many", "dmx.core.one")));
        this.dmx.createAssociationType(this.mf.newAssociationTypeModel("dmx.contacts.address_entry", "Address Entry", "dmx.core.identity").addAssocDef(this.mf.newAssociationDefinitionModel("dmx.core.aggregation_def", "dmx.contacts.address_entry", "dmx.contacts.address_label", "dmx.core.many", "dmx.core.one")));
        this.dmx.getTopicType("dmx.contacts.person").addAssocDefBefore(this.mf.newAssociationDefinitionModel("dmx.core.composition_def", "dmx.contacts.phone_entry", false, false, "dmx.contacts.person", "dmx.contacts.phone_number", "dmx.core.one", "dmx.core.many"), "dmx.contacts.email_address").addAssocDefBefore(this.mf.newAssociationDefinitionModel("dmx.core.composition_def", "dmx.contacts.address_entry", false, false, "dmx.contacts.person", "dmx.contacts.address", "dmx.core.one", "dmx.core.many"), "dmx.contacts.notes");
        this.dmx.getTopicType("dmx.contacts.institution").addAssocDefBefore(this.mf.newAssociationDefinitionModel("dmx.core.composition_def", "dmx.contacts.phone_entry", false, false, "dmx.contacts.institution", "dmx.contacts.phone_number", "dmx.core.one", "dmx.core.many"), "dmx.contacts.email_address").addAssocDefBefore(this.mf.newAssociationDefinitionModel("dmx.core.composition_def", "dmx.contacts.address_entry", false, false, "dmx.contacts.institution", "dmx.contacts.address", "dmx.core.one", "dmx.core.many"), "dmx.contacts.notes");
        for (Entry entry : this.phoneEntries) {
            this.convertPhoneEntry(entry);
        }
        for (Entry entry : this.addressEntries) {
            this.convertAddressEntry(entry);
        }
        this.logger.info("########## Converting Phone Entry and Address Entry topics complete\n    Phone entries converted: " + this.phoneEntries.size() + "\n    Address entries converted: " + this.addressEntries.size());
    }

    private void bufferContentAndDeleteTypes() {
        for (Topic phoneEntry : this.dmx.getTopicsByType("dmx.contacts.phone_entry")) {
            this.bufferPhoneEntry(phoneEntry);
        }
        for (Topic addressEntry : this.dmx.getTopicsByType("dmx.contacts.address_entry")) {
            this.bufferAddressEntry(addressEntry);
        }
        this.dmx.getTopicType("dmx.contacts.phone_entry").getAssocDef("dmx.contacts.phone_number").setTypeUri("dmx.core.aggregation_def");
        this.dmx.getTopicType("dmx.contacts.address_entry").getAssocDef("dmx.contacts.address").setTypeUri("dmx.core.aggregation_def");
        for (Entry entry : this.phoneEntries) {
            entry.topic.delete();
        }
        for (Entry entry : this.addressEntries) {
            entry.topic.delete();
        }
        this.dmx.deleteTopicType("dmx.contacts.phone_entry");
        this.dmx.deleteTopicType("dmx.contacts.address_entry");
    }

    private void bufferPhoneEntry(Topic phoneEntry) {
        RelatedTopic parent = phoneEntry.getRelatedTopic("dmx.core.composition", "dmx.core.child", "dmx.core.parent", null);
        RelatedTopic phoneLabel = phoneEntry.getChildTopics().getTopic("dmx.contacts.phone_label");
        RelatedTopic phoneNumber = phoneEntry.getChildTopics().getTopic("dmx.contacts.phone_number");
        this.phoneEntries.add(new Entry(phoneEntry, (Topic)parent, phoneLabel.getId(), phoneNumber.getId()));
    }

    private void bufferAddressEntry(Topic addressEntry) {
        RelatedTopic parent = addressEntry.getRelatedTopic("dmx.core.composition", "dmx.core.child", "dmx.core.parent", null);
        RelatedTopic addressLabel = addressEntry.getChildTopics().getTopic("dmx.contacts.address_label");
        RelatedTopic address = addressEntry.getChildTopics().getTopic("dmx.contacts.address");
        this.addressEntries.add(new Entry(addressEntry, (Topic)parent, addressLabel.getId(), address.getId()));
    }

    private void convertPhoneEntry(Entry entry) {
        entry.parent.getChildTopics().addRef("dmx.contacts.phone_number", entry.objectId, this.mf.newChildTopicsModel().putRef("dmx.contacts.phone_label", entry.labelId));
    }

    private void convertAddressEntry(Entry entry) {
        entry.parent.getChildTopics().addRef("dmx.contacts.address", entry.objectId, this.mf.newChildTopicsModel().putRef("dmx.contacts.address_label", entry.labelId));
    }

    private class Entry {
        private Topic topic;
        private Topic parent;
        private long labelId;
        private long objectId;

        private Entry(Topic topic, Topic parent, long labelId, long objectId) {
            this.topic = topic;
            this.parent = parent;
            this.labelId = labelId;
            this.objectId = objectId;
        }
    }
}

