/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.model;

import java.util.ArrayList;
import java.util.List;
import systems.dmx.core.model.RelatedTopicModel;
import systems.dmx.core.model.TopicModel;

public enum IndexMode {
    OFF,
    KEY,
    FULLTEXT,
    FULLTEXT_KEY;

    private static final String INDEX_MODES_NAMESPACE = "dmx.core.";

    public static List<IndexMode> fromTopics(List<? extends RelatedTopicModel> topics) {
        ArrayList<IndexMode> indexModes = new ArrayList<IndexMode>();
        for (TopicModel topicModel : topics) {
            indexModes.add(IndexMode.fromUri(topicModel.getUri()));
        }
        return indexModes;
    }

    public static IndexMode fromUri(String uri) {
        if (!uri.startsWith(INDEX_MODES_NAMESPACE)) {
            throw new RuntimeException("\"" + uri + "\" is not a valid index mode URI");
        }
        String name = uri.substring(INDEX_MODES_NAMESPACE.length()).toUpperCase();
        return IndexMode.valueOf(name);
    }

    public String toUri() {
        return INDEX_MODES_NAMESPACE + this.name().toLowerCase();
    }
}

