/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.impl;

import java.util.logging.Logger;
import org.codehaus.jettison.json.JSONObject;
import systems.dmx.core.impl.AssociationDefinitionImpl;
import systems.dmx.core.impl.AssociationModelImpl;
import systems.dmx.core.impl.RelatedTopicModelImpl;
import systems.dmx.core.impl.TopicModelImpl;
import systems.dmx.core.impl.ViewConfigurationModelImpl;
import systems.dmx.core.model.AssociationDefinitionModel;
import systems.dmx.core.model.ChildTopicsModel;
import systems.dmx.core.model.DMXObjectModel;
import systems.dmx.core.model.TopicRoleModel;
import systems.dmx.core.model.ViewConfigurationModel;

class AssociationDefinitionModelImpl
extends AssociationModelImpl
implements AssociationDefinitionModel {
    private String parentCardinalityUri;
    private String childCardinalityUri;
    private ViewConfigurationModelImpl viewConfig;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    AssociationDefinitionModelImpl(AssociationModelImpl assoc) {
        this(assoc, null, null, null);
    }

    AssociationDefinitionModelImpl(AssociationModelImpl assoc, String parentCardinalityUri, String childCardinalityUri, ViewConfigurationModelImpl viewConfig) {
        super(assoc);
        this.parentCardinalityUri = parentCardinalityUri;
        this.childCardinalityUri = childCardinalityUri;
        this.viewConfig = viewConfig != null ? viewConfig : this.mf.newViewConfigurationModel();
    }

    @Override
    public String getAssocDefUri() {
        String customAssocTypeUri = this.getCustomAssocTypeUri();
        return this.getChildTypeUri() + (customAssocTypeUri != null ? "#" + customAssocTypeUri : "");
    }

    @Override
    public String getCustomAssocTypeUri() {
        TopicModelImpl customAssocType = this.getCustomAssocType();
        return customAssocType != null ? customAssocType.getUri() : null;
    }

    @Override
    public String getInstanceLevelAssocTypeUri() {
        String customAssocTypeUri = this.getCustomAssocTypeUri();
        return customAssocTypeUri != null ? customAssocTypeUri : this.defaultInstanceLevelAssocTypeUri();
    }

    @Override
    public String getParentTypeUri() {
        return ((TopicRoleModel)((Object)this.getRoleModel("dmx.core.parent_type"))).getTopicUri();
    }

    @Override
    public String getChildTypeUri() {
        return ((TopicRoleModel)((Object)this.getRoleModel("dmx.core.child_type"))).getTopicUri();
    }

    @Override
    public String getParentCardinalityUri() {
        return this.parentCardinalityUri;
    }

    @Override
    public String getChildCardinalityUri() {
        return this.childCardinalityUri;
    }

    @Override
    public ViewConfigurationModelImpl getViewConfig() {
        return this.viewConfig;
    }

    @Override
    public void setParentCardinalityUri(String parentCardinalityUri) {
        this.parentCardinalityUri = parentCardinalityUri;
    }

    @Override
    public void setChildCardinalityUri(String childCardinalityUri) {
        this.childCardinalityUri = childCardinalityUri;
    }

    @Override
    public void setViewConfig(ViewConfigurationModel viewConfig) {
        this.viewConfig = (ViewConfigurationModelImpl)viewConfig;
    }

    @Override
    public JSONObject toJSON() {
        try {
            return super.toJSON().put("parentCardinalityUri", (Object)this.parentCardinalityUri).put("childCardinalityUri", (Object)this.childCardinalityUri).put("viewConfigTopics", (Object)this.viewConfig.toJSONArray());
        }
        catch (Exception e) {
            throw new RuntimeException("Serialization failed", e);
        }
    }

    @Override
    String className() {
        return "association definition";
    }

    @Override
    AssociationDefinitionImpl instantiate() {
        return new AssociationDefinitionImpl(this, this.pl);
    }

    @Override
    AssociationDefinitionModelImpl createModelWithChildTopics(ChildTopicsModel childTopics) {
        return this.mf.newAssociationDefinitionModel(this.typeUri, childTopics);
    }

    @Override
    void postUpdate(DMXObjectModel updateModel, DMXObjectModel oldObject) {
        super.postUpdate(updateModel, oldObject);
        this.updateCardinality((AssociationDefinitionModel)updateModel);
    }

    void updateParentCardinalityUri(String parentCardinalityUri) {
        this.setParentCardinalityUri(parentCardinalityUri);
        this.pl.typeStorage.storeParentCardinalityUri(this.id, parentCardinalityUri);
    }

    void updateChildCardinalityUri(String childCardinalityUri) {
        this.setChildCardinalityUri(childCardinalityUri);
        this.pl.typeStorage.storeChildCardinalityUri(this.id, childCardinalityUri);
    }

    final boolean isIdentityAttr() {
        RelatedTopicModelImpl isIdentityAttr = this.getChildTopicsModel().getTopicOrNull("dmx.core.identity_attr");
        if (isIdentityAttr == null) {
            return false;
        }
        return isIdentityAttr.getSimpleValue().booleanValue();
    }

    final boolean includeInLabel() {
        RelatedTopicModelImpl includeInLabel = this.getChildTopicsModel().getTopicOrNull("dmx.core.include_in_label");
        if (includeInLabel == null) {
            return false;
        }
        return includeInLabel.getSimpleValue().booleanValue();
    }

    boolean isReadable() {
        try {
            if (!this.pl.hasReadAccess(this)) {
                this.logger.info("### Assoc def \"" + this.getAssocDefUri() + "\" not READable");
                return false;
            }
            TopicModelImpl assocType = this.getCustomAssocType();
            if (assocType != null && !this.pl.hasReadAccess(assocType)) {
                this.logger.info("### Assoc def \"" + this.getAssocDefUri() + "\" not READable (custom assoc type not READable)");
                return false;
            }
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException("Checking assoc def READability failed (" + this + ")", e);
        }
    }

    private void updateCardinality(AssociationDefinitionModel newAssocDef) {
        this.updateParentCardinality(newAssocDef.getParentCardinalityUri());
        this.updateChildCardinality(newAssocDef.getChildCardinalityUri());
    }

    private void updateParentCardinality(String newParentCardinalityUri) {
        if (newParentCardinalityUri == null) {
            return;
        }
        String parentCardinalityUri = this.getParentCardinalityUri();
        if (!parentCardinalityUri.equals(newParentCardinalityUri)) {
            this.logger.info("### Changing parent cardinality URI: \"" + parentCardinalityUri + "\" -> \"" + newParentCardinalityUri + "\"");
            this.updateParentCardinalityUri(newParentCardinalityUri);
        }
    }

    private void updateChildCardinality(String newChildCardinalityUri) {
        if (newChildCardinalityUri == null) {
            return;
        }
        String childCardinalityUri = this.getChildCardinalityUri();
        if (!childCardinalityUri.equals(newChildCardinalityUri)) {
            this.logger.info("### Changing child cardinality URI: \"" + childCardinalityUri + "\" -> \"" + newChildCardinalityUri + "\"");
            this.updateChildCardinalityUri(newChildCardinalityUri);
        }
    }

    private TopicModelImpl getCustomAssocType() {
        return this.getChildTopicsModel().getTopicOrNull("dmx.core.assoc_type#dmx.core.custom_assoc_type");
    }

    private String defaultInstanceLevelAssocTypeUri() {
        if (this.typeUri.equals("dmx.core.composition_def")) {
            return "dmx.core.composition";
        }
        throw new RuntimeException("Unexpected association type URI: \"" + this.typeUri + "\"");
    }
}

