/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.contacts;

import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import systems.dmx.contacts.ContactsService;
import systems.dmx.core.RelatedTopic;
import systems.dmx.core.model.AssociationModel;
import systems.dmx.core.osgi.PluginActivator;
import systems.dmx.core.service.event.PreCreateAssociationListener;
import systems.dmx.core.util.DMXUtils;
import systems.dmx.core.util.PropertyUtils;

@Path(value="/contact")
@Produces(value={"application/json"})
public class ContactsPlugin
extends PluginActivator
implements ContactsService,
PreCreateAssociationListener {
    @Override
    @GET
    @Path(value="/{id}/institutions")
    public List<RelatedTopic> getInstitutions(@PathParam(value="id") long personId) {
        return this.dmx.getTopic(personId).getRelatedTopics("dmx.contacts.organization_association", "dmx.core.default", "dmx.core.default", "dmx.contacts.institution");
    }

    @Override
    @GET
    @Path(value="/{id}/persons")
    public List<RelatedTopic> getPersons(@PathParam(value="id") long instId) {
        return this.dmx.getTopic(instId).getRelatedTopics("dmx.contacts.organization_association", "dmx.core.default", "dmx.core.default", "dmx.contacts.person");
    }

    public void preCreateAssociation(AssociationModel assoc) {
        DMXUtils.associationAutoTyping((AssociationModel)assoc, (String)"dmx.contacts.person", (String)"dmx.contacts.institution", (String)"dmx.contacts.organization_association", (String)"dmx.core.default", (String)"dmx.core.default", (PropertyUtils)this.dmx);
    }
}

