/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import systems.dmx.core.impl.AssociationModelImpl;
import systems.dmx.core.impl.ChildTopicsModelImpl;
import systems.dmx.core.impl.DMXObjectModelImpl;
import systems.dmx.core.impl.LabelCalculation;
import systems.dmx.core.impl.ModelFactoryImpl;
import systems.dmx.core.impl.PersistenceLayer;
import systems.dmx.core.impl.RelatedTopicModelImpl;
import systems.dmx.core.impl.TopicImpl;
import systems.dmx.core.impl.TopicModelImpl;
import systems.dmx.core.impl.TopicReferenceModelImpl;
import systems.dmx.core.impl.TypeModelImpl;
import systems.dmx.core.model.AssociationDefinitionModel;
import systems.dmx.core.model.AssociationModel;
import systems.dmx.core.model.DMXObjectModel;
import systems.dmx.core.model.SimpleValue;
import systems.dmx.core.model.TopicDeletionModel;
import systems.dmx.core.model.TopicModel;
import systems.dmx.core.model.TopicReferenceModel;
import systems.dmx.core.model.TypeModel;
import systems.dmx.core.util.DMXUtils;

class ValueIntegrator {
    private DMXObjectModelImpl newValues;
    private DMXObjectModelImpl targetObject;
    private AssociationDefinitionModel assocDef;
    private TypeModelImpl type;
    private boolean isAssoc;
    private boolean isType;
    private boolean isFacetUpdate;
    private List<String> emptyValues = new ArrayList<String>();
    private PersistenceLayer pl;
    private ModelFactoryImpl mf;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    ValueIntegrator(PersistenceLayer pl) {
        this.pl = pl;
        this.mf = pl.mf;
    }

    <M extends DMXObjectModelImpl> UnifiedValue<M> integrate(M newValues, M targetObject, AssociationDefinitionModel assocDef) {
        try {
            this.newValues = newValues;
            this.targetObject = targetObject;
            this.assocDef = assocDef;
            this.isAssoc = newValues instanceof AssociationModel;
            this.isType = newValues instanceof TypeModel;
            boolean bl = this.isFacetUpdate = assocDef != null;
            if (newValues instanceof TopicReferenceModel) {
                return this.unifyRef();
            }
            if (newValues instanceof TopicDeletionModel) {
                return new UnifiedValue(this, null);
            }
            if (newValues.getTypeUri() == null) {
                throw new IllegalArgumentException("Tried to integrate values whose typeUri is not set, newValues=" + newValues + ", targetObject=" + targetObject);
            }
            this.type = newValues.getType();
            DMXObjectModelImpl _value = !this.isFacetUpdate && newValues.isSimple() ? this.integrateSimple() : this.integrateComposite();
            UnifiedValue value = new UnifiedValue(this, _value);
            this.idTransfer(_value);
            return value;
        }
        catch (Exception e) {
            throw new RuntimeException("Value integration failed, newValues=" + newValues + ", targetObject=" + targetObject + ", assocDef=" + assocDef, e);
        }
    }

    private UnifiedValue unifyRef() {
        TopicReferenceModelImpl ref = (TopicReferenceModelImpl)this.newValues;
        if (!ref.isEmptyRef()) {
            TopicModelImpl object = ref.resolve();
            this.logger.fine("Referencing " + object);
            return new UnifiedValue(this, object);
        }
        return new UnifiedValue(this, null);
    }

    private void idTransfer(DMXObjectModelImpl value) {
        if (value != null) {
            if (value.id == -1L) {
                throw new RuntimeException("ID of unification result is not initialized: " + value);
            }
            this.newValues.id = value.id;
        }
    }

    private DMXObjectModelImpl integrateSimple() {
        if (this.isAssoc || this.isType) {
            return this.storeAssocSimpleValue();
        }
        if (this.newValues.getSimpleValue().toString().isEmpty()) {
            return null;
        }
        return this.unifySimple();
    }

    private DMXObjectModelImpl storeAssocSimpleValue() {
        if (this.targetObject != null) {
            this.targetObject._updateSimpleValue(this.newValues.getSimpleValue());
            return this.targetObject;
        }
        this.newValues.storeSimpleValue();
        return this.newValues;
    }

    private TopicModelImpl unifySimple() {
        TopicModelImpl topic;
        SimpleValue newValue = this.newValues.getSimpleValue();
        TopicImpl _topic = this.pl.getTopicByValue(this.type.getUri(), newValue);
        TopicModelImpl topicModelImpl = topic = _topic != null ? _topic.getModel() : null;
        if (topic != null) {
            this.logger.fine("Reusing simple value " + topic.id + " \"" + newValue + "\" (typeUri=\"" + this.type.uri + "\")");
        } else {
            topic = this.createSimpleTopic();
            this.logger.fine("### Creating simple value " + topic.id + " \"" + newValue + "\" (typeUri=\"" + this.type.uri + "\")");
        }
        return topic;
    }

    private DMXObjectModelImpl integrateComposite() {
        HashMap<String, Object> childTopics = new HashMap<String, Object>();
        ChildTopicsModelImpl _childTopics = this.newValues.getChildTopicsModel();
        for (String assocDefUri : this.assocDefUris()) {
            Object newChildValue = this.isOne(assocDefUri) ? _childTopics.getTopicOrNull(assocDefUri) : _childTopics.getTopicsOrNull(assocDefUri);
            if (newChildValue == null) continue;
            Object childTopic = this.integrateChildValue(newChildValue, assocDefUri);
            if (this.isOne(assocDefUri) && ((UnifiedValue)childTopic).value == null) {
                this.emptyValues.add(assocDefUri);
                continue;
            }
            childTopics.put(assocDefUri, childTopic);
        }
        DMXObjectModelImpl value = this.unifyComposite(childTopics);
        if (!this.isFacetUpdate) {
            if (value != null) {
                new LabelCalculation(value).calculate();
            } else if (this.isAssoc) {
                this.storeAssocSimpleValue();
            }
        }
        return value;
    }

    private Iterable<String> assocDefUris() {
        return this.isFacetUpdate ? Arrays.asList(this.assocDef.getAssocDefUri()) : this.type;
    }

    private Object integrateChildValue(Object childValue, String assocDefUri) {
        if (this.isOne(assocDefUri)) {
            return new ValueIntegrator(this.pl).integrate((RelatedTopicModelImpl)childValue, null, null);
        }
        ArrayList<UnifiedValue<Object>> values = new ArrayList<UnifiedValue<Object>>();
        for (RelatedTopicModelImpl value : (List)childValue) {
            values.add(new ValueIntegrator(this.pl).integrate(value, null, null));
        }
        return values;
    }

    private DMXObjectModelImpl unifyComposite(Map<String, Object> childTopics) {
        if (!this.isFacetUpdate && this.isValueType()) {
            return !childTopics.isEmpty() ? this.unifyChildTopics(childTopics, this.type) : null;
        }
        return this.updateAssignments(this.identifyParent(childTopics), childTopics);
    }

    private DMXObjectModelImpl identifyParent(Map<String, Object> childTopics) {
        if (this.targetObject != null) {
            return this.targetObject;
        }
        if (this.isAssoc) {
            if (this.newValues.id == -1L) {
                throw new RuntimeException("newValues has no ID set");
            }
            AssociationModelImpl _newValues = (AssociationModelImpl)this.newValues;
            return this.mf.newAssociationModel(this.newValues.id, this.newValues.uri, this.newValues.typeUri, _newValues.roleModel1, _newValues.roleModel2);
        }
        List<String> identityAssocDefUris = this.type.getIdentityAttrs();
        if (identityAssocDefUris.size() > 0) {
            return this.unifyChildTopics(this.identityChildTopics(childTopics, identityAssocDefUris), identityAssocDefUris);
        }
        TopicModelImpl parent = this.createSimpleTopic();
        this.logger.fine("### Creating composite (w/o identity attrs) " + parent.id + " (typeUri=\"" + this.type.uri + "\")");
        return parent;
    }

    private Map<String, Object> identityChildTopics(Map<String, Object> childTopics, List<String> identityAssocDefUris) {
        HashMap<String, Object> identityChildTopics = new HashMap<String, Object>();
        for (String assocDefUri : identityAssocDefUris) {
            if (!this.isOne(assocDefUri)) {
                throw new RuntimeException("Cardinality \"many\" identity attributes not supported");
            }
            UnifiedValue childTopic = (UnifiedValue)childTopics.get(assocDefUri);
            if (childTopic.value == null) {
                throw new RuntimeException("Identity child topic \"" + assocDefUri + "\" is missing in " + childTopics.keySet());
            }
            identityChildTopics.put(assocDefUri, childTopic);
        }
        return identityChildTopics;
    }

    private DMXObjectModelImpl updateAssignments(DMXObjectModelImpl parent, Map<String, Object> childTopics) {
        if (!parent.getTypeUri().equals(this.type.getUri())) {
            throw new RuntimeException("Type mismatch: newValues type=\"" + this.type.getUri() + "\", parent type=\"" + parent.getTypeUri() + "\"");
        }
        for (String assocDefUri : this.assocDefUris()) {
            parent.loadChildTopics(this.assocDef(assocDefUri), true);
            Object childTopic = childTopics.get(assocDefUri);
            if (this.isOne(assocDefUri)) {
                TopicModel _childTopic = childTopic != null ? ((UnifiedValue)childTopic).value : null;
                this.updateAssignmentsOne(parent, _childTopic, assocDefUri);
                continue;
            }
            if (childTopic == null) continue;
            this.updateAssignmentsMany(parent, (List)childTopic, assocDefUri);
        }
        return parent;
    }

    private void updateAssignmentsOne(DMXObjectModelImpl parent, TopicModel childTopic, String assocDefUri) {
        try {
            ChildTopicsModelImpl oldChildTopics = parent.getChildTopicsModel();
            RelatedTopicModelImpl oldValue = oldChildTopics.getTopicOrNull(assocDefUri);
            if (oldValue != null && oldValue.id == -1L) {
                throw new RuntimeException("Old value's ID is not initialized, oldValue=" + oldValue);
            }
            boolean newValueIsEmpty = this.isEmptyValue(assocDefUri);
            boolean deleted = false;
            if (oldValue != null && (newValueIsEmpty || childTopic != null && !oldValue.equals(childTopic))) {
                oldValue.getRelatingAssociation().delete();
                if (newValueIsEmpty) {
                    this.logger.fine("### Deleting assignment (assocDefUri=\"" + assocDefUri + "\") from composite " + parent.id + " (typeUri=\"" + this.type.uri + "\")");
                    oldChildTopics.remove(assocDefUri);
                }
                deleted = true;
            }
            AssociationModelImpl assoc = null;
            if (!(childTopic == null || oldValue != null && oldValue.equals(childTopic))) {
                assoc = this.createChildAssociation(parent, childTopic, assocDefUri, deleted);
                oldChildTopics.put(assocDefUri, this.mf.newRelatedTopicModel(childTopic, (AssociationModel)assoc));
            }
            if (!this.isAssoc) {
                if (assoc == null && oldValue != null && !deleted) {
                    assoc = oldValue.getRelatingAssociation();
                }
                if (assoc != null) {
                    RelatedTopicModelImpl newChildValue = this.newValues.getChildTopicsModel().getTopicOrNull(assocDefUri);
                    this.updateRelatingAssociation(assoc, assocDefUri, newChildValue);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Updating assigment failed, parent=" + parent + ", childTopic=" + childTopic + ", assocDefUri=\"" + assocDefUri + "\"", e);
        }
    }

    private void updateAssignmentsMany(DMXObjectModelImpl parent, List<UnifiedValue> childValues, String assocDefUri) {
        ChildTopicsModelImpl oldChildTopics = parent.getChildTopicsModel();
        List<RelatedTopicModelImpl> oldValues = oldChildTopics.getTopicsOrNull(assocDefUri);
        for (UnifiedValue childValue : childValues) {
            TopicModel childTopic = (TopicModel)childValue.value;
            long originalId = childValue.originalId;
            long newId = childTopic != null ? childTopic.getId() : -1L;
            RelatedTopicModelImpl oldValue = null;
            if (originalId != -1L) {
                oldValue = this.findTopic(oldValues, originalId);
            }
            boolean deleted = false;
            if (originalId != -1L && (newId == -1L || originalId != newId)) {
                if (newId == -1L) {
                    this.logger.fine("### Deleting assignment (assocDefUri=\"" + assocDefUri + "\") from composite " + parent.id + " (typeUri=\"" + this.type.uri + "\")");
                }
                deleted = true;
                oldValue.getRelatingAssociation().delete();
                this.removeTopic(oldValues, originalId);
            }
            AssociationModelImpl assoc = null;
            if (newId != -1L && (originalId == -1L || originalId != newId)) {
                assoc = this.createChildAssociation(parent, childTopic, assocDefUri, deleted);
                oldChildTopics.add(assocDefUri, this.mf.newRelatedTopicModel(childTopic, (AssociationModel)assoc));
            }
            if (this.isAssoc) continue;
            if (assoc == null && oldValue != null && !deleted) {
                assoc = oldValue.getRelatingAssociation();
            }
            if (assoc == null) continue;
            RelatedTopicModelImpl newValues = (RelatedTopicModelImpl)childValue._newValues;
            this.updateRelatingAssociation(assoc, assocDefUri, newValues);
        }
    }

    private void updateRelatingAssociation(AssociationModelImpl assoc, String assocDefUri, RelatedTopicModelImpl newValues) {
        try {
            if (newValues != null) {
                AssociationModelImpl _newValues = newValues.getRelatingAssociation();
                _newValues.setRoleModel1(null);
                _newValues.setRoleModel2(null);
                if (_newValues.typeUri != null) {
                    assoc.update(_newValues);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Updating relating assoc " + assoc.id + " failed, assocDefUri=\"" + assocDefUri + "\", assoc=" + assoc, e);
        }
    }

    private DMXObjectModelImpl unifyChildTopics(Map<String, Object> childTopics, Iterable<String> assocDefUris) {
        List<RelatedTopicModelImpl> candidates = this.parentCandidates(childTopics);
        for (String assocDefUri : assocDefUris) {
            UnifiedValue value = (UnifiedValue)childTopics.get(assocDefUri);
            this.eliminateParentCandidates(candidates, value != null ? (DMXObjectModel)value.value : null, assocDefUri);
            if (!candidates.isEmpty()) continue;
            break;
        }
        switch (candidates.size()) {
            case 0: {
                return this.createCompositeTopic(childTopics);
            }
            case 1: {
                DMXObjectModelImpl comp = candidates.get(0);
                this.logger.fine("Reusing composite " + comp.getId() + " (typeUri=\"" + this.type.uri + "\")");
                return comp;
            }
        }
        throw new RuntimeException("ValueIntegrator ambiguity: there are " + candidates.size() + " parents (typeUri=\"" + this.type.uri + "\", " + DMXUtils.idList(candidates) + ") which have the same " + childTopics.values().size() + " child topics " + childTopics.values());
    }

    private List<RelatedTopicModelImpl> parentCandidates(Map<String, Object> childTopics) {
        String assocDefUri = childTopics.keySet().iterator().next();
        if (!this.type.getUri().equals(this.assocDef(assocDefUri).getParentTypeUri())) {
            throw new RuntimeException("Type mismatch: type=\"" + this.type.getUri() + "\", assoc def's parent type=\"" + this.assocDef(assocDefUri).getParentTypeUri() + "\"");
        }
        if (!this.isOne(assocDefUri)) {
            throw new RuntimeException("Unification of cardinality \"many\" values not yet implemented");
        }
        Object childTopic = ((UnifiedValue)childTopics.get((Object)assocDefUri)).value;
        return this.pl.getTopicRelatedTopics(childTopic.getId(), this.assocDef(assocDefUri).getInstanceLevelAssocTypeUri(), "dmx.core.child", "dmx.core.parent", this.type.getUri());
    }

    private void eliminateParentCandidates(List<RelatedTopicModelImpl> candidates, DMXObjectModel childTopic, String assocDefUri) {
        AssociationDefinitionModel assocDef = this.assocDef(assocDefUri);
        Iterator<RelatedTopicModelImpl> i = candidates.iterator();
        while (i.hasNext()) {
            long parentId = i.next().getId();
            String assocTypeUri = assocDef.getInstanceLevelAssocTypeUri();
            if (childTopic != null) {
                if (this.pl.getAssociation(assocTypeUri, parentId, childTopic.getId(), "dmx.core.parent", "dmx.core.child") != null) continue;
                i.remove();
                continue;
            }
            if (this.pl.getTopicRelatedTopics(parentId, assocTypeUri, "dmx.core.parent", "dmx.core.child", assocDef.getChildTypeUri()).isEmpty()) continue;
            i.remove();
        }
    }

    private TopicModelImpl createSimpleTopic() {
        if (this.isAssoc) {
            throw new RuntimeException("Tried to create a topic from an assoc model");
        }
        return this.pl.createSingleTopic(this.mf.newTopicModel(this.newValues.uri, this.newValues.typeUri, this.newValues.value)).getModel();
    }

    private TopicModelImpl createCompositeTopic(Map<String, Object> childTopics) {
        TopicModelImpl topic = this.createSimpleTopic();
        this.logger.fine("### Creating composite " + topic.id + " (typeUri=\"" + this.type.uri + "\")");
        for (String assocDefUri : childTopics.keySet()) {
            if (this.isOne(assocDefUri)) {
                Object childTopic = ((UnifiedValue)childTopics.get((Object)assocDefUri)).value;
                this.createChildAssociation(topic, (DMXObjectModel)childTopic, assocDefUri);
                continue;
            }
            for (UnifiedValue value : (List)childTopics.get(assocDefUri)) {
                this.createChildAssociation(topic, (DMXObjectModel)value.value, assocDefUri);
            }
        }
        return topic;
    }

    private AssociationModelImpl createChildAssociation(DMXObjectModel parent, DMXObjectModel child, String assocDefUri) {
        return this.createChildAssociation(parent, child, assocDefUri, false);
    }

    private AssociationModelImpl createChildAssociation(DMXObjectModel parent, DMXObjectModel child, String assocDefUri, boolean deleted) {
        this.logger.fine("### " + (deleted ? "Reassigning" : "Assigning") + " child " + child.getId() + " (assocDefUri=\"" + assocDefUri + "\") to composite " + parent.getId() + " (typeUri=\"" + this.type.uri + "\")");
        return this.pl.createAssociation(this.assocDef(assocDefUri).getInstanceLevelAssocTypeUri(), parent.createRoleModel("dmx.core.parent"), child.createRoleModel("dmx.core.child")).getModel();
    }

    private RelatedTopicModelImpl findTopic(List<RelatedTopicModelImpl> topics, long topicId) {
        for (RelatedTopicModelImpl topic : topics) {
            if (topic.id != topicId) continue;
            return topic;
        }
        throw new RuntimeException("Topic " + topicId + " not found in " + topics);
    }

    private void removeTopic(List<RelatedTopicModelImpl> topics, long topicId) {
        Iterator<RelatedTopicModelImpl> i = topics.iterator();
        while (i.hasNext()) {
            RelatedTopicModelImpl topic = i.next();
            if (topic.id != topicId) continue;
            i.remove();
            return;
        }
        throw new RuntimeException("Topic " + topicId + " not found in " + topics);
    }

    private AssociationDefinitionModel assocDef(String assocDefUri) {
        if (this.isFacetUpdate) {
            if (!assocDefUri.equals(this.assocDef.getAssocDefUri())) {
                throw new RuntimeException("URI mismatch: assocDefUri=\"" + assocDefUri + "\", facet assocDefUri=\"" + this.assocDef.getAssocDefUri() + "\"");
            }
            return this.assocDef;
        }
        return this.type.getAssocDef(assocDefUri);
    }

    private boolean isOne(String assocDefUri) {
        return this.assocDef(assocDefUri).getChildCardinalityUri().equals("dmx.core.one");
    }

    private boolean isValueType() {
        return this.type.getDataTypeUri().equals("dmx.core.value");
    }

    private boolean isEmptyValue(String assocDefUri) {
        return this.emptyValues.contains(assocDefUri);
    }

    static class UnifiedValue<M extends DMXObjectModelImpl> {
        M value;
        DMXObjectModelImpl _newValues;
        long originalId;
        final /* synthetic */ ValueIntegrator this$0;

        private UnifiedValue(M value) {
            this.this$0 = this$0;
            this.value = value;
            this._newValues = ((ValueIntegrator)this$0).newValues;
            this.originalId = ((ValueIntegrator)this$0).newValues.id;
        }
    }
}

