/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.geomaps.model;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.codehaus.jettison.json.JSONObject;
import systems.dmx.core.JSONEnabled;
import systems.dmx.core.RelatedTopic;
import systems.dmx.core.Topic;
import systems.dmx.core.model.TopicModel;
import systems.dmx.core.service.CoreService;
import systems.dmx.core.util.DMXUtils;

public class Geomap
implements Iterable<TopicModel>,
JSONEnabled {
    protected Topic geomapTopic;
    protected Map<Long, TopicModel> geoCoords = new HashMap<Long, TopicModel>();
    protected CoreService dmx;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    public Geomap(long geomapId, CoreService dmx) {
        this.logger.info("Loading geomap " + geomapId);
        this.geomapTopic = dmx.getTopic(geomapId).loadChildTopics();
        this.dmx = dmx;
        this.fetchGeoCoordinates();
    }

    public long getId() {
        return this.geomapTopic.getId();
    }

    public boolean containsTopic(long geoCoordId) {
        return this.geoCoords.get(geoCoordId) != null;
    }

    public JSONObject toJSON() {
        try {
            return new JSONObject().put("info", (Object)this.geomapTopic.toJSON()).put("topics", (Object)DMXUtils.toJSONArray(this.geoCoords.values()));
        }
        catch (Exception e) {
            throw new RuntimeException("Serialization failed", e);
        }
    }

    @Override
    public Iterator<TopicModel> iterator() {
        return this.geoCoords.values().iterator();
    }

    public String toString() {
        return "geomap " + this.getId();
    }

    private void fetchGeoCoordinates() {
        for (Topic topic : this.fetchGeoCoordinates(this.geomapTopic)) {
            this.geoCoords.put(topic.getId(), topic.getModel());
        }
    }

    private List<RelatedTopic> fetchGeoCoordinates(Topic geomapTopic) {
        return DMXUtils.loadChildTopics((List)geomapTopic.getRelatedTopics("dmx.geomaps.geotopic_mapcontext", "dmx.core.default", "dmx.topicmaps.topicmap_topic", "dmx.geomaps.geo_coordinate"));
    }
}

