/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.files;

import java.io.File;
import java.io.InputStream;
import org.apache.commons.fileupload.FileItem;
import systems.dmx.files.DiskQuotaCheck;

public class UploadedFile {
    private FileItem fileItem;
    private DiskQuotaCheck diskQuotaCheck;

    public UploadedFile(FileItem fileItem, DiskQuotaCheck diskQuotaCheck) {
        this.fileItem = fileItem;
        this.diskQuotaCheck = diskQuotaCheck;
    }

    public String getName() {
        return this.fileItem.getName();
    }

    public long getSize() {
        return this.fileItem.getSize();
    }

    public String getMediaType() {
        return this.fileItem.getContentType();
    }

    public String getString() {
        return this.fileItem.getString();
    }

    public String getString(String encoding) {
        try {
            return this.fileItem.getString(encoding);
        }
        catch (Exception e) {
            throw new RuntimeException("Getting contents of uploaded file failed (" + this + ")", e);
        }
    }

    public byte[] getBytes() {
        return this.fileItem.get();
    }

    public InputStream getInputStream() {
        try {
            return this.fileItem.getInputStream();
        }
        catch (Exception e) {
            throw new RuntimeException("Getting input stream of uploaded file failed (" + this + ")", e);
        }
    }

    public void write(File file) {
        try {
            this.diskQuotaCheck.check(this.getSize());
            this.fileItem.write(file);
        }
        catch (Exception e) {
            throw new RuntimeException("Writing uploaded file to disk failed (" + this + ")", e);
        }
    }

    public String toString() {
        return "file \"" + this.getName() + "\" (" + this.getMediaType() + ", " + this.getSize() + " bytes)";
    }
}

