/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.accesscontrol;

import com.sun.jersey.spi.container.ContainerRequest;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import systems.dmx.accesscontrol.AccessControlService;
import systems.dmx.accesscontrol.AnonymousAccessFilter;
import systems.dmx.accesscontrol.AuthorizationMethod;
import systems.dmx.accesscontrol.event.PostLoginUserListener;
import systems.dmx.accesscontrol.event.PostLogoutUserListener;
import systems.dmx.config.ConfigCustomizer;
import systems.dmx.config.ConfigDefinition;
import systems.dmx.config.ConfigModificationRole;
import systems.dmx.config.ConfigService;
import systems.dmx.config.ConfigTarget;
import systems.dmx.core.Association;
import systems.dmx.core.AssociationType;
import systems.dmx.core.DMXObject;
import systems.dmx.core.RelatedTopic;
import systems.dmx.core.Topic;
import systems.dmx.core.TopicType;
import systems.dmx.core.model.AssociationModel;
import systems.dmx.core.model.RoleModel;
import systems.dmx.core.model.SimpleValue;
import systems.dmx.core.model.TopicModel;
import systems.dmx.core.osgi.PluginActivator;
import systems.dmx.core.service.DMXEvent;
import systems.dmx.core.service.EventListener;
import systems.dmx.core.service.Inject;
import systems.dmx.core.service.Transactional;
import systems.dmx.core.service.accesscontrol.AccessControl;
import systems.dmx.core.service.accesscontrol.AccessControlException;
import systems.dmx.core.service.accesscontrol.Credentials;
import systems.dmx.core.service.accesscontrol.Operation;
import systems.dmx.core.service.accesscontrol.Permissions;
import systems.dmx.core.service.accesscontrol.SharingMode;
import systems.dmx.core.service.event.CheckAssociationReadAccessListener;
import systems.dmx.core.service.event.CheckAssociationWriteAccessListener;
import systems.dmx.core.service.event.CheckTopicReadAccessListener;
import systems.dmx.core.service.event.CheckTopicWriteAccessListener;
import systems.dmx.core.service.event.PostCreateAssociationListener;
import systems.dmx.core.service.event.PostCreateTopicListener;
import systems.dmx.core.service.event.PostUpdateAssociationListener;
import systems.dmx.core.service.event.PostUpdateTopicListener;
import systems.dmx.core.service.event.PreCreateTopicListener;
import systems.dmx.core.service.event.PreUpdateTopicListener;
import systems.dmx.core.service.event.ServiceRequestFilterListener;
import systems.dmx.core.service.event.StaticResourceFilterListener;
import systems.dmx.core.util.JavaUtils;
import systems.dmx.files.FilesService;
import systems.dmx.files.event.CheckDiskQuotaListener;
import systems.dmx.workspaces.WorkspacesService;

@Path(value="/accesscontrol")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class AccessControlPlugin
extends PluginActivator
implements AccessControlService,
ConfigCustomizer,
CheckTopicReadAccessListener,
CheckTopicWriteAccessListener,
CheckAssociationReadAccessListener,
CheckAssociationWriteAccessListener,
PreCreateTopicListener,
PreUpdateTopicListener,
PostCreateTopicListener,
PostCreateAssociationListener,
PostUpdateTopicListener,
PostUpdateAssociationListener,
ServiceRequestFilterListener,
StaticResourceFilterListener,
CheckDiskQuotaListener {
    private static final String ANONYMOUS_READ_ALLOWED = System.getProperty("dmx.security.anonymous_read_allowed", "ALL");
    private static final String ANONYMOUS_WRITE_ALLOWED = System.getProperty("dmx.security.anonymous_write_allowed", "NONE");
    private static final AnonymousAccessFilter accessFilter = new AnonymousAccessFilter(ANONYMOUS_READ_ALLOWED, ANONYMOUS_WRITE_ALLOWED);
    private static final String SUBNET_FILTER = System.getProperty("dmx.security.subnet_filter", "127.0.0.1/32");
    private static final boolean NEW_ACCOUNTS_ARE_ENABLED = Boolean.parseBoolean(System.getProperty("dmx.security.new_accounts_are_enabled", "true"));
    private static final boolean IS_PUBLIC_INSTALLATION = ANONYMOUS_READ_ALLOWED.equals("ALL");
    private static final String AUTHENTICATION_REALM = "DMX";
    private static final String LOGIN_ENABLED_TYPE = "dmx.accesscontrol.login_enabled";
    private static final String MEMBERSHIP_TYPE = "dmx.accesscontrol.membership";
    private static final String PROP_CREATOR = "dmx.accesscontrol.creator";
    private static final String PROP_OWNER = "dmx.accesscontrol.owner";
    private static final String PROP_MODIFIER = "dmx.accesscontrol.modifier";
    private static DMXEvent POST_LOGIN_USER = new DMXEvent(PostLoginUserListener.class){

        public void dispatch(EventListener listener, Object ... params) {
            ((PostLoginUserListener)listener).postLoginUser((String)params[0]);
        }
    };
    private static DMXEvent POST_LOGOUT_USER = new DMXEvent(PostLogoutUserListener.class){

        public void dispatch(EventListener listener, Object ... params) {
            ((PostLogoutUserListener)listener).postLogoutUser((String)params[0]);
        }
    };
    @Inject
    private WorkspacesService wsService;
    @Inject
    private FilesService filesService;
    @Inject
    private ConfigService configService;
    @Context
    private HttpServletRequest request;
    private Map<String, AuthorizationMethod> authorizationMethods = new HashMap<String, AuthorizationMethod>();
    private static Logger logger = Logger.getLogger(AccessControlPlugin.class.getName());

    @Override
    @POST
    @Path(value="/login")
    public void login() {
    }

    @Override
    @POST
    @Path(value="/logout")
    public void logout() {
        this._logout(this.request);
        if (!IS_PUBLIC_INSTALLATION) {
            this.throw401Unauthorized(true);
        }
    }

    @Override
    @GET
    @Path(value="/user")
    @Produces(value={"text/plain"})
    public String getUsername() {
        return this.dmx.getAccessControl().getUsername(this.request);
    }

    @Override
    @GET
    @Path(value="/username")
    public Topic getUsernameTopic() {
        return this.dmx.getAccessControl().getUsernameTopic(this.request);
    }

    @Override
    @GET
    @Path(value="/user/workspace")
    public Topic getPrivateWorkspace() {
        String username = this.getUsername();
        if (username == null) {
            throw new IllegalStateException("No user is logged in");
        }
        return this.dmx.getAccessControl().getPrivateWorkspace(username);
    }

    @Override
    @POST
    @Path(value="/user_account")
    @Transactional
    public Topic createUserAccount(final Credentials cred) {
        try {
            String username = cred.username;
            AccessControl ac = this.dmx.getAccessControl();
            logger.info("Creating user account \"" + username + "\"");
            final Topic usernameTopic = this.createUsername(username);
            Topic userAccount = (Topic)ac.runWithoutWorkspaceAssignment((Callable)new Callable<Topic>(){

                @Override
                public Topic call() {
                    return AccessControlPlugin.this.dmx.createTopic(AccessControlPlugin.this.mf.newTopicModel("dmx.accesscontrol.user_account", AccessControlPlugin.this.mf.newChildTopicsModel().putRef("dmx.accesscontrol.username", usernameTopic.getId()).put("dmx.accesscontrol.password", (Object)cred.password)));
                }
            });
            RelatedTopic passwordTopic = userAccount.getChildTopics().getTopic("dmx.accesscontrol.password");
            long privateWorkspaceId = ac.getPrivateWorkspace(username).getId();
            ac.assignToWorkspace((DMXObject)userAccount, privateWorkspaceId);
            ac.assignToWorkspace((DMXObject)passwordTopic, privateWorkspaceId);
            return usernameTopic;
        }
        catch (Exception e) {
            throw new RuntimeException("Creating user account \"" + cred.username + "\" failed", e);
        }
    }

    @Override
    public Topic createUsername(final String username) {
        try {
            logger.info("Creating username topic \"" + username + "\"");
            AccessControl ac = this.dmx.getAccessControl();
            Topic usernameTopic = (Topic)ac.runWithoutWorkspaceAssignment((Callable)new Callable<Topic>(){

                @Override
                public Topic call() {
                    return AccessControlPlugin.this.dmx.createTopic(AccessControlPlugin.this.mf.newTopicModel("dmx.accesscontrol.username", new SimpleValue(username)));
                }
            });
            this.setWorkspaceOwner(this.wsService.createWorkspace("Private Workspace", null, SharingMode.PRIVATE), username);
            ac.assignToWorkspace((DMXObject)usernameTopic, ac.getSystemWorkspaceId());
            return usernameTopic;
        }
        catch (Exception e) {
            throw new RuntimeException("Creating username topic \"" + username + "\" failed", e);
        }
    }

    @Override
    @GET
    @Path(value="/username/{username}")
    public Topic getUsernameTopic(@PathParam(value="username") String username) {
        return this.dmx.getAccessControl().getUsernameTopic(username);
    }

    @Override
    @GET
    @Path(value="/workspace/{workspace_id}/owner")
    @Produces(value={"text/plain"})
    public String getWorkspaceOwner(@PathParam(value="workspace_id") long workspaceId) {
        return this.dmx.hasProperty(workspaceId, PROP_OWNER) ? (String)this.dmx.getProperty(workspaceId, PROP_OWNER) : null;
    }

    @Override
    public void setWorkspaceOwner(Topic workspace, String username) {
        try {
            workspace.setProperty(PROP_OWNER, (Object)username, true);
        }
        catch (Exception e) {
            throw new RuntimeException("Setting the workspace owner of " + this.info((DMXObject)workspace) + " failed (username=" + username + ")", e);
        }
    }

    @Override
    @POST
    @Path(value="/user/{username}/workspace/{workspace_id}")
    @Transactional
    public void createMembership(@PathParam(value="username") String username, @PathParam(value="workspace_id") long workspaceId) {
        try {
            Association assoc = this.dmx.createAssociation(this.mf.newAssociationModel(MEMBERSHIP_TYPE, (RoleModel)this.mf.newTopicRoleModel(this.getUsernameTopicOrThrow(username).getId(), "dmx.core.default"), (RoleModel)this.mf.newTopicRoleModel(workspaceId, "dmx.core.default")));
            this.assignMembership(assoc);
        }
        catch (Exception e) {
            throw new RuntimeException("Creating membership for user \"" + username + "\" and workspace " + workspaceId + " failed", e);
        }
    }

    @Override
    public boolean isMember(String username, long workspaceId) {
        return this.dmx.getAccessControl().isMember(username, workspaceId);
    }

    @Override
    @GET
    @Path(value="/topic/{id}")
    public Permissions getTopicPermissions(@PathParam(value="id") long topicId) {
        return this.getPermissions(topicId);
    }

    @Override
    @GET
    @Path(value="/association/{id}")
    public Permissions getAssociationPermissions(@PathParam(value="id") long assocId) {
        return this.getPermissions(assocId);
    }

    @Override
    @GET
    @Path(value="/object/{id}/creator")
    @Produces(value={"text/plain"})
    public String getCreator(@PathParam(value="id") long objectId) {
        return this.dmx.getAccessControl().getCreator(objectId);
    }

    @Override
    @GET
    @Path(value="/object/{id}/modifier")
    @Produces(value={"text/plain"})
    public String getModifier(@PathParam(value="id") long objectId) {
        return this.dmx.hasProperty(objectId, PROP_MODIFIER) ? (String)this.dmx.getProperty(objectId, PROP_MODIFIER) : null;
    }

    @Override
    @GET
    @Path(value="/creator/{username}/topics")
    public Collection<Topic> getTopicsByCreator(@PathParam(value="username") String username) {
        return this.dmx.getTopicsByProperty(PROP_CREATOR, (Object)username);
    }

    @Override
    @GET
    @Path(value="/owner/{username}/topics")
    public Collection<Topic> getTopicsByOwner(@PathParam(value="username") String username) {
        return this.dmx.getTopicsByProperty(PROP_OWNER, (Object)username);
    }

    @Override
    @GET
    @Path(value="/creator/{username}/assocs")
    public Collection<Association> getAssociationsByCreator(@PathParam(value="username") String username) {
        return this.dmx.getAssociationsByProperty(PROP_CREATOR, (Object)username);
    }

    @Override
    @GET
    @Path(value="/owner/{username}/assocs")
    public Collection<Association> getAssociationsByOwner(@PathParam(value="username") String username) {
        return this.dmx.getAssociationsByProperty(PROP_OWNER, (Object)username);
    }

    @Override
    public void registerAuthorizationMethod(String name, AuthorizationMethod am) {
        if (this.authorizationMethods.containsKey(name)) {
            throw new RuntimeException("Authorization method \"" + name + "\" already registered");
        }
        this.authorizationMethods.put(name, am);
    }

    @Override
    public void unregisterAuthorizationMethod(String name) {
        this.authorizationMethods.remove(name);
    }

    @Override
    @GET
    @Path(value="/methods")
    public Set<String> getAuthorizationMethods() {
        return this.authorizationMethods.keySet();
    }

    public void preInstall() {
        this.configService.registerConfigDefinition(new ConfigDefinition(ConfigTarget.TYPE_INSTANCES, "dmx.accesscontrol.username", this.mf.newTopicModel(LOGIN_ENABLED_TYPE, new SimpleValue(NEW_ACCOUNTS_ARE_ENABLED)), ConfigModificationRole.ADMIN, (ConfigCustomizer)this));
    }

    public void shutdown() {
        if (this.configService != null) {
            this.configService.unregisterConfigDefinition(LOGIN_ENABLED_TYPE);
        } else {
            logger.warning("Config service is already gone");
        }
    }

    public TopicModel getConfigValue(Topic topic) {
        if (!topic.getTypeUri().equals("dmx.accesscontrol.username")) {
            throw new RuntimeException("Unexpected configurable topic: " + topic);
        }
        if (topic.getSimpleValue().toString().equals("admin")) {
            return this.mf.newTopicModel(LOGIN_ENABLED_TYPE, new SimpleValue(true));
        }
        return null;
    }

    public void checkTopicReadAccess(long topicId) {
        this.checkReadAccess(topicId);
    }

    public void checkTopicWriteAccess(long topicId) {
        this.checkWriteAccess(topicId);
    }

    public void checkAssociationReadAccess(long assocId) {
        this.checkReadAccess(assocId);
        long[] playerIds = this.dmx.getPlayerIds(assocId);
        this.checkReadAccess(playerIds[0]);
        this.checkReadAccess(playerIds[1]);
    }

    public void checkAssociationWriteAccess(long assocId) {
        this.checkWriteAccess(assocId);
    }

    public void preCreateTopic(TopicModel model) {
        String username;
        Topic usernameTopic;
        if (model.getTypeUri().equals("dmx.accesscontrol.username") && (usernameTopic = this.getUsernameTopic(username = model.getSimpleValue().toString())) != null) {
            throw new RuntimeException("Username \"" + username + "\" exists already");
        }
    }

    public void postCreateTopic(Topic topic) {
        String typeUri = topic.getTypeUri();
        if (typeUri.equals("dmx.workspaces.workspace")) {
            this.setWorkspaceOwner(topic);
        } else if (typeUri.equals("dmx.webclient.search")) {
            this.assignSearchTopic(topic);
        }
        this.setCreatorAndModifier((DMXObject)topic);
    }

    public void postCreateAssociation(Association assoc) {
        this.setCreatorAndModifier((DMXObject)assoc);
    }

    public void preUpdateTopic(Topic topic, TopicModel updateModel) {
        if (topic.getTypeUri().equals("dmx.accesscontrol.username")) {
            SimpleValue newUsername = updateModel.getSimpleValue();
            String oldUsername = topic.getSimpleValue().toString();
            if (newUsername != null && !newUsername.toString().equals(oldUsername)) {
                throw new RuntimeException("A Username can't be changed (tried \"" + oldUsername + "\" -> \"" + newUsername + "\")");
            }
        }
    }

    public void postUpdateTopic(Topic topic, TopicModel updateModel, TopicModel oldTopic) {
        this.setModifier((DMXObject)topic);
    }

    public void postUpdateAssociation(Association assoc, AssociationModel updateModel, AssociationModel oldAssoc) {
        if (this.isMembership(assoc.getModel()) && !this.isMembership(oldAssoc)) {
            this.assignMembership(assoc);
        }
        this.setModifier((DMXObject)assoc);
    }

    public void serviceRequestFilter(ContainerRequest containerRequest) {
        this.requestFilter(this.request);
    }

    public void staticResourceFilter(HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        this.requestFilter(servletRequest);
    }

    public void checkDiskQuota(String username, long fileSize, long diskQuota) {
        if (diskQuota < 0L) {
            logger.info("### Checking disk quota of " + this.userInfo(username) + " SKIPPED -- disk quota is disabled");
            return;
        }
        long occupiedSpace = this.getOccupiedSpace(username);
        boolean quotaOK = occupiedSpace + fileSize <= diskQuota;
        logger.info("### File size: " + fileSize + " bytes, " + this.userInfo(username) + " occupies " + occupiedSpace + " bytes, disk quota: " + diskQuota + " bytes => QUOTA " + (quotaOK ? "OK" : "EXCEEDED"));
        if (!quotaOK) {
            throw new RuntimeException("Disk quota of " + this.userInfo(username) + " exceeded. Disk quota: " + diskQuota + " bytes. Currently occupied: " + occupiedSpace + " bytes.");
        }
    }

    private Topic getUsernameTopicOrThrow(String username) {
        Topic usernameTopic = this.getUsernameTopic(username);
        if (usernameTopic == null) {
            throw new RuntimeException("User \"" + username + "\" does not exist");
        }
        return usernameTopic;
    }

    private boolean isMembership(AssociationModel assoc) {
        return assoc.getTypeUri().equals(MEMBERSHIP_TYPE);
    }

    private void assignMembership(Association assoc) {
        this.wsService.assignToWorkspace((DMXObject)assoc, assoc.getTopicByType("dmx.workspaces.workspace").getId());
    }

    private void assignSearchTopic(Topic searchTopic) {
        try {
            Topic workspace = this.getUsername() != null ? this.getPrivateWorkspace() : this.wsService.getWorkspace("dmx.workspaces.dmx");
            this.wsService.assignToWorkspace((DMXObject)searchTopic, workspace.getId());
        }
        catch (Exception e) {
            throw new RuntimeException("Assigning search topic to workspace failed", e);
        }
    }

    private long getOccupiedSpace(String username) {
        long occupiedSpace = 0L;
        for (Topic fileTopic : this.dmx.getTopicsByType("dmx.files.file")) {
            long fileTopicId = fileTopic.getId();
            if (!this.getCreator(fileTopicId).equals(username)) continue;
            occupiedSpace += this.filesService.getFile(fileTopicId).length();
        }
        return occupiedSpace;
    }

    private void requestFilter(HttpServletRequest request) {
        logger.fine("##### " + request.getMethod() + " " + request.getRequestURL() + "\n      ##### \"Authorization\"=\"" + request.getHeader("Authorization") + "\"\n      ##### " + this.info(request.getSession(false)));
        this.checkRequestOrigin(request);
        HttpSession session = request.getSession();
        if (this.username(session) == null) {
            this.checkAuthorization(request);
        }
    }

    private void checkRequestOrigin(HttpServletRequest request) {
        String remoteAddr = request.getRemoteAddr();
        boolean allowed = JavaUtils.isInRange((String)remoteAddr, (String)SUBNET_FILTER);
        logger.fine("Remote address=\"" + remoteAddr + "\", dmx.security.subnet_filter=\"" + SUBNET_FILTER + "\" => " + (allowed ? "ALLOWED" : "FORBIDDEN"));
        if (!allowed) {
            this.throw403Forbidden();
        }
    }

    private void checkAuthorization(HttpServletRequest request) {
        boolean authorized;
        String authHeader = request.getHeader("Authorization");
        if (authHeader != null) {
            Credentials cred = new Credentials(authHeader);
            AuthorizationMethod am = this.getAuthorizationMethod(cred);
            authorized = this.tryLogin(cred, am, request);
        } else {
            authorized = accessFilter.isAnonymousAccessAllowed(request);
        }
        if (!authorized) {
            this.throw401Unauthorized(!IS_PUBLIC_INSTALLATION);
        }
    }

    private AuthorizationMethod getAuthorizationMethod(Credentials cred) {
        AuthorizationMethod am = null;
        if (!cred.methodName.equals("Basic")) {
            logger.info("authMethodName: \"" + cred.methodName + "\"");
            am = this.getAuthorizationMethod(cred.methodName);
        }
        return am;
    }

    private AuthorizationMethod getAuthorizationMethod(String name) {
        AuthorizationMethod am = this.authorizationMethods.get(name);
        if (am == null) {
            throw new RuntimeException("Authorization method \"" + name + "\" is not registered");
        }
        return am;
    }

    private boolean tryLogin(Credentials cred, AuthorizationMethod am, HttpServletRequest request) {
        String username = cred.username;
        Topic usernameTopic = this.checkCredentials(cred, am);
        if (usernameTopic != null && this.getLoginEnabled(usernameTopic)) {
            logger.info("##### Logging in as \"" + username + "\" => SUCCESSFUL!");
            this._login(username, request);
            return true;
        }
        logger.info("##### Logging in as \"" + username + "\" => FAILED!");
        return false;
    }

    private Topic checkCredentials(Credentials cred, AuthorizationMethod am) {
        if (am == null) {
            return this.dmx.getAccessControl().checkCredentials(cred);
        }
        return am.checkCredentials(cred);
    }

    private boolean getLoginEnabled(Topic usernameTopic) {
        RelatedTopic loginEnabled = this.dmx.getAccessControl().getConfigTopic(LOGIN_ENABLED_TYPE, usernameTopic.getId());
        return loginEnabled.getSimpleValue().booleanValue();
    }

    private void _login(String username, HttpServletRequest request) {
        request.getSession(false).setAttribute("username", (Object)username);
        this.dmx.fireEvent(POST_LOGIN_USER, new Object[]{username});
    }

    private void _logout(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        String username = this.username(session);
        logger.info("##### Logging out from " + this.info(session));
        session.removeAttribute("username");
        this.dmx.fireEvent(POST_LOGOUT_USER, new Object[]{username});
    }

    private String username(HttpSession session) {
        return this.dmx.getAccessControl().username(session);
    }

    private void throw401Unauthorized(boolean showBrowserLoginDialog) {
        String authScheme = showBrowserLoginDialog ? "Basic" : "xBasic";
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.UNAUTHORIZED).header("WWW-Authenticate", (Object)(authScheme + " realm=" + AUTHENTICATION_REALM)).header("Content-Type", (Object)"text/html").entity((Object)"You're not authorized. Sorry.").build());
    }

    private void throw403Forbidden() {
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.FORBIDDEN).header("Content-Type", (Object)"text/html").entity((Object)"Access is forbidden. Sorry.").build());
    }

    private void setCreatorAndModifier(DMXObject object) {
        try {
            String username = this.getUsername();
            if (username == null) {
                logger.fine("Setting the creator/modifier of " + this.info(object) + " SKIPPED -- no user is logged in");
                return;
            }
            this.setCreatorAndModifier(object, username);
        }
        catch (Exception e) {
            throw new RuntimeException("Setting the creator/modifier of " + this.info(object) + " failed", e);
        }
    }

    private void setCreatorAndModifier(DMXObject object, String username) {
        this.setCreator(object, username);
        this.setModifier(object, username);
    }

    private void setCreator(DMXObject object, String username) {
        try {
            object.setProperty(PROP_CREATOR, (Object)username, true);
        }
        catch (Exception e) {
            throw new RuntimeException("Setting the creator of " + this.info(object) + " failed (username=" + username + ")", e);
        }
    }

    private void setModifier(DMXObject object) {
        String username = this.getUsername();
        if (username == null) {
            return;
        }
        this.setModifier(object, username);
    }

    private void setModifier(DMXObject object, String username) {
        object.setProperty(PROP_MODIFIER, (Object)username, false);
    }

    private void setWorkspaceOwner(Topic workspace) {
        String username = this.getUsername();
        if (username == null) {
            return;
        }
        this.setWorkspaceOwner(workspace, username);
    }

    private void checkReadAccess(long objectId) {
        this.checkAccess(Operation.READ, objectId);
    }

    private void checkWriteAccess(long objectId) {
        this.checkAccess(Operation.WRITE, objectId);
    }

    private void checkAccess(Operation operation, long objectId) {
        if (!this.inRequestScope()) {
            logger.fine("### Object " + objectId + " is accessed by \"System\" -- " + operation + " permission is granted");
            return;
        }
        String username = this.getUsername();
        if (!this.hasPermission(username, operation, objectId)) {
            throw new AccessControlException(this.userInfo(username) + " has no " + operation + " permission for object " + objectId);
        }
    }

    private Permissions getPermissions(long objectId) {
        return new Permissions().add(Operation.WRITE, this.hasPermission(this.getUsername(), Operation.WRITE, objectId));
    }

    private boolean hasPermission(String username, Operation operation, long objectId) {
        return this.dmx.getAccessControl().hasPermission(username, operation, objectId);
    }

    private boolean inRequestScope() {
        try {
            this.request.getMethod();
            return true;
        }
        catch (IllegalStateException e) {
            return false;
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    private String info(DMXObject object) {
        if (object instanceof TopicType) {
            return "topic type \"" + object.getUri() + "\" (id=" + object.getId() + ")";
        }
        if (object instanceof AssociationType) {
            return "association type \"" + object.getUri() + "\" (id=" + object.getId() + ")";
        }
        if (object instanceof Topic) {
            return "topic " + object.getId() + " (typeUri=\"" + object.getTypeUri() + "\", uri=\"" + object.getUri() + "\")";
        }
        if (object instanceof Association) {
            return "association " + object.getId() + " (typeUri=\"" + object.getTypeUri() + "\")";
        }
        throw new RuntimeException("Unexpected object: " + object);
    }

    private String userInfo(String username) {
        return "user " + (username != null ? "\"" + username + "\"" : "<anonymous>");
    }

    private String info(HttpSession session) {
        return "session" + (session != null ? " " + session.getId() + " (username=" + this.username(session) + ")" : ": null");
    }

    private String info(HttpServletRequest request) {
        StringBuilder info = new StringBuilder();
        info.append("    " + request.getMethod() + " " + request.getRequestURI() + "\n");
        Enumeration e1 = request.getHeaderNames();
        while (e1.hasMoreElements()) {
            String name = (String)e1.nextElement();
            info.append("\n    " + name + ":");
            Enumeration e2 = request.getHeaders(name);
            while (e2.hasMoreElements()) {
                String header = (String)e2.nextElement();
                info.append(" " + header);
            }
        }
        return info.toString();
    }

    static {
        logger.info("Security settings:\n  dmx.security.anonymous_read_allowed = " + accessFilter.dumpReadSetting() + "\n  dmx.security.anonymous_write_allowed = " + accessFilter.dumpWriteSetting() + "\n  dmx.security.subnet_filter = " + SUBNET_FILTER + "\n  dmx.security.new_accounts_are_enabled = " + NEW_ACCOUNTS_ARE_ENABLED);
    }
}

