/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.geomaps;

import java.net.URL;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.codehaus.jettison.json.JSONObject;
import systems.dmx.core.ChildTopics;
import systems.dmx.core.DMXObject;
import systems.dmx.core.RelatedTopic;
import systems.dmx.core.Topic;
import systems.dmx.core.model.AssociationModel;
import systems.dmx.core.model.ChildTopicsModel;
import systems.dmx.core.model.RoleModel;
import systems.dmx.core.model.TopicModel;
import systems.dmx.core.osgi.PluginActivator;
import systems.dmx.core.service.Cookies;
import systems.dmx.core.service.Inject;
import systems.dmx.core.service.Transactional;
import systems.dmx.core.service.event.PostCreateTopicListener;
import systems.dmx.core.service.event.PostUpdateTopicListener;
import systems.dmx.core.service.event.PreSendTopicListener;
import systems.dmx.core.util.ContextTracker;
import systems.dmx.core.util.JavaUtils;
import systems.dmx.facets.FacetsService;
import systems.dmx.geomaps.GeomapRenderer;
import systems.dmx.geomaps.GeomapsService;
import systems.dmx.geomaps.model.GeoCoordinate;
import systems.dmx.geomaps.model.Geomap;
import systems.dmx.topicmaps.TopicmapRenderer;
import systems.dmx.topicmaps.TopicmapsService;

@Path(value="/geomap")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class GeomapsPlugin
extends PluginActivator
implements GeomapsService,
PostCreateTopicListener,
PostUpdateTopicListener,
PreSendTopicListener {
    private static final String GEOCODER_URL = "http://maps.googleapis.com/maps/api/geocode/json?address=%s&sensor=false";
    private static final String COOKIE_NO_GEOCODING = "dmx_no_geocoding";
    private static final double EARTH_RADIUS_KM = 6371.009;
    @Inject
    private TopicmapsService topicmapsService;
    @Inject
    private FacetsService facetsService;
    private ContextTracker contextTracker = new ContextTracker();
    private Logger logger = Logger.getLogger(this.getClass().getName());

    @Override
    @GET
    @Path(value="/{id}")
    public Geomap getGeomap(@PathParam(value="id") long geomapId) {
        return new Geomap(geomapId, this.dmx);
    }

    @Override
    @GET
    @Path(value="/topic/{id}")
    public Topic getDomainTopic(@PathParam(value="id") long geoCoordId) {
        try {
            RelatedTopic parentTopic;
            Topic topic = this.dmx.getTopic(geoCoordId);
            while ((parentTopic = topic.getRelatedTopic(null, "dmx.core.child", "dmx.core.parent", null)) != null) {
                topic = parentTopic;
            }
            return topic;
        }
        catch (Exception e) {
            throw new RuntimeException("Finding the geo coordinate's domain topic failed (geoCoordId=" + geoCoordId + ")", e);
        }
    }

    @Override
    public GeoCoordinate getGeoCoordinate(Topic geoTopic) {
        try {
            Topic geoCoordTopic = this.getGeoCoordinateTopic(geoTopic);
            if (geoCoordTopic != null) {
                return this.geoCoordinate(geoCoordTopic);
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException("Getting the geo coordinate failed (geoTopic=" + geoTopic + ")", e);
        }
    }

    @Override
    public GeoCoordinate geoCoordinate(Topic geoCoordTopic) {
        ChildTopics childTopics = geoCoordTopic.getChildTopics();
        return new GeoCoordinate(childTopics.getDouble("dmx.geomaps.longitude"), childTopics.getDouble("dmx.geomaps.latitude"));
    }

    @Override
    @PUT
    @Path(value="/{id}/topic/{geo_coord_id}")
    @Transactional
    public void addCoordinateToGeomap(@PathParam(value="id") long geomapId, @PathParam(value="geo_coord_id") long geoCoordId) {
        this.logger.info("### Adding geo coordinate topic " + geoCoordId + " to geomap " + geomapId);
        AssociationModel model = this.mf.newAssociationModel("dmx.geomaps.geotopic_mapcontext", (RoleModel)this.mf.newTopicRoleModel(geomapId, "dmx.core.default"), (RoleModel)this.mf.newTopicRoleModel(geoCoordId, "dmx.topicmaps.topicmap_topic"));
        this.dmx.createAssociation(model);
    }

    @Override
    @PUT
    @Path(value="/{id}/center/{lon}/{lat}/zoom/{zoom}")
    @Transactional
    public void setGeomapState(@PathParam(value="id") long geomapId, @PathParam(value="lon") double lon, @PathParam(value="lat") double lat, @PathParam(value="zoom") int zoom) {
        ChildTopicsModel geomapState = this.mf.newChildTopicsModel().put("dmx.topicmaps.state", this.mf.newChildTopicsModel().put("dmx.topicmaps.translation", this.mf.newChildTopicsModel().put("dmx.topicmaps.translation_x", (Object)lon).put("dmx.topicmaps.translation_y", (Object)lat)).put("dmx.topicmaps.zoom_level", (Object)zoom));
        this.dmx.updateTopic(this.mf.newTopicModel(geomapId, geomapState));
    }

    @Override
    @GET
    @Path(value="/distance")
    public double getDistance(@QueryParam(value="coord1") GeoCoordinate coord1, @QueryParam(value="coord2") GeoCoordinate coord2) {
        double lonDiff = Math.toRadians(coord2.lon - coord1.lon);
        double latDiff = Math.toRadians(coord2.lat - coord1.lat);
        double latMean = Math.toRadians((coord1.lat + coord2.lat) / 2.0);
        return 6371.009 * Math.sqrt(Math.pow(latDiff, 2.0) + Math.pow(Math.cos(latMean) * lonDiff, 2.0));
    }

    @Override
    public <V> V runWithoutGeocoding(Callable<V> callable) throws Exception {
        return (V)this.contextTracker.run(callable);
    }

    public void init() {
        this.topicmapsService.registerTopicmapRenderer((TopicmapRenderer)new GeomapRenderer());
    }

    public void postCreateTopic(Topic topic) {
        if (topic.getTypeUri().equals("dmx.contacts.address") && !this.abortGeocoding(topic)) {
            this.facetsService.addFacetTypeToTopic(topic.getId(), "dmx.geomaps.geo_coordinate_facet");
            Address address = new Address(topic);
            if (!address.isEmpty()) {
                this.logger.info("### New " + address);
                this.geocodeAndStoreFacet(address, topic);
            } else {
                this.logger.info("New empty address");
            }
        }
    }

    public void postUpdateTopic(Topic topic, TopicModel updateModel, TopicModel oldTopic) {
        if (topic.getTypeUri().equals("dmx.contacts.address")) {
            throw new RuntimeException("postUpdateTopic() invoked for an Address topic: " + topic);
        }
    }

    public void preSendTopic(Topic topic) {
        Topic address = topic.findChildTopic("dmx.contacts.address");
        if (address != null) {
            String operation = "Enriching address " + address.getId() + " with its geo coordinate";
            Topic geoCoordTopic = this.getGeoCoordinateTopic(address);
            if (geoCoordTopic != null) {
                this.logger.info(operation);
                address.getChildTopics().getModel().put("dmx.geomaps.geo_coordinate", geoCoordTopic.getModel());
            } else {
                this.logger.info(operation + " SKIPPED -- no geo coordinate in DB");
            }
        }
    }

    private Topic getGeoCoordinateTopic(Topic geoTopic) {
        RelatedTopic geoCoordTopic = this.facetsService.getFacet((DMXObject)geoTopic, "dmx.geomaps.geo_coordinate_facet");
        return geoCoordTopic != null ? geoCoordTopic.loadChildTopics() : null;
    }

    private void geocodeAndStoreFacet(Address address, Topic topic) {
        try {
            GeoCoordinate geoCoord = address.geocode();
            this.storeGeoCoordinate(topic, geoCoord);
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Adding geo coordinate to " + address + " failed", e);
        }
    }

    private void storeGeoCoordinate(Topic address, GeoCoordinate geoCoord) {
        try {
            this.logger.info("Storing geo coordinate (" + geoCoord + ") of address topic " + address.getId());
            this.facetsService.updateFacet((DMXObject)address, "dmx.geomaps.geo_coordinate_facet", this.mf.newFacetValueModel("dmx.geomaps.geo_coordinate").put(this.mf.newChildTopicsModel().put("dmx.geomaps.longitude", (Object)geoCoord.lon).put("dmx.geomaps.latitude", (Object)geoCoord.lat)));
        }
        catch (Exception e) {
            throw new RuntimeException("Storing geo coordinate of address " + address.getId() + " failed", e);
        }
    }

    private boolean abortGeocoding(Topic address) {
        return this.abortGeocodingByCookie(address) || this.abortGeocodingByExcecutionContext(address);
    }

    private boolean abortGeocodingByCookie(Topic address) {
        boolean abort = false;
        Cookies cookies = Cookies.get();
        if (cookies.has(COOKIE_NO_GEOCODING)) {
            String value = cookies.get(COOKIE_NO_GEOCODING);
            if (!value.equals("false") && !value.equals("true")) {
                throw new RuntimeException("\"" + value + "\" is an unexpected value for the \"" + COOKIE_NO_GEOCODING + "\" cookie (expected are \"false\" or \"true\")");
            }
            abort = value.equals("true");
            if (abort) {
                this.logger.info("Geocoding for Address topic " + address.getId() + " SUPPRESSED -- \"" + COOKIE_NO_GEOCODING + "\" cookie detected");
            }
        }
        return abort;
    }

    private boolean abortGeocodingByExcecutionContext(Topic address) {
        boolean abort = this.contextTracker.runsInTrackedContext();
        if (abort) {
            this.logger.info("Geocoding for Address topic " + address.getId() + " SUPPRESSED -- runWithoutGeocoding() context detected");
        }
        return abort;
    }

    private class Address {
        String street;
        String postalCode;
        String city;
        String country;

        Address(ChildTopicsModel address) {
            this.street = address.getString("dmx.contacts.street", "");
            this.postalCode = address.getString("dmx.contacts.postal_code", "");
            this.city = address.getString("dmx.contacts.city", "");
            this.country = address.getString("dmx.contacts.country", "");
        }

        Address(Topic address) {
            ChildTopics childs = address.getChildTopics();
            String st = childs.getStringOrNull("dmx.contacts.street");
            String po = childs.getStringOrNull("dmx.contacts.postal_code");
            String ci = childs.getStringOrNull("dmx.contacts.city");
            String co = childs.getStringOrNull("dmx.contacts.country");
            this.street = st != null ? st : "";
            this.postalCode = po != null ? po : "";
            this.city = ci != null ? ci : "";
            this.country = co != null ? co : "";
        }

        GeoCoordinate geocode() {
            URL url = null;
            try {
                String address = this.street + ", " + this.postalCode + " " + this.city + ", " + this.country;
                url = new URL(String.format(GeomapsPlugin.GEOCODER_URL, JavaUtils.encodeURIComponent((String)address)));
                GeomapsPlugin.this.logger.info("Geocoding \"" + address + "\"\n    url=\"" + url + "\"");
                JSONObject response = new JSONObject(JavaUtils.readTextURL((URL)url));
                String status = response.getString("status");
                if (!status.equals("OK")) {
                    throw new RuntimeException(status);
                }
                JSONObject location = response.getJSONArray("results").getJSONObject(0).getJSONObject("geometry").getJSONObject("location");
                double lng = location.getDouble("lng");
                double lat = location.getDouble("lat");
                GeoCoordinate geoCoord = new GeoCoordinate(lng, lat);
                GeomapsPlugin.this.logger.info("=> " + geoCoord);
                return geoCoord;
            }
            catch (Exception e) {
                throw new RuntimeException("Geocoding failed (url=\"" + url + "\")", e);
            }
        }

        boolean isEmpty() {
            return this.street.equals("") && this.postalCode.equals("") && this.city.equals("") && this.country.equals("");
        }

        String changeReport(Address oldAddr) {
            StringBuilder report = new StringBuilder();
            if (!this.street.equals(oldAddr.street)) {
                report.append("\n    Street: \"" + oldAddr.street + "\" -> \"" + this.street + "\"");
            }
            if (!this.postalCode.equals(oldAddr.postalCode)) {
                report.append("\n    Postal Code: \"" + oldAddr.postalCode + "\" -> \"" + this.postalCode + "\"");
            }
            if (!this.city.equals(oldAddr.city)) {
                report.append("\n    City: \"" + oldAddr.city + "\" -> \"" + this.city + "\"");
            }
            if (!this.country.equals(oldAddr.country)) {
                report.append("\n    Country: \"" + oldAddr.country + "\" -> \"" + this.country + "\"");
            }
            return report.toString();
        }

        public boolean equals(Object o) {
            if (o instanceof Address) {
                Address addr = (Address)o;
                return this.street.equals(addr.street) && this.postalCode.equals(addr.postalCode) && this.city.equals(addr.city) && this.country.equals(addr.country);
            }
            return false;
        }

        public int hashCode() {
            return (this.street + this.postalCode + this.city + this.country).hashCode();
        }

        public String toString() {
            return "address (street=\"" + this.street + "\", postalCode=\"" + this.postalCode + "\", city=\"" + this.city + "\", country=\"" + this.country + "\")";
        }
    }
}

