/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.impl;

import org.codehaus.jettison.json.JSONObject;
import systems.dmx.core.Role;
import systems.dmx.core.impl.AssociationModelImpl;
import systems.dmx.core.impl.PersistenceLayer;
import systems.dmx.core.impl.RelatedTopicModelImpl;
import systems.dmx.core.impl.RoleModelImpl;
import systems.dmx.core.impl.TopicModelImpl;
import systems.dmx.core.impl.TopicRoleImpl;
import systems.dmx.core.model.AssociationModel;
import systems.dmx.core.model.RoleModel;
import systems.dmx.core.model.SimpleValue;
import systems.dmx.core.model.TopicRoleModel;

class TopicRoleModelImpl
extends RoleModelImpl
implements TopicRoleModel {
    private String topicUri;
    private boolean topicIdentifiedByUri;

    TopicRoleModelImpl(long topicId, String roleTypeUri, PersistenceLayer pl) {
        super(topicId, roleTypeUri, pl);
        this.topicUri = null;
        this.topicIdentifiedByUri = false;
    }

    TopicRoleModelImpl(String topicUri, String roleTypeUri, PersistenceLayer pl) {
        super(-1L, roleTypeUri, pl);
        this.topicUri = topicUri;
        this.topicIdentifiedByUri = true;
    }

    @Override
    public long getPlayerId() {
        if (this.topicIdentifiedByUri) {
            throw new IllegalStateException("The topic is not identified by ID but by URI (" + this + ")");
        }
        return super.getPlayerId();
    }

    @Override
    public String getTopicUri() {
        if (!this.topicIdentifiedByUri) {
            throw new IllegalStateException("The topic is not identified by URI but by ID (" + this + ")");
        }
        return this.topicUri;
    }

    @Override
    public boolean topicIdentifiedByUri() {
        return this.topicIdentifiedByUri;
    }

    @Override
    public boolean refsSameObject(RoleModel model) {
        TopicRoleModel topicRole;
        if (model instanceof TopicRoleModel && (topicRole = (TopicRoleModel)model).topicIdentifiedByUri() == this.topicIdentifiedByUri) {
            if (this.topicIdentifiedByUri) {
                return topicRole.getTopicUri().equals(this.topicUri);
            }
            return topicRole.getPlayerId() == this.playerId;
        }
        return false;
    }

    @Override
    public JSONObject toJSON() {
        try {
            JSONObject o = new JSONObject();
            if (this.topicIdentifiedByUri) {
                o.put("topicUri", (Object)this.topicUri);
            } else {
                o.put("topicId", this.playerId);
            }
            o.put("roleTypeUri", (Object)this.roleTypeUri);
            return o;
        }
        catch (Exception e) {
            throw new RuntimeException("Serialization failed", e);
        }
    }

    @Override
    Role instantiate(AssociationModelImpl assoc) {
        return new TopicRoleImpl(this, assoc);
    }

    @Override
    RelatedTopicModelImpl getPlayer(AssociationModelImpl assoc) {
        TopicModelImpl topic = this.topicIdentifiedByUri ? this.pl.fetchTopic("uri", new SimpleValue(this.topicUri)) : this.pl.fetchTopic(this.playerId);
        return this.mf.newRelatedTopicModel(topic, (AssociationModel)assoc);
    }
}

