/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.webclient;

import java.awt.Desktop;
import java.net.URI;
import java.util.logging.Logger;
import systems.dmx.core.AssociationType;
import systems.dmx.core.DMXType;
import systems.dmx.core.JSONEnabled;
import systems.dmx.core.RelatedAssociation;
import systems.dmx.core.RelatedTopic;
import systems.dmx.core.Topic;
import systems.dmx.core.TopicType;
import systems.dmx.core.ViewConfiguration;
import systems.dmx.core.model.AssociationDefinitionModel;
import systems.dmx.core.model.AssociationTypeModel;
import systems.dmx.core.model.TopicModel;
import systems.dmx.core.model.TopicTypeModel;
import systems.dmx.core.model.TypeModel;
import systems.dmx.core.model.ViewConfigurationModel;
import systems.dmx.core.osgi.PluginActivator;
import systems.dmx.core.service.Directive;
import systems.dmx.core.service.Directives;
import systems.dmx.core.service.event.AllPluginsActiveListener;
import systems.dmx.core.service.event.IntroduceAssociationTypeListener;
import systems.dmx.core.service.event.IntroduceTopicTypeListener;
import systems.dmx.core.service.event.PostUpdateTopicListener;
import systems.dmx.core.service.event.PreCreateAssociationTypeListener;
import systems.dmx.core.service.event.PreCreateTopicTypeListener;

public class WebclientPlugin
extends PluginActivator
implements AllPluginsActiveListener,
IntroduceTopicTypeListener,
IntroduceAssociationTypeListener,
PreCreateTopicTypeListener,
PreCreateAssociationTypeListener,
PostUpdateTopicListener {
    private static final String VIEW_CONFIG_LABEL = "View Configuration";
    private boolean hasWebclientLaunched = false;
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());

    public void allPluginsActive() {
        String webclientUrl = this.getWebclientUrl();
        if (this.hasWebclientLaunched) {
            this.logger.info("### Launching webclient (url=\"" + webclientUrl + "\") SKIPPED -- already launched");
            return;
        }
        try {
            this.logger.info("### Launching webclient (url=\"" + webclientUrl + "\")");
            Desktop.getDesktop().browse(new URI(webclientUrl));
            this.hasWebclientLaunched = true;
        }
        catch (Exception e) {
            this.logger.warning("### Launching webclient failed (" + e + ")");
            this.logger.warning("### To launch it manually: " + webclientUrl);
        }
    }

    public void preCreateTopicType(TopicTypeModel model) {
        this.addDefaultViewConfig((TypeModel)model);
    }

    public void preCreateAssociationType(AssociationTypeModel model) {
        this.addDefaultViewConfig((TypeModel)model);
    }

    public void postUpdateTopic(Topic topic, TopicModel updateModel, TopicModel oldTopic) {
        if (topic.getTypeUri().equals("dmx.webclient.view_config")) {
            this.setDefaultConfigTopicLabel(topic);
            this.updateType(topic);
        }
    }

    public void introduceTopicType(TopicType topicType) {
        this.setViewConfigLabel(topicType.getViewConfig());
    }

    public void introduceAssociationType(AssociationType assocType) {
        this.setViewConfigLabel(assocType.getViewConfig());
    }

    private void updateType(Topic viewConfig) {
        String typeUri;
        RelatedTopic type = viewConfig.getRelatedTopic("dmx.core.composition", "dmx.core.view_config", "dmx.core.type", null);
        long assocDefId = -1L;
        if (type == null) {
            RelatedAssociation assocDef = viewConfig.getRelatedAssociation("dmx.core.composition", "dmx.core.view_config", "dmx.core.assoc_def", null);
            if (assocDef == null) {
                throw new RuntimeException("Orphaned view config: " + viewConfig);
            }
            type = (Topic)assocDef.getPlayer("dmx.core.parent_type");
            assocDefId = assocDef.getId();
        }
        if ((typeUri = type.getTypeUri()).equals("dmx.core.topic_type") || typeUri.equals("dmx.core.meta_type")) {
            this.updateType((DMXType)this.dmx.getTopicType(type.getUri()), assocDefId, viewConfig, Directive.UPDATE_TOPIC_TYPE);
        } else if (typeUri.equals("dmx.core.assoc_type")) {
            this.updateType((DMXType)this.dmx.getAssociationType(type.getUri()), assocDefId, viewConfig, Directive.UPDATE_ASSOCIATION_TYPE);
        } else {
            throw new RuntimeException("View config " + viewConfig.getId() + " is associated unexpectedly, type=" + type + ", assocDefId=" + assocDefId + ", viewConfig=" + viewConfig);
        }
    }

    private void updateType(DMXType type, long assocDefId, Topic viewConfig, Directive dir) {
        this.logger.info("### Updating view config of type \"" + type.getUri() + "\" (assocDefId=" + assocDefId + ")");
        this.updateViewConfig(type, assocDefId, viewConfig);
        Directives.get().add(dir, (JSONEnabled)type);
    }

    private void updateViewConfig(DMXType type, long assocDefId, Topic viewConfig) {
        ViewConfigurationModel vcm = assocDefId == -1L ? type.getModel().getViewConfig() : this.getAssocDef(type.getModel(), assocDefId).getViewConfig();
        vcm.updateConfigTopic(viewConfig.getModel());
    }

    private void setViewConfigLabel(ViewConfiguration viewConfig) {
        for (Topic configTopic : viewConfig.getConfigTopics()) {
            this.setDefaultConfigTopicLabel(configTopic);
        }
    }

    private void setDefaultConfigTopicLabel(Topic viewConfig) {
        viewConfig.setSimpleValue(VIEW_CONFIG_LABEL);
    }

    private void addDefaultViewConfig(TypeModel typeModel) {
        ViewConfigurationModel viewConfig = typeModel.getViewConfig();
        TopicModel configTopic = viewConfig.getConfigTopic("dmx.webclient.view_config");
        if (configTopic == null) {
            viewConfig.addConfigTopic(this.mf.newTopicModel("dmx.webclient.view_config"));
        }
    }

    private String getWebclientUrl() {
        String port;
        String protocol;
        boolean isHttpsEnabled = Boolean.getBoolean("org.apache.felix.https.enable");
        if (isHttpsEnabled) {
            protocol = "https";
            port = System.getProperty("org.osgi.service.http.port.secure");
        } else {
            protocol = "http";
            port = System.getProperty("org.osgi.service.http.port");
        }
        return protocol + "://localhost:" + port + "/systems.dmx.webclient/";
    }

    private AssociationDefinitionModel getAssocDef(TypeModel type, long assocDefId) {
        for (AssociationDefinitionModel assocDef : type.getAssocDefs()) {
            if (assocDef.getId() != assocDefId) continue;
            return assocDef;
        }
        throw new RuntimeException("Assoc def " + assocDefId + " not found in type \"" + type.getUri() + "\"");
    }
}

