/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import systems.dmx.core.JSONEnabled;
import systems.dmx.core.impl.AssociationDefinitionModelImpl;
import systems.dmx.core.impl.AssociationModelImpl;
import systems.dmx.core.impl.DMXObjectModelImpl;
import systems.dmx.core.impl.DMXTypeImpl;
import systems.dmx.core.impl.TopicModelImpl;
import systems.dmx.core.impl.ViewConfigurationModelImpl;
import systems.dmx.core.model.AssociationDefinitionModel;
import systems.dmx.core.model.AssociationModel;
import systems.dmx.core.model.DMXObjectModel;
import systems.dmx.core.model.TypeModel;
import systems.dmx.core.model.ViewConfigurationModel;
import systems.dmx.core.service.Directive;
import systems.dmx.core.service.Directives;
import systems.dmx.core.util.SequencedHashMap;

class TypeModelImpl
extends TopicModelImpl
implements TypeModel {
    String dataTypeUri;
    SequencedHashMap<String, AssociationDefinitionModelImpl> assocDefs;
    ViewConfigurationModelImpl viewConfig;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    TypeModelImpl(TopicModelImpl typeTopic, String dataTypeUri, List<AssociationDefinitionModel> assocDefs, ViewConfigurationModelImpl viewConfig) {
        super(typeTopic);
        this.dataTypeUri = dataTypeUri;
        this.assocDefs = this.toMap(assocDefs);
        this.viewConfig = viewConfig;
    }

    TypeModelImpl(TypeModelImpl type) {
        super(type);
        this.dataTypeUri = type.getDataTypeUri();
        this.assocDefs = this.toMap(type.getAssocDefs());
        this.viewConfig = type.getViewConfig();
    }

    @Override
    public String getDataTypeUri() {
        return this.dataTypeUri;
    }

    @Override
    public void setDataTypeUri(String dataTypeUri) {
        this.dataTypeUri = dataTypeUri;
    }

    public Collection<AssociationDefinitionModelImpl> getAssocDefs() {
        return this.assocDefs.values();
    }

    @Override
    public AssociationDefinitionModelImpl getAssocDef(String assocDefUri) {
        return this.getAssocDefOrThrow(assocDefUri);
    }

    @Override
    public boolean hasAssocDef(String assocDefUri) {
        return this._getAssocDef(assocDefUri) != null;
    }

    @Override
    public TypeModel addAssocDef(AssociationDefinitionModel assocDef) {
        return this.addAssocDefBefore(assocDef, null);
    }

    @Override
    public TypeModel addAssocDefBefore(AssociationDefinitionModel assocDef, String beforeAssocDefUri) {
        try {
            String assocDefUri = assocDef.getAssocDefUri();
            AssociationDefinitionModelImpl existing = this._getAssocDef(assocDefUri);
            if (existing != null) {
                throw new RuntimeException("Type \"" + this.uri + "\" has a \"" + assocDefUri + "\" assoc def already");
            }
            this.assocDefs.putBefore(assocDefUri, (AssociationDefinitionModelImpl)assocDef, beforeAssocDefUri);
            return this;
        }
        catch (Exception e) {
            throw new RuntimeException("Adding assoc def \"" + assocDef.getAssocDefUri() + "\" to type \"" + this.uri + "\" failed (assocDef=" + assocDef + ", beforeAssocDefUri=\"" + beforeAssocDefUri + "\")", e);
        }
    }

    @Override
    public AssociationDefinitionModel removeAssocDef(String assocDefUri) {
        try {
            AssociationDefinitionModel assocDef = (AssociationDefinitionModel)this.assocDefs.remove(assocDefUri);
            if (assocDef == null) {
                throw new RuntimeException("Assoc def \"" + assocDefUri + "\" not found in " + this.assocDefs.keySet());
            }
            return assocDef;
        }
        catch (Exception e) {
            throw new RuntimeException("Removing assoc def \"" + assocDefUri + "\" from type \"" + this.uri + "\" failed", e);
        }
    }

    @Override
    public ViewConfigurationModelImpl getViewConfig() {
        return this.viewConfig;
    }

    @Override
    public Object getViewConfigValue(String configTypeUri, String childTypeUri) {
        return this.viewConfig.getConfigValue(configTypeUri, childTypeUri);
    }

    @Override
    public void setViewConfig(ViewConfigurationModel viewConfig) {
        this.viewConfig = (ViewConfigurationModelImpl)viewConfig;
    }

    @Override
    public Iterator<String> iterator() {
        return this.assocDefs.keySet().iterator();
    }

    @Override
    public JSONObject toJSON() {
        try {
            return super.toJSON().put("dataTypeUri", (Object)this.dataTypeUri).put("assocDefs", (Object)this.toJSONArray(this.assocDefs.values())).put("viewConfigTopics", (Object)this.viewConfig.toJSONArray());
        }
        catch (Exception e) {
            throw new RuntimeException("Serialization failed", e);
        }
    }

    @Override
    public TypeModelImpl clone() {
        try {
            TypeModelImpl model = (TypeModelImpl)super.clone();
            model.assocDefs = (SequencedHashMap)model.assocDefs.clone();
            return model;
        }
        catch (Exception e) {
            throw new RuntimeException("Cloning a TypeModel failed", e);
        }
    }

    @Override
    DMXTypeImpl instantiate() {
        throw new UnsupportedOperationException();
    }

    List<? extends DMXObjectModelImpl> getAllInstances() {
        throw new UnsupportedOperationException();
    }

    Directive getUpdateTypeDirective() {
        throw new UnsupportedOperationException();
    }

    Directive getDeleteTypeDirective() {
        throw new UnsupportedOperationException();
    }

    @Override
    void preUpdate(DMXObjectModel updateModel) {
        if (this.uriChange(updateModel.getUri(), this.uri)) {
            this.removeFromTypeCache();
        }
    }

    @Override
    void postUpdate(DMXObjectModel updateModel, DMXObjectModel oldObject) {
        if (this.uriChange(updateModel.getUri(), oldObject.getUri())) {
            this.putInTypeCache();
        }
        this.updateType((TypeModelImpl)updateModel);
        this.addUpdateTypeDirective();
    }

    @Override
    void preDelete() {
        String assocDefUri;
        int size = this.getAllInstances().size();
        if (size > 0) {
            throw new RuntimeException(size + " \"" + this.value + "\" instances still exist");
        }
        while ((assocDefUri = this.getFirstAssocDefUri()) != null) {
            this._getAssocDef(assocDefUri).delete();
        }
    }

    @Override
    void postDelete() {
        super.postDelete();
        this.removeFromTypeCache();
    }

    final void updateDataTypeUri(String dataTypeUri) {
        this.setDataTypeUri(dataTypeUri);
        this.storeDataTypeUri();
    }

    final void _addAssocDefBefore(AssociationDefinitionModelImpl assocDef, String beforeAssocDefUri) {
        try {
            long lastAssocDefId = this.lastAssocDefId();
            this.addAssocDefBefore(assocDef, beforeAssocDefUri);
            this.pl.typeStorage.storeAssociationDefinition(assocDef);
            long beforeAssocDefId = beforeAssocDefUri != null ? this.getAssocDef(beforeAssocDefUri).getId() : -1L;
            long firstAssocDefId = this.firstAssocDefId();
            this.pl.typeStorage.addAssocDefToSequence(this.getId(), assocDef.getId(), beforeAssocDefId, firstAssocDefId, lastAssocDefId);
        }
        catch (Exception e) {
            throw new RuntimeException("Adding assoc def \"" + assocDef.getAssocDefUri() + "\" to type \"" + this.uri + "\" failed (assocDef=" + assocDef + ", beforeAssocDefUri=\"" + beforeAssocDefUri + "\")", e);
        }
    }

    final void _removeAssocDef(String assocDefUri) {
        this.getAssocDef(assocDefUri).delete();
    }

    final void _addAssocDef(AssociationModelImpl assoc) {
        this._addAssocDefBefore(this.pl.typeStorage.newAssociationDefinition(assoc), null);
        this.addUpdateTypeDirective();
    }

    final void _updateAssocDef(AssociationModel assoc, AssociationModel oldAssoc) {
        String oldAssocDefUri;
        String[] assocDefUris = this.findAssocDefUris(assoc.getId());
        AssociationDefinitionModelImpl assocDef = this.getAssocDef(assocDefUris[0]);
        if (assoc == assocDef) {
            oldAssocDefUri = ((AssociationDefinitionModel)oldAssoc).getAssocDefUri();
        } else {
            oldAssocDefUri = assocDef.getAssocDefUri();
            assocDef.setTypeUri(assoc.getTypeUri());
            assocDef.setSimpleValue(assoc.getSimpleValue());
            assocDef.setChildTopicsModel(assoc.getChildTopicsModel());
        }
        if (!assocDef.getAssocDefUri().equals(oldAssocDefUri)) {
            this.rehashAssocDef(oldAssocDefUri, assocDefUris[1]);
        }
        this.addUpdateTypeDirective();
    }

    final void _removeAssocDefFromMemoryAndRebuildSequence(AssociationModel assoc) {
        String[] assocDefUris = this.findAssocDefUris(assoc.getId());
        String assocDefUri = this.getAssocDef(assocDefUris[0]).getAssocDefUri();
        this.removeAssocDef(assocDefUri);
        this.pl.typeStorage.rebuildSequence(this);
        this.addUpdateTypeDirective();
    }

    final List<String> getIdentityAttrs() {
        try {
            ArrayList<String> identityAttrs = new ArrayList<String>();
            for (String assocDefUri : this) {
                if (!this.getAssocDef(assocDefUri).isIdentityAttr()) continue;
                identityAttrs.add(assocDefUri);
            }
            return identityAttrs;
        }
        catch (Exception e) {
            throw new RuntimeException("Calculating the identity configuration for type \"" + this.uri + "\" failed", e);
        }
    }

    final List<String> getLabelAssocDefUris() {
        List<String> labelConfig = this.getLabelConfig();
        if (labelConfig.size() > 0) {
            return labelConfig;
        }
        ArrayList<String> assocDefUris = new ArrayList<String>();
        Iterator<AssociationDefinitionModelImpl> i = this.getAssocDefs().iterator();
        if (i.hasNext()) {
            assocDefUris.add(((AssociationDefinitionModel)i.next()).getAssocDefUri());
        }
        return assocDefUris;
    }

    final List<String> getLabelConfig() {
        try {
            ArrayList<String> labelConfig = new ArrayList<String>();
            for (String assocDefUri : this) {
                if (!this.getAssocDef(assocDefUri).includeInLabel()) continue;
                labelConfig.add(assocDefUri);
            }
            return labelConfig;
        }
        catch (Exception e) {
            throw new RuntimeException("Calculating the label configuration for type \"" + this.uri + "\" failed", e);
        }
    }

    final <M extends TypeModelImpl> M filterReadableAssocDefs() {
        try {
            Iterator<String> i = this.iterator();
            while (i.hasNext()) {
                String assocDefUri = i.next();
                if (this._getAssocDef(assocDefUri).isReadable()) continue;
                i.remove();
            }
            return (M)this;
        }
        catch (Exception e) {
            throw new RuntimeException("Filtering readable assoc defs of type \"" + this.uri + "\" failed", e);
        }
    }

    private void addUpdateTypeDirective() {
        Directives.get().add(this.getUpdateTypeDirective(), this.instantiate());
    }

    private void updateType(TypeModelImpl updateModel) {
        this._updateDataTypeUri(updateModel.getDataTypeUri());
        this._updateAssocDefs(updateModel.getAssocDefs());
        this._updateSequence(updateModel.getAssocDefs());
    }

    private void _updateDataTypeUri(String newDataTypeUri) {
        String dataTypeUri;
        if (newDataTypeUri != null && !(dataTypeUri = this.getDataTypeUri()).equals(newDataTypeUri)) {
            this.logger.info("### Changing data type URI: \"" + dataTypeUri + "\" -> \"" + newDataTypeUri + "\"");
            this.updateDataTypeUri(newDataTypeUri);
        }
    }

    private void _updateAssocDefs(Collection<AssociationDefinitionModelImpl> newAssocDefs) {
        for (AssociationDefinitionModelImpl assocDef : newAssocDefs) {
            String[] assocDefUris = this.findAssocDefUris(assocDef.getId());
            this.getAssocDef(assocDefUris[0]).update(assocDef);
        }
    }

    private void _updateSequence(Collection<AssociationDefinitionModelImpl> newAssocDefs) {
        try {
            this.logger.info("##### Updating sequence (" + newAssocDefs.size() + "/" + this.getAssocDefs().size() + " assoc defs)");
            this.rehashAssocDefs(newAssocDefs);
            this.pl.typeStorage.rebuildSequence(this);
        }
        catch (Exception e) {
            throw new RuntimeException("Updating the assoc def sequence failed", e);
        }
    }

    private void storeDataTypeUri() {
        this.getRelatedTopic("dmx.core.composition", "dmx.core.type", "dmx.core.default", "dmx.core.data_type").getRelatingAssociation().delete();
        this.pl.typeStorage.storeDataType(this.uri, this.dataTypeUri);
    }

    private String[] findAssocDefUris(long assocDefId) {
        if (assocDefId == -1L) {
            throw new IllegalArgumentException("findAssocDefUris() called with assocDefId=-1");
        }
        String[] assocDefUris = new String[2];
        Iterator<String> i = this.iterator();
        while (i.hasNext()) {
            String assocDefUri = i.next();
            long _assocDefId = this.checkAssocDefId(this._getAssocDef(assocDefUri));
            if (_assocDefId != assocDefId) continue;
            assocDefUris[0] = assocDefUri;
            if (!i.hasNext()) break;
            assocDefUris[1] = i.next();
            break;
        }
        if (assocDefUris[0] == null) {
            throw new RuntimeException("Assoc def " + assocDefId + " not found in assoc defs of type \"" + this.uri + "\" (" + this.assocDefs.keySet() + ")");
        }
        return assocDefUris;
    }

    private boolean hasSameAssocDefSequence(Collection<? extends AssociationDefinitionModel> assocDefs) {
        Collection<AssociationDefinitionModelImpl> _assocDefs = this.getAssocDefs();
        if (assocDefs.size() != _assocDefs.size()) {
            return false;
        }
        Iterator<? extends AssociationDefinitionModel> i = assocDefs.iterator();
        for (AssociationDefinitionModel associationDefinitionModel : _assocDefs) {
            long _assocDefId;
            AssociationDefinitionModel assocDef = i.next();
            long assocDefId = this.checkAssocDefId(assocDef);
            if (assocDefId == (_assocDefId = this.checkAssocDefId(associationDefinitionModel))) continue;
            return false;
        }
        return true;
    }

    private void rehashAssocDefs(Collection<AssociationDefinitionModelImpl> newAssocDefs) {
        for (AssociationDefinitionModel associationDefinitionModel : newAssocDefs) {
            this.rehashAssocDef(associationDefinitionModel.getAssocDefUri(), null);
        }
    }

    private void rehashAssocDef(String assocDefUri, String beforeAssocDefUri) {
        AssociationDefinitionModel assocDef = this.removeAssocDef(assocDefUri);
        this.logger.info("Rehashing assoc def \"" + assocDefUri + "\" -> \"" + assocDef.getAssocDefUri() + "\" (put " + (beforeAssocDefUri != null ? "before \"" + beforeAssocDefUri + "\"" : "at end") + ")");
        this.addAssocDefBefore(assocDef, beforeAssocDefUri);
    }

    private AssociationDefinitionModelImpl getAssocDefOrThrow(String assocDefUri) {
        AssociationDefinitionModelImpl assocDef = this._getAssocDef(assocDefUri);
        if (assocDef == null) {
            throw new RuntimeException("Assoc def \"" + assocDefUri + "\" not found in " + this.assocDefs.keySet());
        }
        return assocDef;
    }

    private AssociationDefinitionModelImpl _getAssocDef(String assocDefUri) {
        return (AssociationDefinitionModelImpl)this.assocDefs.get(assocDefUri);
    }

    private long lastAssocDefId() {
        long lastAssocDefId = -1L;
        for (AssociationDefinitionModel associationDefinitionModel : this.getAssocDefs()) {
            lastAssocDefId = associationDefinitionModel.getId();
        }
        return lastAssocDefId;
    }

    private long firstAssocDefId() {
        return this.getAssocDefs().iterator().next().getId();
    }

    private String getFirstAssocDefUri() {
        Iterator<String> i = this.iterator();
        return i.hasNext() ? i.next() : null;
    }

    private long checkAssocDefId(AssociationDefinitionModel assocDef) {
        long assocDefId = assocDef.getId();
        if (assocDefId == -1L) {
            throw new RuntimeException("The assoc def ID is uninitialized (-1): " + assocDef);
        }
        return assocDefId;
    }

    private SequencedHashMap<String, AssociationDefinitionModelImpl> toMap(Collection<? extends AssociationDefinitionModel> assocDefs) {
        SequencedHashMap<String, AssociationDefinitionModelImpl> _assocDefs = new SequencedHashMap<String, AssociationDefinitionModelImpl>();
        for (AssociationDefinitionModel associationDefinitionModel : assocDefs) {
            _assocDefs.put(associationDefinitionModel.getAssocDefUri(), (AssociationDefinitionModelImpl)associationDefinitionModel);
        }
        return _assocDefs;
    }

    private void putInTypeCache() {
        this.pl.typeStorage.putInTypeCache(this);
    }

    private void removeFromTypeCache() {
        this.pl.typeStorage.removeFromTypeCache(this.uri);
        Directive dir = this.getDeleteTypeDirective();
        Directives.get().add(dir, new JSONWrapper("uri", this.uri));
    }

    private JSONArray toJSONArray(Collection<? extends AssociationDefinitionModel> assocDefs) {
        JSONArray _assocDefs = new JSONArray();
        for (AssociationDefinitionModel associationDefinitionModel : assocDefs) {
            _assocDefs.put((Object)associationDefinitionModel.toJSON());
        }
        return _assocDefs;
    }

    private static final class JSONWrapper
    implements JSONEnabled {
        private JSONObject wrapped;

        private JSONWrapper(String key, Object value) {
            try {
                this.wrapped = new JSONObject();
                this.wrapped.put(key, value);
            }
            catch (Exception e) {
                throw new RuntimeException("Constructing a JSONWrapper failed", e);
            }
        }

        @Override
        public JSONObject toJSON() {
            return this.wrapped;
        }
    }
}

