/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import systems.dmx.core.impl.AssociationDefinitionModelImpl;
import systems.dmx.core.impl.AssociationModelImpl;
import systems.dmx.core.impl.AssociationTypeModelImpl;
import systems.dmx.core.impl.ChildTopicsModelImpl;
import systems.dmx.core.impl.DMXObjectModelImpl;
import systems.dmx.core.impl.ModelFactoryImpl;
import systems.dmx.core.impl.PersistenceLayer;
import systems.dmx.core.impl.RelatedAssociationModelImpl;
import systems.dmx.core.impl.RelatedTopicModelImpl;
import systems.dmx.core.impl.TopicModelImpl;
import systems.dmx.core.impl.TopicRoleModelImpl;
import systems.dmx.core.impl.TopicTypeModelImpl;
import systems.dmx.core.impl.TypeModelImpl;
import systems.dmx.core.impl.ViewConfigurationModelImpl;
import systems.dmx.core.model.AssociationDefinitionModel;
import systems.dmx.core.model.AssociationModel;
import systems.dmx.core.model.AssociationTypeModel;
import systems.dmx.core.model.RelatedTopicModel;
import systems.dmx.core.model.RoleModel;
import systems.dmx.core.model.SimpleValue;
import systems.dmx.core.model.TopicModel;
import systems.dmx.core.model.TopicTypeModel;
import systems.dmx.core.model.ViewConfigurationModel;
import systems.dmx.core.util.DMXUtils;

class TypeStorage {
    private Map<String, TypeModelImpl> typeCache = new HashMap<String, TypeModelImpl>();
    private EndlessRecursionDetection endlessRecursionDetection = new EndlessRecursionDetection();
    private PersistenceLayer pl;
    private ModelFactoryImpl mf;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    TypeStorage(PersistenceLayer pl) {
        this.pl = pl;
        this.mf = pl.mf;
    }

    TopicTypeModelImpl getTopicType(String topicTypeUri) {
        TopicTypeModelImpl topicType = (TopicTypeModelImpl)this.getType(topicTypeUri);
        return topicType != null ? topicType : this.fetchTopicType(topicTypeUri);
    }

    AssociationTypeModelImpl getAssociationType(String assocTypeUri) {
        AssociationTypeModelImpl assocType = (AssociationTypeModelImpl)this.getType(assocTypeUri);
        return assocType != null ? assocType : this.fetchAssociationType(assocTypeUri);
    }

    void putInTypeCache(TypeModelImpl type) {
        this.typeCache.put(type.uri, type);
    }

    void removeFromTypeCache(String typeUri) {
        this.logger.info("### Removing type \"" + typeUri + "\" from type cache");
        if (this.typeCache.remove(typeUri) == null) {
            throw new RuntimeException("Type \"" + typeUri + "\" not found in type cache");
        }
    }

    TypeModelImpl getType(String typeUri) {
        return this.typeCache.get(typeUri);
    }

    private TopicTypeModelImpl fetchTopicType(String topicTypeUri) {
        try {
            this.logger.info("Fetching topic type \"" + topicTypeUri + "\"");
            this.endlessRecursionDetection.check(topicTypeUri);
            TopicModelImpl typeTopic = this.pl.fetchTopic("uri", new SimpleValue(topicTypeUri));
            this.checkTopicType(topicTypeUri, typeTopic);
            long typeId = typeTopic.getId();
            String dataTypeUri = this.fetchDataTypeTopic(typeId, topicTypeUri, "topic type").getUri();
            List<AssociationDefinitionModel> assocDefs = this.fetchAssociationDefinitions(typeTopic);
            TopicTypeModel topicType = this.mf.newTopicTypeModel((TopicModel)typeTopic, dataTypeUri, (List)assocDefs, (ViewConfigurationModel)null);
            this.putInTypeCache((TypeModelImpl)((Object)topicType));
            ((TypeModelImpl)((Object)topicType)).setViewConfig(this.fetchTypeViewConfig(typeTopic));
            this.fetchAssocDefsViewConfig(assocDefs);
            TopicTypeModel topicTypeModel = topicType;
            return topicTypeModel;
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching topic type \"" + topicTypeUri + "\" failed", e);
        }
        finally {
            this.endlessRecursionDetection.reset(topicTypeUri);
        }
    }

    private AssociationTypeModelImpl fetchAssociationType(String assocTypeUri) {
        try {
            this.logger.info("Fetching association type \"" + assocTypeUri + "\"");
            this.endlessRecursionDetection.check(assocTypeUri);
            TopicModelImpl typeTopic = this.pl.fetchTopic("uri", new SimpleValue(assocTypeUri));
            this.checkAssociationType(assocTypeUri, typeTopic);
            long typeId = typeTopic.getId();
            String dataTypeUri = this.fetchDataTypeTopic(typeId, assocTypeUri, "association type").getUri();
            List<AssociationDefinitionModel> assocDefs = this.fetchAssociationDefinitions(typeTopic);
            AssociationTypeModel assocType = this.mf.newAssociationTypeModel((TopicModel)typeTopic, dataTypeUri, (List)assocDefs, (ViewConfigurationModel)null);
            this.putInTypeCache((TypeModelImpl)((Object)assocType));
            ((AssociationTypeModelImpl)assocType).setViewConfig(this.fetchTypeViewConfig(typeTopic));
            this.fetchAssocDefsViewConfig(assocDefs);
            AssociationTypeModel associationTypeModel = assocType;
            return associationTypeModel;
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching association type \"" + assocTypeUri + "\" failed", e);
        }
        finally {
            this.endlessRecursionDetection.reset(assocTypeUri);
        }
    }

    private void checkTopicType(String topicTypeUri, TopicModel typeTopic) {
        if (typeTopic == null) {
            throw new RuntimeException("Topic type \"" + topicTypeUri + "\" not found in DB");
        }
        if (!(typeTopic.getTypeUri().equals("dmx.core.topic_type") || typeTopic.getTypeUri().equals("dmx.core.meta_type") || typeTopic.getTypeUri().equals("dmx.core.meta_meta_type"))) {
            throw new RuntimeException("URI \"" + topicTypeUri + "\" refers to a \"" + typeTopic.getTypeUri() + "\" when the caller expects a \"dmx.core.topic_type\"");
        }
    }

    private void checkAssociationType(String assocTypeUri, TopicModel typeTopic) {
        if (typeTopic == null) {
            throw new RuntimeException("Association type \"" + assocTypeUri + "\" not found in DB");
        }
        if (!typeTopic.getTypeUri().equals("dmx.core.assoc_type")) {
            throw new RuntimeException("URI \"" + assocTypeUri + "\" refers to a \"" + typeTopic.getTypeUri() + "\" when the caller expects a \"dmx.core.assoc_type\"");
        }
    }

    void storeType(TypeModelImpl type) {
        this.putInTypeCache(type);
        this.storeDataType(type.getUri(), type.getDataTypeUri());
        this.storeAssocDefs(type.getId(), type.getAssocDefs());
        this.storeViewConfig(this.newTypeRole(type.getId()), type.getViewConfig());
    }

    private RelatedTopicModel fetchDataTypeTopic(long typeId, String typeUri, String className) {
        try {
            RelatedTopicModelImpl dataType = this.pl.fetchTopicRelatedTopic(typeId, "dmx.core.composition", "dmx.core.type", "dmx.core.default", "dmx.core.data_type");
            if (dataType == null) {
                throw new RuntimeException("No data type topic is associated to " + className + " \"" + typeUri + "\"");
            }
            return dataType;
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching the data type topic of " + className + " \"" + typeUri + "\" failed", e);
        }
    }

    void storeDataType(String typeUri, String dataTypeUri) {
        try {
            this.pl.createAssociation("dmx.core.composition", this.mf.newTopicRoleModel(typeUri, "dmx.core.type"), this.mf.newTopicRoleModel(dataTypeUri, "dmx.core.default"));
        }
        catch (Exception e) {
            throw new RuntimeException("Associating type \"" + typeUri + "\" with data type \"" + dataTypeUri + "\" failed", e);
        }
    }

    private List<AssociationDefinitionModel> fetchAssociationDefinitions(TopicModelImpl typeTopic) {
        Map<Long, AssociationDefinitionModel> assocDefs = this.fetchAssociationDefinitionsUnsorted(typeTopic);
        List<RelatedAssociationModelImpl> sequence = this.fetchSequence(typeTopic);
        if (assocDefs.size() != sequence.size()) {
            throw new RuntimeException("DB inconsistency: type \"" + typeTopic.getUri() + "\" has " + assocDefs.size() + " association definitions but in sequence are " + sequence.size());
        }
        return this.sortAssocDefs(assocDefs, DMXUtils.idList(sequence));
    }

    private Map<Long, AssociationDefinitionModel> fetchAssociationDefinitionsUnsorted(TopicModelImpl typeTopic) {
        HashMap<Long, AssociationDefinitionModel> assocDefs = new HashMap<Long, AssociationDefinitionModel>();
        List<RelatedTopicModelImpl> childTypes = typeTopic.getRelatedTopics("dmx.core.composition_def", "dmx.core.parent_type", "dmx.core.child_type", null);
        for (RelatedTopicModelImpl childType : childTypes) {
            AssociationDefinitionModel assocDef = this.fetchAssociationDefinition(childType.getRelatingAssociation(), typeTopic.getUri(), childType.getUri());
            assocDefs.put(assocDef.getId(), assocDef);
        }
        return assocDefs;
    }

    AssociationDefinitionModelImpl newAssociationDefinition(AssociationModelImpl assoc) {
        return this.mf.newAssociationDefinitionModel(this.addPlayerUris(assoc, this.fetchParentTypeTopic((AssociationModelImpl)assoc).uri, this.fetchChildTypeTopic((AssociationModelImpl)assoc).uri), this.mf.newViewConfigurationModel().addConfigTopic(this.mf.newTopicModel("dmx.webclient.view_config", new SimpleValue("View Configuration"))));
    }

    private AssociationDefinitionModel fetchAssociationDefinition(AssociationModelImpl assoc, String parentTypeUri, String childTypeUri) {
        try {
            RelatedTopicModel includeInLabel;
            RelatedTopicModel isIdentityAttr;
            this.addPlayerUris(assoc, parentTypeUri, childTypeUri);
            ChildTopicsModelImpl childTopics = assoc.getChildTopicsModel();
            childTopics.put("dmx.core.cardinality", this.fetchCardinality(assoc));
            RelatedTopicModel customAssocType = this.fetchCustomAssocType(assoc);
            if (customAssocType != null) {
                childTopics.put("dmx.core.assoc_type#dmx.core.custom_assoc_type", customAssocType);
            }
            if ((isIdentityAttr = this.fetchIsIdentityAttr(assoc)) != null) {
                childTopics.put("dmx.core.identity_attr", isIdentityAttr);
            }
            if ((includeInLabel = this.fetchIncludeInLabel(assoc)) != null) {
                childTopics.put("dmx.core.include_in_label", includeInLabel);
            }
            return this.mf.newAssociationDefinitionModel(assoc, null);
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching assoc def failed (parentTypeUri=\"" + parentTypeUri + "\", childTypeUri=\"" + childTypeUri + "\", " + assoc + ")", e);
        }
    }

    private RelatedTopicModel fetchCustomAssocType(AssociationModelImpl assoc) {
        return assoc.getRelatedTopic("dmx.core.custom_assoc_type", "dmx.core.parent", "dmx.core.child", "dmx.core.assoc_type");
    }

    private RelatedTopicModel fetchIsIdentityAttr(AssociationModelImpl assoc) {
        return assoc.getRelatedTopic("dmx.core.composition", "dmx.core.parent", "dmx.core.child", "dmx.core.identity_attr");
    }

    private RelatedTopicModel fetchIncludeInLabel(AssociationModelImpl assoc) {
        return assoc.getRelatedTopic("dmx.core.composition", "dmx.core.parent", "dmx.core.child", "dmx.core.include_in_label");
    }

    private AssociationModel addPlayerUris(AssociationModel assoc, String parentTypeUri, String childTypeUri) {
        ((TopicRoleModelImpl)assoc.getRoleModel((String)"dmx.core.parent_type")).topicUri = parentTypeUri;
        ((TopicRoleModelImpl)assoc.getRoleModel((String)"dmx.core.child_type")).topicUri = childTypeUri;
        return assoc;
    }

    private void addPlayerIds(AssociationDefinitionModelImpl assocDef) {
        assocDef.getRoleModel((String)"dmx.core.parent_type").playerId = assocDef.getParentType().id;
        assocDef.getRoleModel((String)"dmx.core.child_type").playerId = assocDef.getChildType().id;
    }

    private List<AssociationDefinitionModel> sortAssocDefs(Map<Long, AssociationDefinitionModel> assocDefs, List<Long> sequence) {
        ArrayList<AssociationDefinitionModel> sortedAssocDefs = new ArrayList<AssociationDefinitionModel>();
        for (long assocDefId : sequence) {
            AssociationDefinitionModel assocDef = assocDefs.get(assocDefId);
            if (assocDef == null) {
                throw new RuntimeException("DB inconsistency: ID " + assocDefId + " is in sequence but not in the type's association definitions");
            }
            sortedAssocDefs.add(assocDef);
        }
        return sortedAssocDefs;
    }

    private void storeAssocDefs(long typeId, Collection<AssociationDefinitionModelImpl> assocDefs) {
        for (AssociationDefinitionModelImpl assocDef : assocDefs) {
            this.storeAssociationDefinition(assocDef);
        }
        this.storeSequence(typeId, assocDefs);
    }

    void storeAssociationDefinition(AssociationDefinitionModelImpl assocDef) {
        try {
            long assocDefId = assocDef.getId();
            if (assocDefId == -1L) {
                this.addPlayerIds(assocDef);
                assocDefId = this.pl.createAssociation(assocDef).getId();
            }
            this.storeViewConfig(this.newAssocDefRole(assocDefId), assocDef.getViewConfig());
        }
        catch (Exception e) {
            throw new RuntimeException("Storing assoc def \"" + assocDef.getAssocDefUri() + "\" failed (parent type \"" + assocDef.getParentTypeUri() + "\")", e);
        }
    }

    private TopicModelImpl fetchParentTypeTopic(AssociationModelImpl assoc) {
        TopicModelImpl parentType = (TopicModelImpl)assoc.getPlayer("dmx.core.parent_type");
        if (parentType == null) {
            throw new RuntimeException("DB inconsistency: topic role \"dmx.core.parent_type\" is missing in " + assoc);
        }
        return parentType;
    }

    private TopicModelImpl fetchChildTypeTopic(AssociationModelImpl assoc) {
        TopicModelImpl childType = (TopicModelImpl)assoc.getPlayer("dmx.core.child_type");
        if (childType == null) {
            throw new RuntimeException("DB inconsistency: topic role \"dmx.core.child_type\" is missing in " + assoc);
        }
        return childType;
    }

    TypeModelImpl fetchParentType(AssociationModelImpl assoc) {
        TopicModelImpl type = this.fetchParentTypeTopic(assoc);
        if (type.typeUri.equals("dmx.core.topic_type")) {
            return this.getTopicType(type.uri);
        }
        if (type.typeUri.equals("dmx.core.assoc_type")) {
            return this.getAssociationType(type.uri);
        }
        throw new RuntimeException("DB inconsistency: the \"dmx.core.parent_type\" player is not a type but of type \"" + type.typeUri + "\" in " + assoc);
    }

    private RelatedTopicModelImpl fetchCardinality(AssociationModelImpl assoc) {
        RelatedTopicModelImpl cardinality = this.fetchCardinalityIfExists(assoc);
        if (cardinality == null) {
            throw new RuntimeException("DB inconsistency: assoc def " + assoc.id + " has no cardinality");
        }
        return cardinality;
    }

    private RelatedTopicModelImpl fetchCardinalityIfExists(AssociationModelImpl assoc) {
        return assoc.getRelatedTopic("dmx.core.composition", "dmx.core.parent", "dmx.core.child", "dmx.core.cardinality");
    }

    private RelatedTopicModel defaultCardinality(AssociationModelImpl assoc) {
        RelatedTopicModelImpl cardinality = this.fetchCardinalityIfExists(assoc);
        if (cardinality != null) {
            return cardinality;
        }
        return this.mf.newRelatedTopicModel(this.pl.fetchTopic("uri", new SimpleValue("dmx.core.one")));
    }

    private List<RelatedAssociationModelImpl> fetchSequence(TopicModel typeTopic) {
        try {
            ArrayList<RelatedAssociationModelImpl> sequence = new ArrayList<RelatedAssociationModelImpl>();
            RelatedAssociationModelImpl assocDef = this.fetchSequenceStart(typeTopic.getId());
            if (assocDef != null) {
                sequence.add(assocDef);
                while ((assocDef = this.fetchSuccessor(assocDef.getId())) != null) {
                    sequence.add(assocDef);
                }
            }
            return sequence;
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching sequence for type \"" + typeTopic.getUri() + "\" failed", e);
        }
    }

    private RelatedAssociationModelImpl fetchSequenceStart(long typeId) {
        return this.pl.fetchTopicRelatedAssociation(typeId, "dmx.core.composition", "dmx.core.type", "dmx.core.sequence_start", null);
    }

    private RelatedAssociationModelImpl fetchSuccessor(long assocDefId) {
        return this.pl.fetchAssociationRelatedAssociation(assocDefId, "dmx.core.sequence", "dmx.core.predecessor", "dmx.core.successor", null);
    }

    private RelatedAssociationModelImpl fetchPredecessor(long assocDefId) {
        return this.pl.fetchAssociationRelatedAssociation(assocDefId, "dmx.core.sequence", "dmx.core.successor", "dmx.core.predecessor", null);
    }

    private void storeSequence(long typeId, Collection<AssociationDefinitionModelImpl> assocDefs) {
        this.logger.fine("### Storing " + assocDefs.size() + " sequence segments for type " + typeId);
        long predAssocDefId = -1L;
        for (AssociationDefinitionModel associationDefinitionModel : assocDefs) {
            this.addAssocDefToSequence(typeId, associationDefinitionModel.getId(), -1L, -1L, predAssocDefId);
            predAssocDefId = associationDefinitionModel.getId();
        }
    }

    void addAssocDefToSequence(long typeId, long assocDefId, long beforeAssocDefId, long firstAssocDefId, long lastAssocDefId) {
        if (beforeAssocDefId == -1L) {
            this.appendToSequence(typeId, assocDefId, lastAssocDefId);
        } else if (firstAssocDefId == assocDefId) {
            this.insertAtSequenceStart(typeId, assocDefId);
        } else {
            this.insertIntoSequence(assocDefId, beforeAssocDefId);
        }
    }

    private void appendToSequence(long typeId, long assocDefId, long predAssocDefId) {
        if (predAssocDefId == -1L) {
            this.storeSequenceStart(typeId, assocDefId);
        } else {
            this.storeSequenceSegment(predAssocDefId, assocDefId);
        }
    }

    private void insertAtSequenceStart(long typeId, long assocDefId) {
        RelatedAssociationModelImpl assocDef = this.fetchSequenceStart(typeId);
        assocDef.getRelatingAssociation().delete();
        this.storeSequenceStart(typeId, assocDefId);
        this.storeSequenceSegment(assocDefId, assocDef.getId());
    }

    private void insertIntoSequence(long assocDefId, long beforeAssocDefId) {
        RelatedAssociationModelImpl assocDef = this.fetchPredecessor(beforeAssocDefId);
        assocDef.getRelatingAssociation().delete();
        this.storeSequenceSegment(assocDef.getId(), assocDefId);
        this.storeSequenceSegment(assocDefId, beforeAssocDefId);
    }

    private void storeSequenceStart(long typeId, long assocDefId) {
        this.pl.createAssociation("dmx.core.composition", this.mf.newTopicRoleModel(typeId, "dmx.core.type"), this.mf.newAssociationRoleModel(assocDefId, "dmx.core.sequence_start"));
    }

    private void storeSequenceSegment(long predAssocDefId, long succAssocDefId) {
        this.pl.createAssociation("dmx.core.sequence", this.mf.newAssociationRoleModel(predAssocDefId, "dmx.core.predecessor"), this.mf.newAssociationRoleModel(succAssocDefId, "dmx.core.successor"));
    }

    void rebuildSequence(TypeModelImpl type) {
        this.deleteSequence(type);
        this.storeSequence(type.getId(), type.getAssocDefs());
    }

    private void deleteSequence(TopicModel typeTopic) {
        List<RelatedAssociationModelImpl> sequence = this.fetchSequence(typeTopic);
        this.logger.info("### Deleting " + sequence.size() + " sequence segments of type \"" + typeTopic.getUri() + "\"");
        for (RelatedAssociationModelImpl assoc : sequence) {
            assoc.getRelatingAssociation().delete();
        }
    }

    private void fetchAssocDefsViewConfig(List<AssociationDefinitionModel> assocDefs) {
        for (AssociationDefinitionModel assocDef : assocDefs) {
            assocDef.setViewConfig(this.fetchAssocDefViewConfig(assocDef));
        }
    }

    private ViewConfigurationModel fetchTypeViewConfig(TopicModel typeTopic) {
        try {
            return this.viewConfigModel(this.pl.fetchTopicRelatedTopics(typeTopic.getId(), "dmx.core.composition", "dmx.core.type", "dmx.core.view_config", null));
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching view configuration for type \"" + typeTopic.getUri() + "\" failed", e);
        }
    }

    private ViewConfigurationModel fetchAssocDefViewConfig(AssociationModel assocDef) {
        try {
            return this.viewConfigModel(this.pl.fetchAssociationRelatedTopics(assocDef.getId(), "dmx.core.composition", "dmx.core.assoc_def", "dmx.core.view_config", null));
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching view configuration for assoc def " + assocDef.getId() + " failed", e);
        }
    }

    private ViewConfigurationModel viewConfigModel(Iterable<? extends TopicModelImpl> configTopics) {
        this.loadChildTopics(configTopics);
        return this.mf.newViewConfigurationModel(configTopics);
    }

    private void storeViewConfig(RoleModel configurable, ViewConfigurationModelImpl viewConfig) {
        try {
            for (TopicModelImpl configTopic : viewConfig.getConfigTopics()) {
                this.storeViewConfigTopic(configurable, configTopic);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Storing view configuration failed (configurable=" + configurable + ", viewConfig=" + viewConfig + ")", e);
        }
    }

    void storeViewConfigTopic(RoleModel configurable, TopicModelImpl configTopic) {
        this.pl.createTopic(configTopic);
        this.pl.createAssociation("dmx.core.composition", configurable, this.mf.newTopicRoleModel(configTopic.getId(), "dmx.core.view_config"));
    }

    private void loadChildTopics(Iterable<? extends DMXObjectModelImpl> objects) {
        for (DMXObjectModelImpl dMXObjectModelImpl : objects) {
            dMXObjectModelImpl.loadChildTopics(true);
        }
    }

    RoleModel newTypeRole(long typeId) {
        return this.mf.newTopicRoleModel(typeId, "dmx.core.type");
    }

    RoleModel newAssocDefRole(long assocDefId) {
        return this.mf.newAssociationRoleModel(assocDefId, "dmx.core.assoc_def");
    }

    private static final class EndlessRecursionDetection {
        private Map<String, Boolean> loadInProgress = new HashMap<String, Boolean>();

        private EndlessRecursionDetection() {
        }

        private void check(String typeUri) {
            if (this.loadInProgress.get(typeUri) != null) {
                throw new RuntimeException("Endless recursion detected while loading type \"" + typeUri + "\"");
            }
            this.loadInProgress.put(typeUri, true);
        }

        private void reset(String typeUri) {
            this.loadInProgress.remove(typeUri);
        }
    }
}

