/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.topicmaps;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.codehaus.jettison.json.JSONObject;
import systems.dmx.core.Association;
import systems.dmx.core.RelatedAssociation;
import systems.dmx.core.RelatedTopic;
import systems.dmx.core.Topic;
import systems.dmx.core.model.AssociationModel;
import systems.dmx.core.model.ChildTopicsModel;
import systems.dmx.core.model.RoleModel;
import systems.dmx.core.model.TopicModel;
import systems.dmx.core.model.topicmaps.AssociationViewModel;
import systems.dmx.core.model.topicmaps.TopicViewModel;
import systems.dmx.core.model.topicmaps.ViewProperties;
import systems.dmx.core.osgi.PluginActivator;
import systems.dmx.core.service.Transactional;
import systems.dmx.core.util.DMXUtils;
import systems.dmx.core.util.IdList;
import systems.dmx.topicmaps.ClusterCoords;
import systems.dmx.topicmaps.DefaultTopicmapRenderer;
import systems.dmx.topicmaps.TopicmapRenderer;
import systems.dmx.topicmaps.TopicmapsService;
import systems.dmx.topicmaps.ViewmodelCustomizer;
import systems.dmx.topicmaps.model.TopicmapViewmodel;

@Path(value="/topicmap")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class TopicmapsPlugin
extends PluginActivator
implements TopicmapsService {
    private static final String TOPIC_MAPCONTEXT = "dmx.topicmaps.topic_mapcontext";
    private static final String ASSOCIATION_MAPCONTEXT = "dmx.topicmaps.association_mapcontext";
    private static final String ROLE_TYPE_TOPICMAP = "dmx.core.default";
    private static final String ROLE_TYPE_TOPIC = "dmx.topicmaps.topicmap_topic";
    private static final String ROLE_TYPE_ASSOCIATION = "dmx.topicmaps.topicmap_association";
    private static final String PROP_X = "dmx.topicmaps.x";
    private static final String PROP_Y = "dmx.topicmaps.y";
    private static final String PROP_VISIBILITY = "dmx.topicmaps.visibility";
    private static final String PROP_PINNED = "dmx.topicmaps.pinned";
    private Map<String, TopicmapRenderer> topicmapRenderers = new HashMap<String, TopicmapRenderer>();
    private List<ViewmodelCustomizer> viewmodelCustomizers = new ArrayList<ViewmodelCustomizer>();
    private Messenger me = new Messenger("systems.dmx.webclient");
    @Context
    private HttpServletRequest request;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    public TopicmapsPlugin() {
        this.registerTopicmapRenderer(new DefaultTopicmapRenderer());
    }

    @Override
    @POST
    @Transactional
    public Topic createTopicmap(@QueryParam(value="name") String name, @QueryParam(value="renderer_uri") String topicmapRendererUri, @QueryParam(value="private") boolean isPrivate) {
        this.logger.info("Creating topicmap \"" + name + "\" (topicmapRendererUri=\"" + topicmapRendererUri + "\", isPrivate=" + isPrivate + ")");
        Topic topicmapTopic = this.dmx.createTopic(this.mf.newTopicModel("dmx.topicmaps.topicmap", this.mf.newChildTopicsModel().put("dmx.topicmaps.name", (Object)name).put("dmx.topicmaps.topicmap_renderer_uri", (Object)topicmapRendererUri).put("dmx.topicmaps.private", (Object)isPrivate).put("dmx.topicmaps.state", this.getTopicmapRenderer(topicmapRendererUri).initialTopicmapState(this.mf))));
        this.me.newTopicmap(topicmapTopic);
        return topicmapTopic;
    }

    @Override
    @GET
    @Path(value="/{id}")
    public TopicmapViewmodel getTopicmap(@PathParam(value="id") long topicmapId, @QueryParam(value="include_childs") boolean includeChilds) {
        try {
            this.logger.info("Loading topicmap " + topicmapId + " (includeChilds=" + includeChilds + ")");
            Topic topicmapTopic = this.dmx.getTopic(topicmapId).loadChildTopics();
            Map<Long, TopicViewModel> topics = this.fetchTopics(topicmapTopic, includeChilds);
            Map<Long, AssociationViewModel> assocs = this.fetchAssociations(topicmapTopic);
            return new TopicmapViewmodel(topicmapTopic.getModel(), topics, assocs);
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching topicmap " + topicmapId + " failed", e);
        }
    }

    @Override
    public boolean isTopicInTopicmap(long topicmapId, long topicId) {
        return this.fetchTopicMapcontext(topicmapId, topicId) != null;
    }

    @Override
    public boolean isAssociationInTopicmap(long topicmapId, long assocId) {
        return this.fetchAssociationMapcontext(topicmapId, assocId) != null;
    }

    @Override
    @POST
    @Path(value="/{id}/topic/{topic_id}")
    @Transactional
    public void addTopicToTopicmap(final @PathParam(value="id") long topicmapId, final @PathParam(value="topic_id") long topicId, final ViewProperties viewProps) {
        try {
            this.dmx.getAccessControl().runWithoutWorkspaceAssignment((Callable)new Callable<Void>(){

                @Override
                public Void call() {
                    if (TopicmapsPlugin.this.isTopicInTopicmap(topicmapId, topicId)) {
                        throw new RuntimeException("Topic " + topicId + " already added to topicmap" + topicmapId);
                    }
                    TopicmapsPlugin.this.createTopicMapcontext(topicmapId, topicId, viewProps);
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException("Adding topic " + topicId + " to topicmap " + topicmapId + " failed (viewProps=" + viewProps + ")", e);
        }
    }

    @Override
    public void addTopicToTopicmap(long topicmapId, long topicId, int x, int y, boolean visibility) {
        this.addTopicToTopicmap(topicmapId, topicId, this.mf.newViewProperties(x, y, visibility, false));
    }

    @Override
    @POST
    @Path(value="/{id}/association/{assoc_id}")
    @Transactional
    public void addAssociationToTopicmap(final @PathParam(value="id") long topicmapId, final @PathParam(value="assoc_id") long assocId, final ViewProperties viewProps) {
        try {
            this.dmx.getAccessControl().runWithoutWorkspaceAssignment((Callable)new Callable<Void>(){

                @Override
                public Void call() {
                    if (TopicmapsPlugin.this.isAssociationInTopicmap(topicmapId, assocId)) {
                        throw new RuntimeException("Association " + assocId + " already added to topicmap " + topicmapId);
                    }
                    TopicmapsPlugin.this.createAssociationMapcontext(topicmapId, assocId, viewProps);
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException("Adding association " + assocId + " to topicmap " + topicmapId + " failed (viewProps=" + viewProps + ")", e);
        }
    }

    @Override
    @POST
    @Path(value="/{id}/topic/{topic_id}/association/{assoc_id}")
    @Transactional
    public void addRelatedTopicToTopicmap(final @PathParam(value="id") long topicmapId, final @PathParam(value="topic_id") long topicId, final @PathParam(value="assoc_id") long assocId, final ViewProperties viewProps) {
        try {
            this.dmx.getAccessControl().runWithoutWorkspaceAssignment((Callable)new Callable<Void>(){

                @Override
                public Void call() {
                    Association topicMapcontext = TopicmapsPlugin.this.fetchTopicMapcontext(topicmapId, topicId);
                    if (topicMapcontext == null) {
                        TopicmapsPlugin.this.createTopicMapcontext(topicmapId, topicId, viewProps);
                    } else if (!TopicmapsPlugin.this.visibility(topicMapcontext)) {
                        TopicmapsPlugin.this.setTopicVisibility(topicmapId, topicId, true);
                    }
                    TopicmapsPlugin.this.addAssociationToTopicmap(topicmapId, assocId, TopicmapsPlugin.this.mf.newViewProperties().put(TopicmapsPlugin.PROP_PINNED, (Object)false));
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException("Adding related topic " + topicId + " (assocId=" + assocId + ") to topicmap " + topicmapId + " failed (viewProps=" + viewProps + ")", e);
        }
    }

    @Override
    @PUT
    @Path(value="/{id}/topic/{topic_id}")
    @Transactional
    public void setTopicViewProperties(@PathParam(value="id") long topicmapId, @PathParam(value="topic_id") long topicId, ViewProperties viewProps) {
        this.storeTopicViewProperties(topicmapId, topicId, viewProps);
    }

    @Override
    @PUT
    @Path(value="/{id}/association/{assoc_id}")
    @Transactional
    public void setAssociationViewProperties(@PathParam(value="id") long topicmapId, @PathParam(value="assoc_id") long assocId, ViewProperties viewProps) {
        this.storeAssociationViewProperties(topicmapId, assocId, viewProps);
    }

    @Override
    @PUT
    @Path(value="/{id}/topic/{topic_id}/{x}/{y}")
    @Transactional
    public void setTopicPosition(@PathParam(value="id") long topicmapId, @PathParam(value="topic_id") long topicId, @PathParam(value="x") int x, @PathParam(value="y") int y) {
        try {
            this.storeTopicViewProperties(topicmapId, topicId, this.mf.newViewProperties(x, y));
            this.me.setTopicPosition(topicmapId, topicId, x, y);
        }
        catch (Exception e) {
            throw new RuntimeException("Setting position of topic " + topicId + " in topicmap " + topicmapId + " failed ", e);
        }
    }

    @Override
    @PUT
    @Path(value="/{id}/topic/{topic_id}/{visibility}")
    @Transactional
    public void setTopicVisibility(@PathParam(value="id") long topicmapId, @PathParam(value="topic_id") long topicId, @PathParam(value="visibility") boolean visibility) {
        try {
            if (!visibility) {
                for (Association assoc : this.dmx.getTopic(topicId).getAssociations()) {
                    Association assocMapcontext = this.fetchAssociationMapcontext(topicmapId, assoc.getId());
                    if (assocMapcontext == null) continue;
                    this.deleteAssociationMapcontext(assocMapcontext);
                }
            }
            this.storeTopicViewProperties(topicmapId, topicId, this.mf.newViewProperties(visibility));
            this.me.setTopicVisibility(topicmapId, topicId, visibility);
        }
        catch (Exception e) {
            throw new RuntimeException("Setting visibility of topic " + topicId + " in topicmap " + topicmapId + " failed ", e);
        }
    }

    @Override
    @DELETE
    @Path(value="/{id}/association/{assoc_id}")
    @Transactional
    public void removeAssociationFromTopicmap(@PathParam(value="id") long topicmapId, @PathParam(value="assoc_id") long assocId) {
        try {
            Association assocMapcontext = this.fetchAssociationMapcontext(topicmapId, assocId);
            if (assocMapcontext != null) {
                this.deleteAssociationMapcontext(assocMapcontext);
                this.me.removeAssociationFromTopicmap(topicmapId, assocId);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Removing association " + assocId + " from topicmap " + topicmapId + " failed ", e);
        }
    }

    @Override
    @PUT
    @Path(value="/{id}/topics/{topicIds}/visibility/false")
    @Transactional
    public void hideTopics(@PathParam(value="id") long topicmapId, @PathParam(value="topicIds") IdList topicIds) {
        this.hideMulti(topicmapId, topicIds, new IdList());
    }

    @Override
    @PUT
    @Path(value="/{id}/assocs/{assocIds}/visibility/false")
    @Transactional
    public void hideAssocs(@PathParam(value="id") long topicmapId, @PathParam(value="assocIds") IdList assocIds) {
        this.hideMulti(topicmapId, new IdList(), assocIds);
    }

    @Override
    @PUT
    @Path(value="/{id}/topics/{topicIds}/assocs/{assocIds}/visibility/false")
    @Transactional
    public void hideMulti(@PathParam(value="id") long topicmapId, @PathParam(value="topicIds") IdList topicIds, @PathParam(value="assocIds") IdList assocIds) {
        long id;
        this.logger.info("topicmapId=" + topicmapId + ", topicIds=" + topicIds + ", assocIds=" + assocIds);
        Iterator iterator = topicIds.iterator();
        while (iterator.hasNext()) {
            id = (Long)iterator.next();
            this.setTopicVisibility(topicmapId, id, false);
        }
        iterator = assocIds.iterator();
        while (iterator.hasNext()) {
            id = (Long)iterator.next();
            this.removeAssociationFromTopicmap(topicmapId, id);
        }
    }

    @Override
    @PUT
    @Path(value="/{id}")
    @Transactional
    public void setClusterPosition(@PathParam(value="id") long topicmapId, ClusterCoords coords) {
        for (ClusterCoords.Entry entry : coords) {
            this.setTopicPosition(topicmapId, entry.topicId, entry.x, entry.y);
        }
    }

    @Override
    @PUT
    @Path(value="/{id}/translation/{x}/{y}")
    @Transactional
    public void setTopicmapTranslation(@PathParam(value="id") long topicmapId, @PathParam(value="x") int transX, @PathParam(value="y") int transY) {
        try {
            ChildTopicsModel topicmapState = this.mf.newChildTopicsModel().put("dmx.topicmaps.state", this.mf.newChildTopicsModel().put("dmx.topicmaps.translation", this.mf.newChildTopicsModel().put("dmx.topicmaps.translation_x", (Object)transX).put("dmx.topicmaps.translation_y", (Object)transY)));
            this.dmx.updateTopic(this.mf.newTopicModel(topicmapId, topicmapState));
        }
        catch (Exception e) {
            throw new RuntimeException("Setting translation of topicmap " + topicmapId + " failed (transX=" + transX + ", transY=" + transY + ")", e);
        }
    }

    @Override
    public void registerTopicmapRenderer(TopicmapRenderer renderer) {
        this.logger.info("### Registering topicmap renderer \"" + renderer.getClass().getName() + "\"");
        this.topicmapRenderers.put(renderer.getUri(), renderer);
    }

    @Override
    public void registerViewmodelCustomizer(ViewmodelCustomizer customizer) {
        this.logger.info("### Registering viewmodel customizer \"" + customizer.getClass().getName() + "\"");
        this.viewmodelCustomizers.add(customizer);
    }

    @Override
    public void unregisterViewmodelCustomizer(ViewmodelCustomizer customizer) {
        this.logger.info("### Unregistering viewmodel customizer \"" + customizer.getClass().getName() + "\"");
        if (!this.viewmodelCustomizers.remove(customizer)) {
            throw new RuntimeException("Unregistering viewmodel customizer failed (customizer=" + customizer + ")");
        }
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"text/html"})
    public InputStream getTopicmapInWebclient() {
        return this.invokeWebclient();
    }

    @GET
    @Path(value="/{id}/topic/{topic_id}")
    @Produces(value={"text/html"})
    public InputStream getTopicmapAndTopicInWebclient() {
        return this.invokeWebclient();
    }

    private Map<Long, TopicViewModel> fetchTopics(Topic topicmapTopic, boolean includeChilds) {
        HashMap<Long, TopicViewModel> topics = new HashMap<Long, TopicViewModel>();
        List relTopics = topicmapTopic.getRelatedTopics(TOPIC_MAPCONTEXT, ROLE_TYPE_TOPICMAP, ROLE_TYPE_TOPIC, null);
        if (includeChilds) {
            DMXUtils.loadChildTopics((List)relTopics);
        }
        for (RelatedTopic topic : relTopics) {
            topics.put(topic.getId(), this.createTopicViewModel(topic));
        }
        return topics;
    }

    private Map<Long, AssociationViewModel> fetchAssociations(Topic topicmapTopic) {
        HashMap<Long, AssociationViewModel> assocs = new HashMap<Long, AssociationViewModel>();
        List relAssocs = topicmapTopic.getRelatedAssociations(ASSOCIATION_MAPCONTEXT, ROLE_TYPE_TOPICMAP, ROLE_TYPE_ASSOCIATION, null);
        for (RelatedAssociation assoc : relAssocs) {
            assocs.put(assoc.getId(), this.createAssocViewModel(assoc));
        }
        return assocs;
    }

    private TopicViewModel createTopicViewModel(RelatedTopic topic) {
        try {
            ViewProperties viewProps = this.fetchTopicViewProperties(topic.getRelatingAssociation());
            this.invokeViewmodelCustomizers(topic, viewProps);
            return this.mf.newTopicViewModel((TopicModel)topic.getModel(), viewProps);
        }
        catch (Exception e) {
            throw new RuntimeException("Creating viewmodel for topic " + topic.getId() + " failed", e);
        }
    }

    private AssociationViewModel createAssocViewModel(RelatedAssociation assoc) {
        try {
            ViewProperties viewProps = this.fetchAssocViewProperties(assoc.getRelatingAssociation());
            return this.mf.newAssociationViewModel((AssociationModel)assoc.getModel(), viewProps);
        }
        catch (Exception e) {
            throw new RuntimeException("Creating viewmodel for association " + assoc.getId() + " failed", e);
        }
    }

    private Association fetchTopicMapcontext(long topicmapId, long topicId) {
        return this.dmx.getAssociation(TOPIC_MAPCONTEXT, topicmapId, topicId, ROLE_TYPE_TOPICMAP, ROLE_TYPE_TOPIC);
    }

    private Association fetchAssociationMapcontext(long topicmapId, long assocId) {
        return this.dmx.getAssociationBetweenTopicAndAssociation(ASSOCIATION_MAPCONTEXT, topicmapId, assocId, ROLE_TYPE_TOPICMAP, ROLE_TYPE_ASSOCIATION);
    }

    private void createTopicMapcontext(long topicmapId, long topicId, ViewProperties viewProps) {
        Association topicMapcontext = this.dmx.createAssociation(this.mf.newAssociationModel(TOPIC_MAPCONTEXT, (RoleModel)this.mf.newTopicRoleModel(topicmapId, ROLE_TYPE_TOPICMAP), (RoleModel)this.mf.newTopicRoleModel(topicId, ROLE_TYPE_TOPIC)));
        this.storeViewProperties(topicMapcontext, viewProps);
        TopicViewModel topic = this.mf.newTopicViewModel(this.dmx.getTopic(topicId).getModel(), viewProps);
        this.me.addTopicToTopicmap(topicmapId, topic);
    }

    private void createAssociationMapcontext(long topicmapId, long assocId, ViewProperties viewProps) {
        Association assocMapcontext = this.dmx.createAssociation(this.mf.newAssociationModel(ASSOCIATION_MAPCONTEXT, (RoleModel)this.mf.newTopicRoleModel(topicmapId, ROLE_TYPE_TOPICMAP), (RoleModel)this.mf.newAssociationRoleModel(assocId, ROLE_TYPE_ASSOCIATION)));
        this.storeViewProperties(assocMapcontext, viewProps);
        AssociationModel assoc = this.dmx.getAssociation(assocId).getModel();
        this.me.addAssociationToTopicmap(topicmapId, assoc);
    }

    private void deleteAssociationMapcontext(Association assocMapcontext) {
        this.dmx.getAccessControl().deleteAssociationMapcontext(assocMapcontext);
    }

    private ViewProperties fetchTopicViewProperties(Association topicMapcontext) {
        return this.mf.newViewProperties(((Integer)topicMapcontext.getProperty(PROP_X)).intValue(), ((Integer)topicMapcontext.getProperty(PROP_Y)).intValue(), this.visibility(topicMapcontext), this.pinned(topicMapcontext));
    }

    private ViewProperties fetchAssocViewProperties(Association assocMapcontext) {
        return this.mf.newViewProperties().put(PROP_PINNED, (Object)this.pinned(assocMapcontext));
    }

    private boolean visibility(Association topicMapcontext) {
        return (Boolean)topicMapcontext.getProperty(PROP_VISIBILITY);
    }

    private boolean pinned(Association mapcontext) {
        return (Boolean)mapcontext.getProperty(PROP_PINNED);
    }

    private void storeTopicViewProperties(long topicmapId, long topicId, ViewProperties viewProps) {
        try {
            Association topicMapcontext = this.fetchTopicMapcontext(topicmapId, topicId);
            if (topicMapcontext == null) {
                throw new RuntimeException("Topic " + topicId + " is not contained in topicmap " + topicmapId);
            }
            this.storeViewProperties(topicMapcontext, viewProps);
        }
        catch (Exception e) {
            throw new RuntimeException("Storing view properties of topic " + topicId + " failed (viewProps=" + viewProps + ")", e);
        }
    }

    private void storeAssociationViewProperties(long topicmapId, long assocId, ViewProperties viewProps) {
        try {
            Association assocMapcontext = this.fetchAssociationMapcontext(topicmapId, assocId);
            if (assocMapcontext == null) {
                throw new RuntimeException("Association " + assocId + " is not contained in topicmap " + topicmapId);
            }
            this.storeViewProperties(assocMapcontext, viewProps);
        }
        catch (Exception e) {
            throw new RuntimeException("Storing view properties of association " + assocId + " failed (viewProps=" + viewProps + ")", e);
        }
    }

    private void storeViewProperties(Association mapcontext, ViewProperties viewProps) {
        for (String propUri : viewProps) {
            mapcontext.setProperty(propUri, viewProps.get(propUri), false);
        }
    }

    private void invokeViewmodelCustomizers(RelatedTopic topic, ViewProperties viewProps) {
        for (ViewmodelCustomizer customizer : this.viewmodelCustomizers) {
            this.invokeViewmodelCustomizer(customizer, topic, viewProps);
        }
    }

    private void invokeViewmodelCustomizer(ViewmodelCustomizer customizer, RelatedTopic topic, ViewProperties viewProps) {
        try {
            customizer.enrichViewProperties(topic, viewProps);
        }
        catch (Exception e) {
            throw new RuntimeException("Invoking viewmodel customizer for topic " + topic.getId() + " failed (customizer=\"" + customizer.getClass().getName() + "\")", e);
        }
    }

    private TopicmapRenderer getTopicmapRenderer(String rendererUri) {
        TopicmapRenderer renderer = this.topicmapRenderers.get(rendererUri);
        if (renderer == null) {
            throw new RuntimeException("\"" + rendererUri + "\" is an unknown topicmap renderer");
        }
        return renderer;
    }

    private InputStream invokeWebclient() {
        return this.dmx.getPlugin("systems.dmx.webclient").getStaticResource("/web/index.html");
    }

    private class Messenger {
        private String pluginUri;

        private Messenger(String pluginUri) {
            this.pluginUri = pluginUri;
        }

        private void newTopicmap(Topic topicmapTopic) {
            try {
                this.messageToAllButOne(new JSONObject().put("type", (Object)"newTopicmap").put("args", (Object)new JSONObject().put("topicmapTopic", (Object)topicmapTopic.toJSON())));
            }
            catch (Exception e) {
                TopicmapsPlugin.this.logger.log(Level.WARNING, "Error while sending a \"newTopicmap\" message:", e);
            }
        }

        private void addTopicToTopicmap(long topicmapId, TopicViewModel topic) {
            try {
                this.messageToAllButOne(new JSONObject().put("type", (Object)"addTopicToTopicmap").put("args", (Object)new JSONObject().put("topicmapId", topicmapId).put("viewTopic", (Object)topic.toJSON())));
            }
            catch (Exception e) {
                TopicmapsPlugin.this.logger.log(Level.WARNING, "Error while sending a \"addTopicToTopicmap\" message:", e);
            }
        }

        private void addAssociationToTopicmap(long topicmapId, AssociationModel assoc) {
            try {
                this.messageToAllButOne(new JSONObject().put("type", (Object)"addAssocToTopicmap").put("args", (Object)new JSONObject().put("topicmapId", topicmapId).put("assoc", (Object)assoc.toJSON())));
            }
            catch (Exception e) {
                TopicmapsPlugin.this.logger.log(Level.WARNING, "Error while sending a \"addAssocToTopicmap\" message:", e);
            }
        }

        private void setTopicPosition(long topicmapId, long topicId, int x, int y) {
            try {
                this.messageToAllButOne(new JSONObject().put("type", (Object)"setTopicPosition").put("args", (Object)new JSONObject().put("topicmapId", topicmapId).put("topicId", topicId).put("pos", (Object)new JSONObject().put("x", x).put("y", y))));
            }
            catch (Exception e) {
                TopicmapsPlugin.this.logger.log(Level.WARNING, "Error while sending a \"setTopicPosition\" message:", e);
            }
        }

        private void setTopicVisibility(long topicmapId, long topicId, boolean visibility) {
            try {
                this.messageToAllButOne(new JSONObject().put("type", (Object)"setTopicVisibility").put("args", (Object)new JSONObject().put("topicmapId", topicmapId).put("topicId", topicId).put("visibility", visibility)));
            }
            catch (Exception e) {
                TopicmapsPlugin.this.logger.log(Level.WARNING, "Error while sending a \"setTopicVisibility\" message:", e);
            }
        }

        private void removeAssociationFromTopicmap(long topicmapId, long assocId) {
            try {
                this.messageToAllButOne(new JSONObject().put("type", (Object)"removeAssocFromTopicmap").put("args", (Object)new JSONObject().put("topicmapId", topicmapId).put("assocId", assocId)));
            }
            catch (Exception e) {
                TopicmapsPlugin.this.logger.log(Level.WARNING, "Error while sending a \"removeAssocFromTopicmap\" message:", e);
            }
        }

        private void messageToAllButOne(JSONObject message) {
            TopicmapsPlugin.this.dmx.getWebSocketsService().messageToAllButOne(TopicmapsPlugin.this.request, this.pluginUri, message.toString());
        }
    }
}

