/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.impl;

import java.util.List;
import java.util.logging.Logger;
import systems.dmx.core.Association;
import systems.dmx.core.DMXObject;
import systems.dmx.core.RelatedAssociation;
import systems.dmx.core.RelatedObject;
import systems.dmx.core.RelatedTopic;
import systems.dmx.core.Role;
import systems.dmx.core.Topic;
import systems.dmx.core.TopicRole;
import systems.dmx.core.impl.AssociationModelImpl;
import systems.dmx.core.impl.DMXObjectImpl;
import systems.dmx.core.impl.DMXObjectModelImpl;
import systems.dmx.core.impl.PersistenceLayer;
import systems.dmx.core.impl.RelatedAssociationModelImpl;
import systems.dmx.core.impl.TopicModelImpl;
import systems.dmx.core.model.AssociationModel;
import systems.dmx.core.model.RoleModel;
import systems.dmx.core.model.TopicRoleModel;

class AssociationImpl
extends DMXObjectImpl
implements Association {
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    AssociationImpl(AssociationModelImpl model, PersistenceLayer pl) {
        super(model, pl);
    }

    @Override
    public final Role getRole1() {
        return this.getModel().getRoleModel1().instantiate(this.getModel());
    }

    @Override
    public final Role getRole2() {
        return this.getModel().getRoleModel2().instantiate(this.getModel());
    }

    @Override
    public final DMXObject getPlayer1() {
        return this.getRole1().getPlayer();
    }

    @Override
    public final DMXObject getPlayer2() {
        return this.getRole2().getPlayer();
    }

    @Override
    public final Role getRole(String roleTypeUri) {
        return this.getModel().getRoleModel(roleTypeUri).instantiate(this.getModel());
    }

    @Override
    public final boolean hasSameRoleTypeUris() {
        return this.getModel().hasSameRoleTypeUris();
    }

    @Override
    public final boolean matches(String roleTypeUri1, long playerId1, String roleTypeUri2, long playerId2) {
        return this.getModel().matches(roleTypeUri1, playerId1, roleTypeUri2, playerId2);
    }

    @Override
    public final long getOtherPlayerId(long id) {
        return this.getModel().getOtherPlayerId(id);
    }

    @Override
    public final RelatedObject getPlayer(String roleTypeUri) {
        DMXObjectModelImpl object = this.getModel().getPlayer(roleTypeUri);
        return object != null ? (RelatedObject)object.instantiate() : null;
    }

    @Override
    public final Topic getTopicByType(String topicTypeUri) {
        TopicModelImpl topic = this.getModel().getTopicByType(topicTypeUri);
        return topic != null ? topic.instantiate() : null;
    }

    @Override
    public final Role getRole(RoleModel roleModel) {
        if (this.getRole1().getModel().refsSameObject(roleModel)) {
            return this.getRole1();
        }
        if (this.getRole2().getModel().refsSameObject(roleModel)) {
            return this.getRole2();
        }
        throw new RuntimeException("Role is not part of association (role=" + roleModel + ", association=" + this);
    }

    @Override
    public final boolean isPlayer(TopicRoleModel roleModel) {
        return this.filterRole(this.getRole1(), roleModel) != null || this.filterRole(this.getRole2(), roleModel) != null;
    }

    @Override
    public final void update(AssociationModel updateModel) {
        this.pl.updateAssociation(this.getModel(), (AssociationModelImpl)updateModel);
    }

    @Override
    public final void delete() {
        this.pl.deleteAssociation(this.getModel());
    }

    @Override
    public final Association loadChildTopics() {
        super.loadChildTopics();
        return this;
    }

    @Override
    public final Association loadChildTopics(String assocDefUri) {
        super.loadChildTopics(assocDefUri);
        return this;
    }

    @Override
    public AssociationModelImpl getModel() {
        return (AssociationModelImpl)this.model;
    }

    @Override
    public final List<RelatedTopic> getRelatedTopics(List assocTypeUris, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri) {
        return this.pl.instantiate(this.pl.getAssociationRelatedTopics(this.getId(), assocTypeUris, myRoleTypeUri, othersRoleTypeUri, othersTopicTypeUri));
    }

    @Override
    public final RelatedAssociation getRelatedAssociation(String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersAssocTypeUri) {
        RelatedAssociationModelImpl assoc = this.pl.getAssociationRelatedAssociation(this.getId(), assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersAssocTypeUri);
        return assoc != null ? assoc.instantiate() : null;
    }

    @Override
    public final List<RelatedAssociation> getRelatedAssociations(String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersAssocTypeUri) {
        return this.pl.instantiate(this.pl.getAssociationRelatedAssociations(this.getId(), assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersAssocTypeUri));
    }

    @Override
    public final Association getAssociation(String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, long othersTopicId) {
        return this.pl.getAssociationBetweenTopicAndAssociation(assocTypeUri, othersTopicId, this.getId(), othersRoleTypeUri, myRoleTypeUri);
    }

    @Override
    public final List<Association> getAssociations() {
        return this.pl.instantiate(this.pl.getAssociationAssociations(this.getId()));
    }

    private final TopicRole filterRole(Role role, TopicRoleModel roleModel) {
        return role instanceof TopicRole && role.getRoleTypeUri().equals(roleModel.getRoleTypeUri()) && role.getPlayerId() == roleModel.getPlayerId() ? (TopicRole)role : null;
    }
}

