/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.topicmaps;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;

public class ClusterCoords
implements Iterable<Entry> {
    private List<Entry> entries = new ArrayList<Entry>();
    private Logger logger = Logger.getLogger(this.getClass().getName());

    public ClusterCoords(JSONArray entries) {
        try {
            for (int i = 0; i < entries.length(); ++i) {
                JSONObject entry = entries.getJSONObject(i);
                this.entries.add(new Entry(entry.getLong("topicId"), entry.getInt("x"), entry.getInt("y")));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Parsing ClusterCoords failed (JSONArray=" + entries + ")", e);
        }
    }

    @Override
    public Iterator<Entry> iterator() {
        return this.entries.iterator();
    }

    public class Entry {
        public long topicId;
        public int x;
        public int y;

        private Entry(long topicId, int x, int y) {
            this.topicId = topicId;
            this.x = x;
            this.y = y;
        }
    }
}

