/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.topicmaps.model;

import java.awt.Point;
import java.util.Map;
import java.util.logging.Logger;
import org.codehaus.jettison.json.JSONObject;
import systems.dmx.core.JSONEnabled;
import systems.dmx.core.model.TopicModel;
import systems.dmx.core.model.topicmaps.AssociationViewModel;
import systems.dmx.core.model.topicmaps.TopicViewModel;
import systems.dmx.core.util.DMXUtils;

public class TopicmapViewmodel
implements JSONEnabled {
    private TopicModel topicmapTopic;
    private Map<Long, TopicViewModel> topics;
    private Map<Long, AssociationViewModel> assocs;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    public TopicmapViewmodel(TopicModel topicmapTopic, Map<Long, TopicViewModel> topics, Map<Long, AssociationViewModel> assocs) {
        this.topicmapTopic = topicmapTopic;
        this.topics = topics;
        this.assocs = assocs;
    }

    public long getId() {
        return this.topicmapTopic.getId();
    }

    public Iterable<TopicViewModel> getTopics() {
        return this.topics.values();
    }

    public Iterable<AssociationViewModel> getAssociations() {
        return this.assocs.values();
    }

    public TopicViewModel getTopic(long id) {
        return this.topics.get(id);
    }

    public AssociationViewModel getAssociation(long id) {
        return this.assocs.get(id);
    }

    public JSONObject toJSON() {
        try {
            return new JSONObject().put("info", (Object)this.topicmapTopic.toJSON()).put("topics", (Object)DMXUtils.toJSONArray(this.topics.values())).put("assocs", (Object)DMXUtils.toJSONArray(this.assocs.values()));
        }
        catch (Exception e) {
            throw new RuntimeException("Serialization failed", e);
        }
    }

    public String toString() {
        return "topicmap " + this.getId();
    }

    public class GridPositioning {
        private final int GRID_DIST_X = 220;
        private final int GRID_DIST_Y = 80;
        private final int START_X;
        private final int START_Y = 50;
        private final int MIN_Y = -9999;
        private final int canvasWidth;
        private final int transX;
        private int gridX;
        private int gridY;

        public GridPositioning(int canvasWidth, int transX) {
            this.canvasWidth = canvasWidth;
            this.transX = transX;
            this.START_X = 50 - transX;
            Point startPos = this.findStartPostition();
            this.gridX = startPos.x;
            this.gridY = startPos.y;
        }

        public Point nextPosition() {
            Point pos = new Point(this.gridX, this.gridY);
            this.advancePosition();
            return pos;
        }

        private Point findStartPostition() {
            int maxY = -9999;
            for (TopicViewModel topic : TopicmapViewmodel.this.topics.values()) {
                if (topic.getY() <= maxY) continue;
                maxY = topic.getY();
            }
            int x = this.START_X;
            int y = maxY != -9999 ? maxY + 80 : 50;
            return new Point(x, y);
        }

        private void advancePosition() {
            if (this.gridX + 220 + this.transX > this.canvasWidth) {
                this.gridX = this.START_X;
                this.gridY += 80;
            } else {
                this.gridX += 220;
            }
        }
    }
}

